/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.oplink;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.onosproject.drivers.utilities.XmlConfigParser;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.netconf.DatastoreId;
import org.onosproject.netconf.NetconfController;
import org.onosproject.netconf.NetconfException;
import org.onosproject.netconf.NetconfSession;

public final class OplinkNetconfUtility {
    public static final String CFG_MODE_MERGE = "merge";
    public static final String CFG_MODE_REMOVE = "remove";
    public static final String KEY_XMLNS = "xmlns=\"http://com/att/device\"";
    public static final String KEY_DATA = "data";
    public static final String KEY_OPENOPTICALDEV = "open-optical-device";
    public static final String KEY_CONNS = "connections";
    public static final String KEY_CONNID = "connection-id";
    public static final String KEY_PORTS = "ports";
    public static final String KEY_PORTID = "port-id";
    public static final String KEY_PORT = "port";
    public static final String KEY_PORTDIRECT = "port-direction";
    public static final String KEY_CHATT = "attenuation";
    public static final String KEY_DATA_CONNS = String.format("%s.%s.%s", "data", "open-optical-device", "connections");
    public static final String KEY_DATA_PORTS = String.format("%s.%s.%s", "data", "open-optical-device", "ports");
    public static final String KEY_OPENOPTICALDEV_XMLNS = String.format("%s %s", "open-optical-device", "xmlns=\"http://com/att/device\"");

    private OplinkNetconfUtility() {
    }

    public static String netconfGet(DriverHandler handler, String filter) {
        String reply;
        NetconfController controller = (NetconfController)Preconditions.checkNotNull((Object)handler.get(NetconfController.class));
        NetconfSession session = controller.getNetconfDevice(handler.data().deviceId()).getSession();
        try {
            reply = session.get(filter, null);
        }
        catch (IOException e) {
            throw new RuntimeException((Throwable)new NetconfException("Failed to retrieve configuration.", (Throwable)e));
        }
        return reply;
    }

    public static String netconfGetConfig(DriverHandler handler, String filter) {
        String reply;
        NetconfController controller = (NetconfController)Preconditions.checkNotNull((Object)handler.get(NetconfController.class));
        NetconfSession session = controller.getNetconfDevice(handler.data().deviceId()).getSession();
        try {
            reply = session.getConfig(DatastoreId.RUNNING, filter);
        }
        catch (IOException e) {
            throw new RuntimeException((Throwable)new NetconfException("Failed to retrieve configuration.", (Throwable)e));
        }
        return reply;
    }

    public static boolean netconfEditConfig(DriverHandler handler, String mode, String cfg) {
        NetconfController controller = (NetconfController)Preconditions.checkNotNull((Object)handler.get(NetconfController.class));
        NetconfSession session = controller.getNetconfDevice(handler.data().deviceId()).getSession();
        boolean reply = false;
        try {
            reply = session.editConfig(DatastoreId.RUNNING, mode, cfg);
        }
        catch (IOException e) {
            throw new RuntimeException((Throwable)new NetconfException("Failed to edit configuration.", (Throwable)e));
        }
        return reply;
    }

    public static HierarchicalConfiguration configAt(String content, String key) {
        SubnodeConfiguration info;
        try {
            HierarchicalConfiguration cfg = XmlConfigParser.loadXmlString((String)content);
            info = cfg.configurationAt(key);
        }
        catch (Exception e) {
            return null;
        }
        return info;
    }

    public static List<HierarchicalConfiguration> configsAt(String content, String key) {
        List info;
        try {
            HierarchicalConfiguration cfg = XmlConfigParser.loadXmlString((String)content);
            info = cfg.configurationsAt(key);
        }
        catch (Exception e) {
            return ImmutableList.of();
        }
        return info;
    }

    public static String xml(String node, String content) {
        return String.format("<%s>%s</%s>", node, content, node);
    }

    public static String xmlOpen(String node) {
        return String.format("<%s>", node);
    }

    public static String xmlClose(String node) {
        return String.format("</%s>", node);
    }

    public static String xmlEmpty(String node) {
        return String.format("<%s/>", node);
    }
}

