/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc.virtualport.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.util.KryoNamespace;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.AbstractListenerManager;
import org.onosproject.event.Event;
import org.onosproject.event.EventSink;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Host;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.store.service.EventuallyConsistentMapEvent;
import org.onosproject.store.service.EventuallyConsistentMapListener;
import org.onosproject.store.service.MultiValuedTimestamp;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.WallClockTimestamp;
import org.onosproject.vtnrsc.AllowedAddressPair;
import org.onosproject.vtnrsc.BindingHostId;
import org.onosproject.vtnrsc.DefaultFloatingIp;
import org.onosproject.vtnrsc.DefaultVirtualPort;
import org.onosproject.vtnrsc.FixedIp;
import org.onosproject.vtnrsc.FloatingIp;
import org.onosproject.vtnrsc.FloatingIpId;
import org.onosproject.vtnrsc.RouterId;
import org.onosproject.vtnrsc.SecurityGroup;
import org.onosproject.vtnrsc.SubnetId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnrsc.TenantNetwork;
import org.onosproject.vtnrsc.TenantNetworkId;
import org.onosproject.vtnrsc.TenantRouter;
import org.onosproject.vtnrsc.VirtualPort;
import org.onosproject.vtnrsc.VirtualPortId;
import org.onosproject.vtnrsc.tenantnetwork.TenantNetworkService;
import org.onosproject.vtnrsc.virtualport.VirtualPortEvent;
import org.onosproject.vtnrsc.virtualport.VirtualPortListener;
import org.onosproject.vtnrsc.virtualport.VirtualPortService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class VirtualPortManager
extends AbstractListenerManager<VirtualPortEvent, VirtualPortListener>
implements VirtualPortService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String VIRTUALPORT = "vtn-virtual-port-store";
    private static final String VTNRSC_APP = "org.onosproject.vtnrsc";
    private static final String VIRTUALPORT_ID_NULL = "VirtualPort ID cannot be null";
    private static final String VIRTUALPORT_NOT_NULL = "VirtualPort  cannot be null";
    private static final String TENANTID_NOT_NULL = "TenantId  cannot be null";
    private static final String NETWORKID_NOT_NULL = "NetworkId  cannot be null";
    private static final String DEVICEID_NOT_NULL = "DeviceId  cannot be null";
    private static final String FIXEDIP_NOT_NULL = "FixedIp  cannot be null";
    private static final String MAC_NOT_NULL = "Mac address  cannot be null";
    private static final String IP_NOT_NULL = "Ip  cannot be null";
    private static final String EVENT_NOT_NULL = "event cannot be null";
    protected EventuallyConsistentMap<VirtualPortId, VirtualPort> vPortStore;
    protected ApplicationId appId;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TenantNetworkService networkService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    private EventuallyConsistentMapListener<VirtualPortId, VirtualPort> virtualPortListener = new InnerVirtualPortStoreListener();

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication(VTNRSC_APP);
        this.eventDispatcher.addSink(VirtualPortEvent.class, (EventSink)this.listenerRegistry);
        KryoNamespace.Builder serializer = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{MultiValuedTimestamp.class}).register(new Class[]{TenantNetworkId.class}).register(new Class[]{Host.class}).register(new Class[]{TenantNetwork.class}).register(new Class[]{TenantNetworkId.class}).register(new Class[]{TenantId.class}).register(new Class[]{SubnetId.class}).register(new Class[]{VirtualPortId.class}).register(new Class[]{VirtualPort.State.class}).register(new Class[]{AllowedAddressPair.class}).register(new Class[]{FixedIp.class}).register(new Class[]{FloatingIp.class}).register(new Class[]{FloatingIpId.class}).register(new Class[]{FloatingIp.Status.class}).register(new Class[]{UUID.class}).register(new Class[]{DefaultFloatingIp.class}).register(new Class[]{BindingHostId.class}).register(new Class[]{SecurityGroup.class}).register(new Class[]{IpAddress.class}).register(new Class[]{DefaultVirtualPort.class}).register(new Class[]{RouterId.class}).register(new Class[]{TenantRouter.class}).register(new Class[]{VirtualPort.class});
        this.vPortStore = this.storageService.eventuallyConsistentMapBuilder().withName(VIRTUALPORT).withSerializer(serializer).withTimestampProvider((k, v) -> new WallClockTimestamp()).build();
        this.vPortStore.addListener(this.virtualPortListener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.vPortStore.removeListener(this.virtualPortListener);
        this.vPortStore.destroy();
        this.log.info("Stoppped");
    }

    @Override
    public boolean exists(VirtualPortId vPortId) {
        Preconditions.checkNotNull((Object)((Object)vPortId), (Object)VIRTUALPORT_ID_NULL);
        return this.vPortStore.containsKey((Object)vPortId);
    }

    @Override
    public VirtualPort getPort(VirtualPortId vPortId) {
        Preconditions.checkNotNull((Object)((Object)vPortId), (Object)VIRTUALPORT_ID_NULL);
        return (VirtualPort)this.vPortStore.get((Object)vPortId);
    }

    @Override
    public VirtualPort getPort(FixedIp fixedIP) {
        Preconditions.checkNotNull((Object)fixedIP, (Object)FIXEDIP_NOT_NULL);
        ArrayList vPorts = new ArrayList();
        this.vPortStore.values().forEach(p -> {
            Iterator<FixedIp> fixedIps = p.fixedIps().iterator();
            while (fixedIps.hasNext()) {
                if (!fixedIps.next().equals(fixedIP)) continue;
                vPorts.add(p);
                break;
            }
        });
        if (vPorts.isEmpty()) {
            return null;
        }
        return (VirtualPort)vPorts.get(0);
    }

    @Override
    public VirtualPort getPort(MacAddress mac) {
        Preconditions.checkNotNull((Object)mac, (Object)MAC_NOT_NULL);
        ArrayList vPorts = new ArrayList();
        this.vPortStore.values().forEach(p -> {
            if (p.macAddress().equals((Object)mac)) {
                vPorts.add(p);
            }
        });
        if (vPorts.isEmpty()) {
            return null;
        }
        return (VirtualPort)vPorts.get(0);
    }

    @Override
    public VirtualPort getPort(TenantNetworkId networkId, IpAddress ip) {
        Preconditions.checkNotNull((Object)((Object)networkId), (Object)NETWORKID_NOT_NULL);
        Preconditions.checkNotNull((Object)ip, (Object)IP_NOT_NULL);
        ArrayList vPorts = new ArrayList();
        this.vPortStore.values().stream().filter(p -> p.networkId().equals((Object)networkId)).forEach(p -> {
            Iterator<FixedIp> fixedIps = p.fixedIps().iterator();
            while (fixedIps.hasNext()) {
                if (!fixedIps.next().ip().equals((Object)ip)) continue;
                vPorts.add(p);
                break;
            }
        });
        if (vPorts.isEmpty()) {
            return null;
        }
        return (VirtualPort)vPorts.get(0);
    }

    @Override
    public Collection<VirtualPort> getPorts() {
        return Collections.unmodifiableCollection(this.vPortStore.values());
    }

    @Override
    public Collection<VirtualPort> getPorts(TenantNetworkId networkId) {
        Preconditions.checkNotNull((Object)((Object)networkId), (Object)NETWORKID_NOT_NULL);
        return this.vPortStore.values().stream().filter(d -> d.networkId().equals((Object)networkId)).collect(Collectors.toList());
    }

    @Override
    public Collection<VirtualPort> getPorts(TenantId tenantId) {
        Preconditions.checkNotNull((Object)((Object)tenantId), (Object)TENANTID_NOT_NULL);
        return this.vPortStore.values().stream().filter(d -> d.tenantId().equals((Object)tenantId)).collect(Collectors.toList());
    }

    @Override
    public Collection<VirtualPort> getPorts(DeviceId deviceId) {
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICEID_NOT_NULL);
        return this.vPortStore.values().stream().filter(d -> d.deviceId().equals((Object)deviceId)).collect(Collectors.toList());
    }

    @Override
    public boolean createPorts(Iterable<VirtualPort> vPorts) {
        Preconditions.checkNotNull(vPorts, (Object)VIRTUALPORT_NOT_NULL);
        for (VirtualPort vPort : vPorts) {
            this.log.debug("vPortId is  {} ", (Object)vPort.portId().toString());
            this.vPortStore.put((Object)vPort.portId(), (Object)vPort);
            if (this.vPortStore.containsKey((Object)vPort.portId())) continue;
            this.log.debug("The virtualPort is created failed whose identifier is {} ", (Object)vPort.portId().toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean updatePorts(Iterable<VirtualPort> vPorts) {
        Preconditions.checkNotNull(vPorts, (Object)VIRTUALPORT_NOT_NULL);
        for (VirtualPort vPort : vPorts) {
            this.vPortStore.put((Object)vPort.portId(), (Object)vPort);
            if (!this.vPortStore.containsKey((Object)vPort.portId())) {
                this.log.debug("The virtualPort is not exist whose identifier is {}", (Object)vPort.portId().toString());
                return false;
            }
            this.vPortStore.put((Object)vPort.portId(), (Object)vPort);
            if (vPort.equals(this.vPortStore.get((Object)vPort.portId()))) continue;
            this.log.debug("The virtualPort is updated failed whose  identifier is {}", (Object)vPort.portId().toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean removePorts(Iterable<VirtualPortId> vPortIds) {
        Preconditions.checkNotNull(vPortIds, (Object)VIRTUALPORT_ID_NULL);
        for (VirtualPortId vPortId : vPortIds) {
            this.vPortStore.remove((Object)vPortId);
            if (!this.vPortStore.containsKey((Object)vPortId)) continue;
            this.log.debug("The virtualPort is removed failed whose identifier is {}", (Object)vPortId.toString());
            return false;
        }
        return true;
    }

    private void notifyListeners(VirtualPortEvent event) {
        Preconditions.checkNotNull((Object)((Object)event), (Object)EVENT_NOT_NULL);
        this.post((Event)event);
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindNetworkService(TenantNetworkService tenantNetworkService) {
        this.networkService = tenantNetworkService;
    }

    protected void unbindNetworkService(TenantNetworkService tenantNetworkService) {
        if (this.networkService == tenantNetworkService) {
            this.networkService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    private class InnerVirtualPortStoreListener
    implements EventuallyConsistentMapListener<VirtualPortId, VirtualPort> {
        private InnerVirtualPortStoreListener() {
        }

        public void event(EventuallyConsistentMapEvent<VirtualPortId, VirtualPort> event) {
            Preconditions.checkNotNull(event, (Object)VirtualPortManager.EVENT_NOT_NULL);
            VirtualPortManager.this.log.info("virtual port event raised");
            VirtualPort virtualPort = (VirtualPort)event.value();
            if (EventuallyConsistentMapEvent.Type.PUT == event.type()) {
                VirtualPortManager.this.notifyListeners(new VirtualPortEvent(VirtualPortEvent.Type.VIRTUAL_PORT_PUT, virtualPort));
            }
            if (EventuallyConsistentMapEvent.Type.REMOVE == event.type()) {
                VirtualPortManager.this.notifyListeners(new VirtualPortEvent(VirtualPortEvent.Type.VIRTUAL_PORT_DELETE, virtualPort));
            }
        }
    }
}

