/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc.service.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.util.KryoNamespace;
import org.onosproject.core.CoreService;
import org.onosproject.event.AbstractListenerManager;
import org.onosproject.event.Event;
import org.onosproject.event.EventSink;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.host.HostService;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.store.service.LogicalClockService;
import org.onosproject.store.service.StorageService;
import org.onosproject.vtnrsc.FixedIp;
import org.onosproject.vtnrsc.FloatingIp;
import org.onosproject.vtnrsc.FlowClassifier;
import org.onosproject.vtnrsc.PortChain;
import org.onosproject.vtnrsc.PortPair;
import org.onosproject.vtnrsc.PortPairGroup;
import org.onosproject.vtnrsc.PortPairId;
import org.onosproject.vtnrsc.Router;
import org.onosproject.vtnrsc.RouterId;
import org.onosproject.vtnrsc.RouterInterface;
import org.onosproject.vtnrsc.SegmentationId;
import org.onosproject.vtnrsc.Subnet;
import org.onosproject.vtnrsc.SubnetId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnrsc.TenantRouter;
import org.onosproject.vtnrsc.VirtualPort;
import org.onosproject.vtnrsc.VirtualPortId;
import org.onosproject.vtnrsc.event.VtnRscEvent;
import org.onosproject.vtnrsc.event.VtnRscEventFeedback;
import org.onosproject.vtnrsc.event.VtnRscListener;
import org.onosproject.vtnrsc.floatingip.FloatingIpEvent;
import org.onosproject.vtnrsc.floatingip.FloatingIpListener;
import org.onosproject.vtnrsc.floatingip.FloatingIpService;
import org.onosproject.vtnrsc.flowclassifier.FlowClassifierEvent;
import org.onosproject.vtnrsc.flowclassifier.FlowClassifierListener;
import org.onosproject.vtnrsc.flowclassifier.FlowClassifierService;
import org.onosproject.vtnrsc.portchain.PortChainEvent;
import org.onosproject.vtnrsc.portchain.PortChainListener;
import org.onosproject.vtnrsc.portchain.PortChainService;
import org.onosproject.vtnrsc.portpair.PortPairEvent;
import org.onosproject.vtnrsc.portpair.PortPairListener;
import org.onosproject.vtnrsc.portpair.PortPairService;
import org.onosproject.vtnrsc.portpairgroup.PortPairGroupEvent;
import org.onosproject.vtnrsc.portpairgroup.PortPairGroupListener;
import org.onosproject.vtnrsc.portpairgroup.PortPairGroupService;
import org.onosproject.vtnrsc.router.RouterEvent;
import org.onosproject.vtnrsc.router.RouterListener;
import org.onosproject.vtnrsc.router.RouterService;
import org.onosproject.vtnrsc.routerinterface.RouterInterfaceEvent;
import org.onosproject.vtnrsc.routerinterface.RouterInterfaceListener;
import org.onosproject.vtnrsc.routerinterface.RouterInterfaceService;
import org.onosproject.vtnrsc.service.VtnRscService;
import org.onosproject.vtnrsc.subnet.SubnetService;
import org.onosproject.vtnrsc.tenantnetwork.TenantNetworkService;
import org.onosproject.vtnrsc.virtualport.VirtualPortEvent;
import org.onosproject.vtnrsc.virtualport.VirtualPortListener;
import org.onosproject.vtnrsc.virtualport.VirtualPortService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class VtnRscManager
extends AbstractListenerManager<VtnRscEvent, VtnRscListener>
implements VtnRscService {
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LogicalClockService clockService;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private FloatingIpListener floatingIpListener = new InnerFloatingIpListener();
    private RouterListener routerListener = new InnerRouterListener();
    private RouterInterfaceListener routerInterfaceListener = new InnerRouterInterfaceListener();
    private PortPairListener portPairListener = new InnerPortPairListener();
    private PortPairGroupListener portPairGroupListener = new InnerPortPairGroupListener();
    private FlowClassifierListener flowClassifierListener = new InnerFlowClassifierListener();
    private PortChainListener portChainListener = new InnerPortChainListener();
    private VirtualPortListener virtualPortListener = new InnerVirtualPortListener();
    private EventuallyConsistentMap<TenantId, SegmentationId> l3vniTenantMap;
    private EventuallyConsistentMap<TenantRouter, SegmentationId> l3vniTenantRouterMap;
    private EventuallyConsistentMap<TenantId, Set<DeviceId>> classifierOvsMap;
    private EventuallyConsistentMap<TenantId, Set<DeviceId>> sffOvsMap;
    private static final String IFACEID = "ifaceid";
    private static final String RUNNELOPTOPOIC = "tunnel-ops-ids";
    private static final String EVENT_NOT_NULL = "event cannot be null";
    private static final String TENANTID_NOT_NULL = "tenantId cannot be null";
    private static final String DEVICEID_NOT_NULL = "deviceId cannot be null";
    private static final String VIRTUALPORTID_NOT_NULL = "virtualPortId cannot be null";
    private static final String HOST_NOT_NULL = "host cannot be null";
    private static final String L3VNITENANTMAP = "l3vniTenantMap";
    private static final String L3VNITENANTROUTERMAP = "l3vniTenantRouterMap";
    private static final String CLASSIFIEROVSMAP = "classifierOvsMap";
    private static final String SFFOVSMAP = "sffOvsMap";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected RouterService routerService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FloatingIpService floatingIpService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected RouterInterfaceService routerInterfaceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected VirtualPortService virtualPortService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected SubnetService subnetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TenantNetworkService tenantNetworkService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PortPairService portPairService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PortPairGroupService portPairGroupService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowClassifierService flowClassifierService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PortChainService portChainService;

    @Activate
    public void activate() {
        this.eventDispatcher.addSink(VtnRscEvent.class, (EventSink)this.listenerRegistry);
        this.floatingIpService.addListener(this.floatingIpListener);
        this.routerService.addListener(this.routerListener);
        this.routerInterfaceService.addListener(this.routerInterfaceListener);
        this.portPairService.addListener(this.portPairListener);
        this.portPairGroupService.addListener(this.portPairGroupListener);
        this.flowClassifierService.addListener(this.flowClassifierListener);
        this.portChainService.addListener(this.portChainListener);
        this.virtualPortService.addListener(this.virtualPortListener);
        KryoNamespace.Builder serializer = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{TenantId.class, DeviceId.class, SegmentationId.class, TenantRouter.class, RouterId.class});
        this.l3vniTenantMap = this.storageService.eventuallyConsistentMapBuilder().withName(L3VNITENANTMAP).withSerializer(serializer).withTimestampProvider((k, v) -> this.clockService.getTimestamp()).build();
        this.l3vniTenantRouterMap = this.storageService.eventuallyConsistentMapBuilder().withName(L3VNITENANTROUTERMAP).withSerializer(serializer).withTimestampProvider((k, v) -> this.clockService.getTimestamp()).build();
        this.classifierOvsMap = this.storageService.eventuallyConsistentMapBuilder().withName(CLASSIFIEROVSMAP).withSerializer(serializer).withTimestampProvider((k, v) -> this.clockService.getTimestamp()).build();
        this.sffOvsMap = this.storageService.eventuallyConsistentMapBuilder().withName(SFFOVSMAP).withSerializer(serializer).withTimestampProvider((k, v) -> this.clockService.getTimestamp()).build();
    }

    @Deactivate
    public void deactivate() {
        this.eventDispatcher.removeSink(VtnRscEvent.class);
        this.floatingIpService.removeListener(this.floatingIpListener);
        this.routerService.removeListener(this.routerListener);
        this.routerInterfaceService.removeListener(this.routerInterfaceListener);
        this.portPairService.removeListener(this.portPairListener);
        this.portPairGroupService.removeListener(this.portPairGroupListener);
        this.flowClassifierService.removeListener(this.flowClassifierListener);
        this.portChainService.removeListener(this.portChainListener);
        this.virtualPortService.removeListener(this.virtualPortListener);
        this.l3vniTenantMap.destroy();
        this.l3vniTenantRouterMap.destroy();
        this.classifierOvsMap.destroy();
        this.sffOvsMap.destroy();
        this.log.info("Stopped");
    }

    @Override
    public SegmentationId getL3vni(TenantId tenantId) {
        Preconditions.checkNotNull((Object)((Object)tenantId), (Object)TENANTID_NOT_NULL);
        SegmentationId l3vni = (SegmentationId)((Object)this.l3vniTenantMap.get((Object)tenantId));
        if (l3vni == null) {
            long segmentationId = this.coreService.getIdGenerator(RUNNELOPTOPOIC).getNewId();
            l3vni = SegmentationId.segmentationId(String.valueOf(segmentationId));
            this.l3vniTenantMap.put((Object)tenantId, (Object)l3vni);
        }
        return l3vni;
    }

    @Override
    public SegmentationId getL3vni(TenantRouter tenantRouter) {
        Preconditions.checkNotNull((Object)tenantRouter, (Object)"tenantRouter cannot be null");
        SegmentationId l3vni = (SegmentationId)((Object)this.l3vniTenantRouterMap.get((Object)tenantRouter));
        if (l3vni == null) {
            long segmentationId = this.coreService.getIdGenerator(RUNNELOPTOPOIC).getNewId();
            l3vni = SegmentationId.segmentationId(String.valueOf(segmentationId));
            this.l3vniTenantRouterMap.put((Object)tenantRouter, (Object)l3vni);
        }
        return l3vni;
    }

    @Override
    public Iterator<Device> getClassifierOfTenant(TenantId tenantId) {
        Preconditions.checkNotNull((Object)((Object)tenantId), (Object)TENANTID_NOT_NULL);
        Set deviceIdSet = (Set)this.classifierOvsMap.get((Object)tenantId);
        HashSet<Device> deviceSet = new HashSet<Device>();
        if (deviceIdSet != null) {
            for (DeviceId deviceId : deviceIdSet) {
                deviceSet.add(this.deviceService.getDevice(deviceId));
            }
        }
        return deviceSet.iterator();
    }

    @Override
    public Iterator<Device> getSffOfTenant(TenantId tenantId) {
        Preconditions.checkNotNull((Object)((Object)tenantId), (Object)TENANTID_NOT_NULL);
        Set deviceIdSet = (Set)this.sffOvsMap.get((Object)tenantId);
        HashSet<Device> deviceSet = new HashSet<Device>();
        if (deviceIdSet != null) {
            for (DeviceId deviceId : deviceIdSet) {
                deviceSet.add(this.deviceService.getDevice(deviceId));
            }
        }
        return deviceSet.iterator();
    }

    @Override
    public MacAddress getGatewayMac(HostId hostId) {
        Preconditions.checkNotNull((Object)hostId, (Object)"hostId cannot be null");
        Host host = this.hostService.getHost(hostId);
        String ifaceId = host.annotations().value(IFACEID);
        VirtualPortId hPortId = VirtualPortId.portId(ifaceId);
        VirtualPort hPort = this.virtualPortService.getPort(hPortId);
        SubnetId subnetId = hPort.fixedIps().iterator().next().subnetId();
        Subnet subnet = this.subnetService.getSubnet(subnetId);
        IpAddress gatewayIp = subnet.gatewayIp();
        Collection<VirtualPort> virtualPorts = this.virtualPortService.getPorts();
        MacAddress macAddress = null;
        for (VirtualPort port : virtualPorts) {
            Set<FixedIp> fixedIpSet = port.fixedIps();
            for (FixedIp fixedIp : fixedIpSet) {
                if (!fixedIp.ip().equals((Object)gatewayIp)) continue;
                macAddress = port.macAddress();
            }
        }
        return macAddress;
    }

    @Override
    public boolean isServiceFunction(VirtualPortId portId) {
        return this.portPairService.exists(PortPairId.of(portId.portId()));
    }

    @Override
    public DeviceId getSfToSffMaping(VirtualPortId portId) {
        Preconditions.checkNotNull((Object)((Object)portId), (Object)"portId cannot be null");
        VirtualPort vmPort = this.virtualPortService.getPort(portId);
        Set hostSet = this.hostService.getHostsByMac(vmPort.macAddress());
        for (Host host : hostSet) {
            if (!host.annotations().value(IFACEID).equals(vmPort.portId().portId())) continue;
            return host.location().deviceId();
        }
        return null;
    }

    @Override
    public void addDeviceIdOfOvsMap(VirtualPortId virtualPortId, TenantId tenantId, DeviceId deviceId) {
        Preconditions.checkNotNull((Object)((Object)virtualPortId), (Object)VIRTUALPORTID_NOT_NULL);
        Preconditions.checkNotNull((Object)((Object)tenantId), (Object)TENANTID_NOT_NULL);
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICEID_NOT_NULL);
        if (this.isServiceFunction(virtualPortId)) {
            this.addDeviceIdToSpecificMap(tenantId, deviceId, this.sffOvsMap);
        } else {
            this.addDeviceIdToSpecificMap(tenantId, deviceId, this.classifierOvsMap);
        }
    }

    @Override
    public void removeDeviceIdOfOvsMap(Host host, TenantId tenantId, DeviceId deviceId) {
        Preconditions.checkNotNull((Object)host, (Object)HOST_NOT_NULL);
        Preconditions.checkNotNull((Object)((Object)tenantId), (Object)TENANTID_NOT_NULL);
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICEID_NOT_NULL);
        if (this.isLastSFHostOfTenant(host, deviceId, tenantId)) {
            this.removeDeviceIdToSpecificMap(tenantId, deviceId, this.sffOvsMap);
        }
        if (this.isLastClassifierHostOfTenant(host, deviceId, tenantId)) {
            this.removeDeviceIdToSpecificMap(tenantId, deviceId, this.classifierOvsMap);
        }
    }

    private boolean isLastSFHostOfTenant(Host host, DeviceId deviceId, TenantId tenantId) {
        Set hostSet = this.hostService.getConnectedHosts(deviceId);
        if (hostSet != null) {
            for (Host h : hostSet) {
                VirtualPortId hPortId;
                String ifaceId = h.annotations().value(IFACEID);
                if (ifaceId == null || !this.virtualPortService.getPort(hPortId = VirtualPortId.portId(ifaceId)).tenantId().tenantId().equals(tenantId.tenantId()) || !this.isServiceFunction(hPortId) || h.equals(host)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isLastClassifierHostOfTenant(Host host, DeviceId deviceId, TenantId tenantId) {
        Set hostSet = this.hostService.getConnectedHosts(deviceId);
        if (hostSet != null) {
            for (Host h : hostSet) {
                VirtualPortId hPortId;
                String ifaceId = h.annotations().value(IFACEID);
                if (ifaceId == null || !this.virtualPortService.getPort(hPortId = VirtualPortId.portId(ifaceId)).tenantId().tenantId().equals(tenantId.tenantId()) || this.isServiceFunction(hPortId) || h.equals(host)) continue;
                return false;
            }
        }
        return true;
    }

    private void addDeviceIdToSpecificMap(TenantId tenantId, DeviceId deviceId, EventuallyConsistentMap<TenantId, Set<DeviceId>> ovsMap) {
        if (ovsMap.containsKey((Object)tenantId)) {
            Set deviceIdSet = (Set)ovsMap.get((Object)tenantId);
            deviceIdSet.add(deviceId);
            ovsMap.put((Object)tenantId, (Object)deviceIdSet);
        } else {
            HashSet<DeviceId> deviceIdSet = new HashSet<DeviceId>();
            deviceIdSet.add(deviceId);
            ovsMap.put((Object)tenantId, deviceIdSet);
        }
    }

    private void removeDeviceIdToSpecificMap(TenantId tenantId, DeviceId deviceId, EventuallyConsistentMap<TenantId, Set<DeviceId>> ovsMap) {
        Set deviceIdSet = (Set)ovsMap.get((Object)tenantId);
        if (deviceIdSet != null && deviceIdSet.size() > 1) {
            deviceIdSet.remove(deviceId);
            ovsMap.put((Object)tenantId, (Object)deviceIdSet);
        } else {
            ovsMap.remove((Object)tenantId);
        }
    }

    private void notifyListeners(VtnRscEvent event) {
        Preconditions.checkNotNull((Object)((Object)event), (Object)EVENT_NOT_NULL);
        this.post((Event)event);
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindClockService(LogicalClockService logicalClockService) {
        this.clockService = logicalClockService;
    }

    protected void unbindClockService(LogicalClockService logicalClockService) {
        if (this.clockService == logicalClockService) {
            this.clockService = null;
        }
    }

    protected void bindRouterService(RouterService routerService) {
        this.routerService = routerService;
    }

    protected void unbindRouterService(RouterService routerService) {
        if (this.routerService == routerService) {
            this.routerService = null;
        }
    }

    protected void bindFloatingIpService(FloatingIpService floatingIpService) {
        this.floatingIpService = floatingIpService;
    }

    protected void unbindFloatingIpService(FloatingIpService floatingIpService) {
        if (this.floatingIpService == floatingIpService) {
            this.floatingIpService = null;
        }
    }

    protected void bindRouterInterfaceService(RouterInterfaceService routerInterfaceService) {
        this.routerInterfaceService = routerInterfaceService;
    }

    protected void unbindRouterInterfaceService(RouterInterfaceService routerInterfaceService) {
        if (this.routerInterfaceService == routerInterfaceService) {
            this.routerInterfaceService = null;
        }
    }

    protected void bindVirtualPortService(VirtualPortService virtualPortService) {
        this.virtualPortService = virtualPortService;
    }

    protected void unbindVirtualPortService(VirtualPortService virtualPortService) {
        if (this.virtualPortService == virtualPortService) {
            this.virtualPortService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    protected void bindSubnetService(SubnetService subnetService) {
        this.subnetService = subnetService;
    }

    protected void unbindSubnetService(SubnetService subnetService) {
        if (this.subnetService == subnetService) {
            this.subnetService = null;
        }
    }

    protected void bindTenantNetworkService(TenantNetworkService tenantNetworkService) {
        this.tenantNetworkService = tenantNetworkService;
    }

    protected void unbindTenantNetworkService(TenantNetworkService tenantNetworkService) {
        if (this.tenantNetworkService == tenantNetworkService) {
            this.tenantNetworkService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindPortPairService(PortPairService portPairService) {
        this.portPairService = portPairService;
    }

    protected void unbindPortPairService(PortPairService portPairService) {
        if (this.portPairService == portPairService) {
            this.portPairService = null;
        }
    }

    protected void bindPortPairGroupService(PortPairGroupService portPairGroupService) {
        this.portPairGroupService = portPairGroupService;
    }

    protected void unbindPortPairGroupService(PortPairGroupService portPairGroupService) {
        if (this.portPairGroupService == portPairGroupService) {
            this.portPairGroupService = null;
        }
    }

    protected void bindFlowClassifierService(FlowClassifierService flowClassifierService) {
        this.flowClassifierService = flowClassifierService;
    }

    protected void unbindFlowClassifierService(FlowClassifierService flowClassifierService) {
        if (this.flowClassifierService == flowClassifierService) {
            this.flowClassifierService = null;
        }
    }

    protected void bindPortChainService(PortChainService portChainService) {
        this.portChainService = portChainService;
    }

    protected void unbindPortChainService(PortChainService portChainService) {
        if (this.portChainService == portChainService) {
            this.portChainService = null;
        }
    }

    private class InnerVirtualPortListener
    implements VirtualPortListener {
        private InnerVirtualPortListener() {
        }

        public void event(VirtualPortEvent event) {
            Preconditions.checkNotNull((Object)((Object)event), (Object)VtnRscManager.EVENT_NOT_NULL);
            VirtualPort virtualPort = (VirtualPort)event.subject();
            if (VirtualPortEvent.Type.VIRTUAL_PORT_PUT == event.type()) {
                VtnRscManager.this.notifyListeners(new VtnRscEvent(VtnRscEvent.Type.VIRTUAL_PORT_PUT, new VtnRscEventFeedback(virtualPort)));
            } else if (VirtualPortEvent.Type.VIRTUAL_PORT_DELETE == event.type()) {
                VtnRscManager.this.notifyListeners(new VtnRscEvent(VtnRscEvent.Type.VIRTUAL_PORT_DELETE, new VtnRscEventFeedback(virtualPort)));
            }
        }
    }

    private class InnerPortChainListener
    implements PortChainListener {
        private InnerPortChainListener() {
        }

        public void event(PortChainEvent event) {
            Preconditions.checkNotNull((Object)((Object)event), (Object)VtnRscManager.EVENT_NOT_NULL);
            PortChain portChain = (PortChain)event.subject();
            if (PortChainEvent.Type.PORT_CHAIN_PUT == event.type()) {
                VtnRscManager.this.notifyListeners(new VtnRscEvent(VtnRscEvent.Type.PORT_CHAIN_PUT, new VtnRscEventFeedback(portChain)));
            } else if (PortChainEvent.Type.PORT_CHAIN_DELETE == event.type()) {
                VtnRscManager.this.notifyListeners(new VtnRscEvent(VtnRscEvent.Type.PORT_CHAIN_DELETE, new VtnRscEventFeedback(portChain)));
            } else if (PortChainEvent.Type.PORT_CHAIN_UPDATE == event.type()) {
                VtnRscManager.this.notifyListeners(new VtnRscEvent(VtnRscEvent.Type.PORT_CHAIN_UPDATE, new VtnRscEventFeedback(portChain)));
            }
        }
    }

    private class InnerFlowClassifierListener
    implements FlowClassifierListener {
        private InnerFlowClassifierListener() {
        }

        public void event(FlowClassifierEvent event) {
            Preconditions.checkNotNull((Object)((Object)event), (Object)VtnRscManager.EVENT_NOT_NULL);
            FlowClassifier flowClassifier = (FlowClassifier)event.subject();
            if (FlowClassifierEvent.Type.FLOW_CLASSIFIER_PUT == event.type()) {
                VtnRscManager.this.notifyListeners(new VtnRscEvent(VtnRscEvent.Type.FLOW_CLASSIFIER_PUT, new VtnRscEventFeedback(flowClassifier)));
            } else if (FlowClassifierEvent.Type.FLOW_CLASSIFIER_DELETE == event.type()) {
                VtnRscManager.this.notifyListeners(new VtnRscEvent(VtnRscEvent.Type.FLOW_CLASSIFIER_DELETE, new VtnRscEventFeedback(flowClassifier)));
            } else if (FlowClassifierEvent.Type.FLOW_CLASSIFIER_UPDATE == event.type()) {
                VtnRscManager.this.notifyListeners(new VtnRscEvent(VtnRscEvent.Type.FLOW_CLASSIFIER_UPDATE, new VtnRscEventFeedback(flowClassifier)));
            }
        }
    }

    private class InnerPortPairGroupListener
    implements PortPairGroupListener {
        private InnerPortPairGroupListener() {
        }

        public void event(PortPairGroupEvent event) {
            Preconditions.checkNotNull((Object)((Object)event), (Object)VtnRscManager.EVENT_NOT_NULL);
            PortPairGroup portPairGroup = (PortPairGroup)event.subject();
            if (PortPairGroupEvent.Type.PORT_PAIR_GROUP_PUT == event.type()) {
                VtnRscManager.this.notifyListeners(new VtnRscEvent(VtnRscEvent.Type.PORT_PAIR_GROUP_PUT, new VtnRscEventFeedback(portPairGroup)));
            } else if (PortPairGroupEvent.Type.PORT_PAIR_GROUP_DELETE == event.type()) {
                VtnRscManager.this.notifyListeners(new VtnRscEvent(VtnRscEvent.Type.PORT_PAIR_GROUP_DELETE, new VtnRscEventFeedback(portPairGroup)));
            } else if (PortPairGroupEvent.Type.PORT_PAIR_GROUP_UPDATE == event.type()) {
                VtnRscManager.this.notifyListeners(new VtnRscEvent(VtnRscEvent.Type.PORT_PAIR_GROUP_UPDATE, new VtnRscEventFeedback(portPairGroup)));
            }
        }
    }

    private class InnerPortPairListener
    implements PortPairListener {
        private InnerPortPairListener() {
        }

        public void event(PortPairEvent event) {
            Preconditions.checkNotNull((Object)((Object)event), (Object)VtnRscManager.EVENT_NOT_NULL);
            PortPair portPair = (PortPair)event.subject();
            if (PortPairEvent.Type.PORT_PAIR_PUT == event.type()) {
                VtnRscManager.this.notifyListeners(new VtnRscEvent(VtnRscEvent.Type.PORT_PAIR_PUT, new VtnRscEventFeedback(portPair)));
            } else if (PortPairEvent.Type.PORT_PAIR_DELETE == event.type()) {
                VtnRscManager.this.notifyListeners(new VtnRscEvent(VtnRscEvent.Type.PORT_PAIR_DELETE, new VtnRscEventFeedback(portPair)));
            } else if (PortPairEvent.Type.PORT_PAIR_UPDATE == event.type()) {
                VtnRscManager.this.notifyListeners(new VtnRscEvent(VtnRscEvent.Type.PORT_PAIR_UPDATE, new VtnRscEventFeedback(portPair)));
            }
        }
    }

    private class InnerRouterInterfaceListener
    implements RouterInterfaceListener {
        private InnerRouterInterfaceListener() {
        }

        public void event(RouterInterfaceEvent event) {
            Preconditions.checkNotNull((Object)((Object)event), (Object)VtnRscManager.EVENT_NOT_NULL);
            RouterInterface routerInterface = (RouterInterface)event.subject();
            if (RouterInterfaceEvent.Type.ROUTER_INTERFACE_PUT == event.type()) {
                VtnRscManager.this.notifyListeners(new VtnRscEvent(VtnRscEvent.Type.ROUTER_INTERFACE_PUT, new VtnRscEventFeedback(routerInterface)));
            }
            if (RouterInterfaceEvent.Type.ROUTER_INTERFACE_DELETE == event.type()) {
                VtnRscManager.this.notifyListeners(new VtnRscEvent(VtnRscEvent.Type.ROUTER_INTERFACE_DELETE, new VtnRscEventFeedback(routerInterface)));
            }
        }
    }

    private class InnerRouterListener
    implements RouterListener {
        private InnerRouterListener() {
        }

        public void event(RouterEvent event) {
            Preconditions.checkNotNull((Object)((Object)event), (Object)VtnRscManager.EVENT_NOT_NULL);
            Router router = (Router)event.subject();
            if (RouterEvent.Type.ROUTER_PUT == event.type()) {
                VtnRscManager.this.notifyListeners(new VtnRscEvent(VtnRscEvent.Type.ROUTER_PUT, new VtnRscEventFeedback(router)));
            }
            if (RouterEvent.Type.ROUTER_DELETE == event.type()) {
                VtnRscManager.this.notifyListeners(new VtnRscEvent(VtnRscEvent.Type.ROUTER_DELETE, new VtnRscEventFeedback(router)));
            }
        }
    }

    private class InnerFloatingIpListener
    implements FloatingIpListener {
        private InnerFloatingIpListener() {
        }

        public void event(FloatingIpEvent event) {
            Preconditions.checkNotNull((Object)((Object)event), (Object)VtnRscManager.EVENT_NOT_NULL);
            FloatingIp floatingIp = (FloatingIp)event.subject();
            if (FloatingIpEvent.Type.FLOATINGIP_PUT == event.type()) {
                VtnRscManager.this.notifyListeners(new VtnRscEvent(VtnRscEvent.Type.FLOATINGIP_PUT, new VtnRscEventFeedback(floatingIp)));
            }
            if (FloatingIpEvent.Type.FLOATINGIP_DELETE == event.type()) {
                VtnRscManager.this.notifyListeners(new VtnRscEvent(VtnRscEvent.Type.FLOATINGIP_DELETE, new VtnRscEventFeedback(floatingIp)));
            }
            if (FloatingIpEvent.Type.FLOATINGIP_BIND == event.type()) {
                VtnRscManager.this.notifyListeners(new VtnRscEvent(VtnRscEvent.Type.FLOATINGIP_BIND, new VtnRscEventFeedback(floatingIp)));
            }
            if (FloatingIpEvent.Type.FLOATINGIP_UNBIND == event.type()) {
                VtnRscManager.this.notifyListeners(new VtnRscEvent(VtnRscEvent.Type.FLOATINGIP_UNBIND, new VtnRscEventFeedback(floatingIp)));
            }
        }
    }
}

