/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc.portchainsfmap.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.vtnrsc.PortChain;
import org.onosproject.vtnrsc.PortChainId;
import org.onosproject.vtnrsc.PortPairGroup;
import org.onosproject.vtnrsc.PortPairGroupId;
import org.onosproject.vtnrsc.ServiceFunctionGroup;
import org.onosproject.vtnrsc.portchain.PortChainService;
import org.onosproject.vtnrsc.portchainsfmap.PortChainSfMapService;
import org.onosproject.vtnrsc.portpair.PortPairService;
import org.onosproject.vtnrsc.portpairgroup.PortPairGroupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class PortChainSfMapManager
implements PortChainSfMapService {
    private static final String PORT_CHAIN_ID_NULL = "PortChain ID cannot be null";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PortChainService portChainService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PortPairGroupService portPairGroupService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PortPairService portPairService;

    @Activate
    public void activate() {
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    @Override
    public boolean exists(PortChainId portChainId) {
        Preconditions.checkNotNull((Object)((Object)portChainId), (Object)PORT_CHAIN_ID_NULL);
        return this.portChainService.exists(portChainId);
    }

    @Override
    public List<ServiceFunctionGroup> getServiceFunctions(PortChainId portChainId) {
        ArrayList serviceFunctionGroupList = Lists.newArrayList();
        PortChain portChain = this.portChainService.getPortChain(portChainId);
        List<PortPairGroupId> portPairGrpList = portChain.portPairGroups();
        ListIterator<PortPairGroupId> listGrpIterator = portPairGrpList.listIterator();
        while (listGrpIterator.hasNext()) {
            PortPairGroupId portPairGroupId = listGrpIterator.next();
            PortPairGroup portPairGroup = this.portPairGroupService.getPortPairGroup(portPairGroupId);
            ServiceFunctionGroup sfg = new ServiceFunctionGroup(portPairGroup.name(), portPairGroup.description(), portPairGroup.portPairLoadMap());
            serviceFunctionGroupList.add(sfg);
        }
        return ImmutableList.copyOf((Collection)serviceFunctionGroupList);
    }

    protected void bindPortChainService(PortChainService portChainService) {
        this.portChainService = portChainService;
    }

    protected void unbindPortChainService(PortChainService portChainService) {
        if (this.portChainService == portChainService) {
            this.portChainService = null;
        }
    }

    protected void bindPortPairGroupService(PortPairGroupService portPairGroupService) {
        this.portPairGroupService = portPairGroupService;
    }

    protected void unbindPortPairGroupService(PortPairGroupService portPairGroupService) {
        if (this.portPairGroupService == portPairGroupService) {
            this.portPairGroupService = null;
        }
    }

    protected void bindPortPairService(PortPairService portPairService) {
        this.portPairService = portPairService;
    }

    protected void unbindPortPairService(PortPairService portPairService) {
        if (this.portPairService == portPairService) {
            this.portPairService = null;
        }
    }
}

