/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc.floatingip.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpAddress;
import org.onlab.util.KryoNamespace;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.Event;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.store.service.EventuallyConsistentMapEvent;
import org.onosproject.store.service.EventuallyConsistentMapListener;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.WallClockTimestamp;
import org.onosproject.vtnrsc.DefaultFloatingIp;
import org.onosproject.vtnrsc.FloatingIp;
import org.onosproject.vtnrsc.FloatingIpId;
import org.onosproject.vtnrsc.RouterId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnrsc.TenantNetworkId;
import org.onosproject.vtnrsc.VirtualPortId;
import org.onosproject.vtnrsc.floatingip.FloatingIpEvent;
import org.onosproject.vtnrsc.floatingip.FloatingIpListener;
import org.onosproject.vtnrsc.floatingip.FloatingIpService;
import org.onosproject.vtnrsc.router.RouterService;
import org.onosproject.vtnrsc.tenantnetwork.TenantNetworkService;
import org.onosproject.vtnrsc.virtualport.VirtualPortService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class FloatingIpManager
implements FloatingIpService {
    private static final String FLOATINGIP_ID_NOT_NULL = "Floatingip ID cannot be null";
    private static final String FLOATINGIP_NOT_NULL = "Floatingip cannot be null";
    private static final String FLOATINGIPSTORE = "vtn-floatingip-store";
    private static final String FLOATINGIPBINDSTORE = "vtn-floatingip-bind-store";
    private static final String VTNRSC_APP = "org.onosproject.vtnrsc";
    private static final String LISTENER_NOT_NULL = "Listener cannot be null";
    private static final String EVENT_NOT_NULL = "event cannot be null";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Set<FloatingIpListener> listeners = Sets.newCopyOnWriteArraySet();
    private EventuallyConsistentMapListener<FloatingIpId, FloatingIp> floatingIpListener = new InnerFloatingIpStoreListener();
    protected EventuallyConsistentMap<FloatingIpId, FloatingIp> floatingIpStore;
    protected EventuallyConsistentMap<FloatingIpId, FloatingIp> floatingIpBindStore;
    protected ApplicationId appId;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TenantNetworkService tenantNetworkService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected VirtualPortService virtualPortService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected RouterService routerService;

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication(VTNRSC_APP);
        KryoNamespace.Builder serializer = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{FloatingIp.class, FloatingIpId.class, TenantNetworkId.class, TenantId.class, FloatingIp.Status.class, RouterId.class, VirtualPortId.class, DefaultFloatingIp.class, UUID.class});
        this.floatingIpStore = this.storageService.eventuallyConsistentMapBuilder().withName(FLOATINGIPSTORE).withSerializer(serializer).withTimestampProvider((k, v) -> new WallClockTimestamp()).build();
        this.floatingIpBindStore = this.storageService.eventuallyConsistentMapBuilder().withName(FLOATINGIPBINDSTORE).withSerializer(serializer).withTimestampProvider((k, v) -> new WallClockTimestamp()).build();
        this.floatingIpStore.addListener(this.floatingIpListener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.floatingIpStore.removeListener(this.floatingIpListener);
        this.floatingIpStore.destroy();
        this.floatingIpBindStore.destroy();
        this.listeners.clear();
        this.log.info("Stopped");
    }

    @Override
    public Collection<FloatingIp> getFloatingIps() {
        return Collections.unmodifiableCollection(this.floatingIpStore.values());
    }

    @Override
    public FloatingIp getFloatingIp(FloatingIpId floatingIpId) {
        Preconditions.checkNotNull((Object)((Object)floatingIpId), (Object)FLOATINGIP_ID_NOT_NULL);
        return (FloatingIp)this.floatingIpStore.get((Object)floatingIpId);
    }

    @Override
    public boolean exists(FloatingIpId floatingIpId) {
        Preconditions.checkNotNull((Object)((Object)floatingIpId), (Object)FLOATINGIP_ID_NOT_NULL);
        return this.floatingIpStore.containsKey((Object)floatingIpId);
    }

    @Override
    public boolean floatingIpIsUsed(IpAddress floatingIpAddr, FloatingIpId floatingIpId) {
        Preconditions.checkNotNull((Object)floatingIpAddr, (Object)"Floating IP address cannot be null");
        Preconditions.checkNotNull((Object)((Object)floatingIpId), (Object)"Floating IP Id cannot be null");
        Collection<FloatingIp> floatingIps = this.getFloatingIps();
        for (FloatingIp floatingIp : floatingIps) {
            if (!floatingIp.floatingIp().equals((Object)floatingIpAddr) || floatingIp.id().equals((Object)floatingIpId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean fixedIpIsUsed(IpAddress fixedIpAddr, TenantId tenantId, FloatingIpId floatingIpId) {
        Preconditions.checkNotNull((Object)fixedIpAddr, (Object)"Fixed IP address cannot be null");
        Preconditions.checkNotNull((Object)((Object)tenantId), (Object)"Tenant Id cannot be null");
        Preconditions.checkNotNull((Object)((Object)floatingIpId), (Object)"Floating IP Id cannot be null");
        Collection<FloatingIp> floatingIps = this.getFloatingIps();
        for (FloatingIp floatingIp : floatingIps) {
            IpAddress fixedIp = floatingIp.fixedIp();
            if (fixedIp == null || !fixedIp.equals((Object)fixedIpAddr) || !floatingIp.tenantId().equals((Object)tenantId) || floatingIp.id().equals((Object)floatingIpId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean createFloatingIps(Collection<FloatingIp> floatingIps) {
        Preconditions.checkNotNull(floatingIps, (Object)FLOATINGIP_NOT_NULL);
        boolean result = true;
        for (FloatingIp floatingIp : floatingIps) {
            this.verifyFloatingIpData(floatingIp);
            this.floatingIpStore.put((Object)floatingIp.id(), (Object)floatingIp);
            if (this.floatingIpStore.containsKey((Object)floatingIp.id())) continue;
            this.log.debug("The floating Ip is created failed whose identifier is {}", (Object)floatingIp.id().toString());
            result = false;
        }
        return result;
    }

    @Override
    public boolean updateFloatingIps(Collection<FloatingIp> floatingIps) {
        Preconditions.checkNotNull(floatingIps, (Object)FLOATINGIP_NOT_NULL);
        boolean result = true;
        for (FloatingIp floatingIp : floatingIps) {
            this.verifyFloatingIpData(floatingIp);
            FloatingIp oldFloatingIp = (FloatingIp)this.floatingIpStore.get((Object)floatingIp.id());
            this.floatingIpBindStore.put((Object)floatingIp.id(), (Object)oldFloatingIp);
            this.floatingIpStore.put((Object)floatingIp.id(), (Object)floatingIp);
            if (this.floatingIpStore.containsKey((Object)floatingIp.id())) continue;
            this.log.debug("The floating Ip is updated failed whose identifier is {}", (Object)floatingIp.id().toString());
            result = false;
        }
        return result;
    }

    @Override
    public boolean removeFloatingIps(Collection<FloatingIpId> floatingIpIds) {
        Preconditions.checkNotNull(floatingIpIds, (Object)FLOATINGIP_ID_NOT_NULL);
        boolean result = true;
        for (FloatingIpId floatingIpId : floatingIpIds) {
            if (!this.floatingIpStore.containsKey((Object)floatingIpId)) {
                this.log.debug("The floatingIp is not exist whose identifier is {}", (Object)floatingIpId.toString());
                throw new IllegalArgumentException("FloatingIP ID doesn't exist");
            }
            FloatingIp floatingIp = (FloatingIp)this.floatingIpStore.get((Object)floatingIpId);
            this.floatingIpStore.remove((Object)floatingIpId, (Object)floatingIp);
            this.floatingIpBindStore.remove((Object)floatingIpId);
            if (!this.floatingIpStore.containsKey((Object)floatingIpId)) continue;
            this.log.debug("The floating Ip is deleted failed whose identifier is {}", (Object)floatingIpId.toString());
            result = false;
        }
        return result;
    }

    @Override
    public void addListener(FloatingIpListener listener) {
        Preconditions.checkNotNull((Object)listener, (Object)LISTENER_NOT_NULL);
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(FloatingIpListener listener) {
        Preconditions.checkNotNull((Object)listener, (Object)LISTENER_NOT_NULL);
        this.listeners.remove(listener);
    }

    private void verifyFloatingIpData(FloatingIp floatingIps) {
        Preconditions.checkNotNull((Object)floatingIps, (Object)FLOATINGIP_NOT_NULL);
        if (!this.tenantNetworkService.exists(floatingIps.networkId())) {
            this.log.debug("The network identifier {} that the floating Ip {} create for is not exist", (Object)floatingIps.networkId().toString(), (Object)floatingIps.id().toString());
            throw new IllegalArgumentException("Floating network ID doesn't exist");
        }
        VirtualPortId portId = floatingIps.portId();
        if (portId != null && !this.virtualPortService.exists(portId)) {
            this.log.debug("The port identifier {} that the floating Ip {} create for is not exist", (Object)floatingIps.portId().toString(), (Object)floatingIps.id().toString());
            throw new IllegalArgumentException("Port ID doesn't exist");
        }
        RouterId routerId = floatingIps.routerId();
        if (routerId != null && !this.routerService.exists(routerId)) {
            this.log.debug("The router identifier {} that the floating Ip {} create for is not exist", (Object)floatingIps.routerId().toString(), (Object)floatingIps.id().toString());
            throw new IllegalArgumentException("Router ID doesn't exist");
        }
        if (this.floatingIpIsUsed(floatingIps.floatingIp(), floatingIps.id())) {
            this.log.debug("The floaing Ip {} that the floating Ip {} create for is used", (Object)floatingIps.floatingIp().toString(), (Object)floatingIps.id().toString());
            throw new IllegalArgumentException("The floating IP address is used");
        }
        IpAddress fixedIp = floatingIps.fixedIp();
        if (fixedIp != null && this.fixedIpIsUsed(fixedIp, floatingIps.tenantId(), floatingIps.id())) {
            this.log.debug("The fixed Ip {} that the floating Ip {} create for is used", (Object)floatingIps.fixedIp().toString(), (Object)floatingIps.id().toString());
            throw new IllegalArgumentException("The fixed IP address is used");
        }
    }

    private void notifyListeners(FloatingIpEvent event) {
        Preconditions.checkNotNull((Object)((Object)event), (Object)EVENT_NOT_NULL);
        this.listeners.forEach(listener -> listener.event((Event)event));
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindTenantNetworkService(TenantNetworkService tenantNetworkService) {
        this.tenantNetworkService = tenantNetworkService;
    }

    protected void unbindTenantNetworkService(TenantNetworkService tenantNetworkService) {
        if (this.tenantNetworkService == tenantNetworkService) {
            this.tenantNetworkService = null;
        }
    }

    protected void bindVirtualPortService(VirtualPortService virtualPortService) {
        this.virtualPortService = virtualPortService;
    }

    protected void unbindVirtualPortService(VirtualPortService virtualPortService) {
        if (this.virtualPortService == virtualPortService) {
            this.virtualPortService = null;
        }
    }

    protected void bindRouterService(RouterService routerService) {
        this.routerService = routerService;
    }

    protected void unbindRouterService(RouterService routerService) {
        if (this.routerService == routerService) {
            this.routerService = null;
        }
    }

    private class InnerFloatingIpStoreListener
    implements EventuallyConsistentMapListener<FloatingIpId, FloatingIp> {
        private InnerFloatingIpStoreListener() {
        }

        public void event(EventuallyConsistentMapEvent<FloatingIpId, FloatingIp> event) {
            Preconditions.checkNotNull(event, (Object)FloatingIpManager.EVENT_NOT_NULL);
            FloatingIp floatingIp = (FloatingIp)event.value();
            if (EventuallyConsistentMapEvent.Type.PUT == event.type()) {
                FloatingIpManager.this.notifyListeners(new FloatingIpEvent(FloatingIpEvent.Type.FLOATINGIP_PUT, floatingIp));
                if (floatingIp.portId() != null) {
                    FloatingIpManager.this.notifyListeners(new FloatingIpEvent(FloatingIpEvent.Type.FLOATINGIP_BIND, floatingIp));
                } else {
                    FloatingIp oldFloatingIp = (FloatingIp)FloatingIpManager.this.floatingIpBindStore.get((Object)floatingIp.id());
                    if (oldFloatingIp != null) {
                        FloatingIpManager.this.notifyListeners(new FloatingIpEvent(FloatingIpEvent.Type.FLOATINGIP_UNBIND, oldFloatingIp));
                    }
                }
            }
            if (EventuallyConsistentMapEvent.Type.REMOVE == event.type()) {
                FloatingIpManager.this.notifyListeners(new FloatingIpEvent(FloatingIpEvent.Type.FLOATINGIP_DELETE, floatingIp));
                if (floatingIp.portId() != null) {
                    FloatingIpManager.this.notifyListeners(new FloatingIpEvent(FloatingIpEvent.Type.FLOATINGIP_UNBIND, floatingIp));
                }
            }
        }
    }
}

