/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc.cli.virtualport;

import java.util.Collection;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.DeviceId;
import org.onosproject.vtnrsc.TenantNetworkId;
import org.onosproject.vtnrsc.VirtualPort;
import org.onosproject.vtnrsc.VirtualPortId;
import org.onosproject.vtnrsc.virtualport.VirtualPortService;

@Command(scope="onos", name="virtualports", description="Supports for querying virtualPorts.")
public class VirtualPortQueryCommand
extends AbstractShellCommand {
    @Option(name="-v", aliases={"--vPortId"}, description="virtualPort ID.", required=false, multiValued=false)
    String vPortId;
    @Option(name="-n", aliases={"--networkId"}, description="network ID.", required=false, multiValued=false)
    String networkId;
    @Option(name="-d", aliases={"--deviceId"}, description="device ID.", required=false, multiValued=false)
    String deviceId;
    @Option(name="-t", aliases={"--tenantId"}, description="tenant ID.", required=false, multiValued=false)
    String tenantId;
    private static final String FMT = "virtualPortId=%s, networkId=%s, name=%s, tenantId=%s, deviceId=%s, adminStateUp=%s, state=%s, macAddress=%s, deviceOwner=%s, fixedIp=%s, bindingHostId=%s, bindingvnicType=%s, bindingvifType=%s, bindingvnicDetails=%s, allowedAddress=%s, securityGroups=%s";

    protected void execute() {
        VirtualPortService service = (VirtualPortService)VirtualPortQueryCommand.get(VirtualPortService.class);
        if (this.vPortId != null && this.networkId == null && this.deviceId == null && this.tenantId == null) {
            VirtualPort port = service.getPort(VirtualPortId.portId(this.vPortId));
            this.printPort(port);
        } else if (this.vPortId == null && this.networkId != null && this.deviceId == null && this.tenantId == null) {
            Collection<VirtualPort> ports = service.getPorts(TenantNetworkId.networkId(this.networkId));
            this.printPorts(ports);
        } else if (this.vPortId == null && this.networkId == null && this.deviceId != null && this.tenantId == null) {
            Collection<VirtualPort> ports = service.getPorts(DeviceId.deviceId((String)this.deviceId));
            this.printPorts(ports);
        } else if (this.vPortId == null && this.networkId == null && this.deviceId == null && this.tenantId != null) {
            Collection<VirtualPort> ports = service.getPorts(DeviceId.deviceId((String)this.tenantId));
            this.printPorts(ports);
        } else if (this.vPortId == null && this.networkId == null && this.deviceId == null && this.tenantId == null) {
            Collection<VirtualPort> ports = service.getPorts();
            this.printPorts(ports);
        } else {
            this.print("cannot input more than one parameter", new Object[0]);
        }
    }

    private void printPorts(Collection<VirtualPort> ports) {
        for (VirtualPort port : ports) {
            this.printPort(port);
        }
    }

    private void printPort(VirtualPort port) {
        this.print(FMT, new Object[]{port.portId(), port.networkId(), port.name(), port.tenantId(), port.deviceId(), port.adminStateUp(), port.state(), port.macAddress(), port.deviceOwner(), port.fixedIps(), port.bindingHostId(), port.bindingVnicType(), port.bindingVifType(), port.bindingVifDetails(), port.allowedAddressPairs(), port.securityGroups()});
    }
}

