/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc.cli.subnet;

import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.vtnrsc.Subnet;
import org.onosproject.vtnrsc.SubnetId;
import org.onosproject.vtnrsc.subnet.SubnetService;

@Command(scope="onos", name="subnets", description="Supports for querying a subnet")
public class SubnetQueryCommand
extends AbstractShellCommand {
    @Option(name="-i", aliases={"--id"}, description="Subnet id", required=false, multiValued=false)
    String id = null;
    private static final String FMT = "subnetId=%s, networkId=%s, subnetName=%s,tenantId=%s, cidr=%s, dhcpEnabled=%s, gatewayIp=%s,ipVersion=%s";

    protected void execute() {
        SubnetService service = (SubnetService)SubnetQueryCommand.get(SubnetService.class);
        if (this.id != null) {
            Subnet subnet = service.getSubnet(SubnetId.subnetId(this.id));
            this.printSubnet(subnet);
        } else {
            Iterable<Subnet> subnets = service.getSubnets();
            if (subnets == null) {
                return;
            }
            for (Subnet subnet : subnets) {
                this.printSubnet(subnet);
            }
        }
    }

    private void printSubnet(Subnet subnet) {
        this.print(FMT, new Object[]{subnet.id(), subnet.networkId(), subnet.subnetName(), subnet.tenantId(), subnet.cidr(), subnet.dhcpEnabled(), subnet.gatewayIp(), subnet.ipVersion()});
    }
}

