/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc.cli.routerinterface;

import java.util.Collection;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.vtnrsc.RouterInterface;
import org.onosproject.vtnrsc.SubnetId;
import org.onosproject.vtnrsc.routerinterface.RouterInterfaceService;

@Command(scope="onos", name="routerinterfaces", description="Supports for querying a router interface")
public class RouterInterfaceQueryCommand
extends AbstractShellCommand {
    @Option(name="-s", aliases={"--subnetId"}, description="The subnet identifier of router interface", required=false, multiValued=false)
    String subnetId = null;
    private static final String FMT = "subnetId=%s, tenantId=%s, portId=%s, routerId=%s";

    protected void execute() {
        RouterInterfaceService service = (RouterInterfaceService)RouterInterfaceQueryCommand.get(RouterInterfaceService.class);
        if (this.subnetId != null) {
            RouterInterface routerInterface = service.getRouterInterface(SubnetId.subnetId(this.subnetId));
            this.printRouterInterface(routerInterface);
        } else {
            Collection<RouterInterface> routerInterfaces = service.getRouterInterfaces();
            for (RouterInterface routerInterface : routerInterfaces) {
                this.printRouterInterface(routerInterface);
            }
        }
    }

    private void printRouterInterface(RouterInterface routerInterface) {
        this.print(FMT, new Object[]{routerInterface.subnetId(), routerInterface.tenantId(), routerInterface.portId(), routerInterface.routerId()});
    }
}

