/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc.cli.router;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.vtnrsc.Router;
import org.onosproject.vtnrsc.RouterId;
import org.onosproject.vtnrsc.router.RouterService;

@Command(scope="onos", name="router-remove", description="Supports for removing a router")
public class RouterRemoveCommand
extends AbstractShellCommand {
    @Option(name="-i", aliases={"--id"}, description="The router identifier", required=false, multiValued=false)
    String id = null;
    @Option(name="-n", aliases={"--routerName"}, description="The name of router", required=false, multiValued=false)
    String routerName = null;

    protected void execute() {
        RouterService service = (RouterService)RouterRemoveCommand.get(RouterService.class);
        if (this.id == null && this.routerName == null) {
            this.print(null, new Object[]{"one of id, routerName should not be null"});
        }
        try {
            HashSet routerSet = Sets.newHashSet();
            if (this.id != null) {
                routerSet.add(RouterId.valueOf(this.id));
                service.removeRouters(routerSet);
            } else {
                Collection<Router> routers = service.getRouters();
                if (routers == null) {
                    return;
                }
                for (Router router : routers) {
                    if (!router.name().equals(this.routerName)) continue;
                    routerSet.add(router.id());
                    service.removeRouters(routerSet);
                    return;
                }
            }
        }
        catch (Exception e) {
            this.print(null, new Object[]{e.getMessage()});
        }
    }
}

