/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc.cli.router;

import java.util.Collection;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.vtnrsc.Router;
import org.onosproject.vtnrsc.RouterId;
import org.onosproject.vtnrsc.router.RouterService;

@Command(scope="onos", name="routers", description="Supports for creating a router")
public class RouterQueryCommand
extends AbstractShellCommand {
    @Option(name="-i", aliases={"--id"}, description="The router identifier", required=false, multiValued=false)
    String id = null;
    @Option(name="-n", aliases={"--routerName"}, description="The name of router", required=false, multiValued=false)
    String routerName = null;
    private static final String FMT = "routerId=%s, routerName=%s, tenantId=%s, gatewayPortId=%s,externalGatewayInfo=%s, status=%s, adminStateUp=%s, distributed=%s, routers=%s";

    protected void execute() {
        RouterService service = (RouterService)RouterQueryCommand.get(RouterService.class);
        if (this.id != null) {
            Router router = service.getRouter(RouterId.valueOf(this.id));
            this.printFloatingIp(router);
        } else if (this.routerName != null) {
            Collection<Router> routers = service.getRouters();
            if (routers == null) {
                return;
            }
            for (Router router : routers) {
                if (!router.name().equals(this.routerName)) continue;
                this.printFloatingIp(router);
                return;
            }
            this.print(null, new Object[]{"The routerName is not existed"});
        } else {
            Collection<Router> routers = service.getRouters();
            if (routers == null) {
                return;
            }
            for (Router router : routers) {
                this.printFloatingIp(router);
            }
        }
    }

    private void printFloatingIp(Router router) {
        this.print(FMT, new Object[]{router.id(), router.name(), router.tenantId(), router.gatewayPortid(), router.externalGatewayInfo(), router.status(), router.adminStateUp(), router.distributed(), router.routes()});
    }
}

