/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc.cli.floatingip;

import com.google.common.collect.Sets;
import java.util.HashSet;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onlab.packet.IpAddress;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.vtnrsc.DefaultFloatingIp;
import org.onosproject.vtnrsc.FloatingIp;
import org.onosproject.vtnrsc.FloatingIpId;
import org.onosproject.vtnrsc.RouterId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnrsc.TenantNetworkId;
import org.onosproject.vtnrsc.VirtualPortId;
import org.onosproject.vtnrsc.floatingip.FloatingIpService;

@Command(scope="onos", name="floatingip-update", description="Supports for updating a floating IP")
public class FloatingIpUpdateCommand
extends AbstractShellCommand {
    @Argument(index=0, name="id", description="The floating IP identifier", required=true, multiValued=false)
    String id = null;
    @Option(name="-n", aliases={"--networkId"}, description="The network identifier of floating IP", required=false, multiValued=false)
    String networkId = null;
    @Option(name="-t", aliases={"--tenantId"}, description="The tenant identifier of floating IP", required=false, multiValued=false)
    String tenantId = null;
    @Option(name="-r", aliases={"--routerId"}, description="The router identifier of floating IP", required=false, multiValued=false)
    String routerId = null;
    @Option(name="-p", aliases={"--portId"}, description="The port identifier of floating IP", required=false, multiValued=false)
    String portId = null;
    @Option(name="-s", aliases={"--status"}, description="The status of floating IP", required=false, multiValued=false)
    String status = null;
    @Option(name="-i", aliases={"--fixedIp"}, description="The fixed IP of floating IP", required=false, multiValued=false)
    String fixedIp = null;
    @Option(name="-l", aliases={"--floatingIp"}, description="The floating IP of floating IP", required=false, multiValued=false)
    String floatingIp = null;

    protected void execute() {
        FloatingIpService service = (FloatingIpService)FloatingIpUpdateCommand.get(FloatingIpService.class);
        FloatingIpId floatingIpId = FloatingIpId.of(this.id);
        FloatingIp floatingIpStore = ((FloatingIpService)FloatingIpUpdateCommand.get(FloatingIpService.class)).getFloatingIp(floatingIpId);
        try {
            DefaultFloatingIp floatingIpObj = new DefaultFloatingIp(floatingIpId, this.tenantId == null ? floatingIpStore.tenantId() : TenantId.tenantId(this.tenantId), this.networkId == null ? floatingIpStore.networkId() : TenantNetworkId.networkId(this.networkId), this.portId == null ? floatingIpStore.portId() : VirtualPortId.portId(this.portId), this.routerId == null ? floatingIpStore.routerId() : RouterId.valueOf(this.routerId), this.floatingIp == null ? floatingIpStore.floatingIp() : IpAddress.valueOf((String)this.floatingIp), this.fixedIp == null ? floatingIpStore.fixedIp() : IpAddress.valueOf((String)this.fixedIp), this.status == null ? floatingIpStore.status() : FloatingIp.Status.valueOf(this.status));
            HashSet floatingIpSet = Sets.newHashSet((Object[])new FloatingIp[]{floatingIpObj});
            service.updateFloatingIps(floatingIpSet);
        }
        catch (Exception e) {
            this.print(null, new Object[]{e.getMessage()});
        }
    }
}

