/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc.cli.floatingip;

import java.util.Collection;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.vtnrsc.FloatingIp;
import org.onosproject.vtnrsc.FloatingIpId;
import org.onosproject.vtnrsc.floatingip.FloatingIpService;

@Command(scope="onos", name="floatingips", description="Supports for querying a floating IP")
public class FloatingIpQueryCommand
extends AbstractShellCommand {
    @Option(name="-I", aliases={"--id"}, description="The floating IP identifier", required=false, multiValued=false)
    String id = null;
    @Option(name="-i", aliases={"--fixedIp"}, description="The fixed IP of floating IP", required=false, multiValued=false)
    String fixedIp = null;
    @Option(name="-l", aliases={"--floatingIp"}, description="The floating IP of floating IP", required=false, multiValued=false)
    String floatingIp = null;
    private static final String FMT = "floatingIpId=%s, networkId=%s, tenantId=%s, portId=%s,routerId=%s, fixedIp=%s, floatingIp=%s, status=%s";

    protected void execute() {
        FloatingIpService service = (FloatingIpService)FloatingIpQueryCommand.get(FloatingIpService.class);
        if (this.id != null) {
            FloatingIp floatingIp = service.getFloatingIp(FloatingIpId.of(this.id));
            this.printFloatingIp(floatingIp);
        } else if (this.fixedIp != null || this.floatingIp != null) {
            Collection<FloatingIp> floatingIps = service.getFloatingIps();
            if (floatingIps == null) {
                return;
            }
            if (this.fixedIp != null) {
                for (FloatingIp floatingIp : floatingIps) {
                    if (!floatingIp.fixedIp().toString().equals(this.fixedIp)) continue;
                    this.printFloatingIp(floatingIp);
                    return;
                }
                this.print(null, new Object[]{"The fixedIp is not existed"});
            }
            if (this.floatingIp != null) {
                for (FloatingIp floatingIpObj : floatingIps) {
                    if (!floatingIpObj.fixedIp().toString().equals(this.floatingIp)) continue;
                    this.printFloatingIp(floatingIpObj);
                    return;
                }
                this.print(null, new Object[]{"The floatingIp is not existed"});
            }
        } else {
            Collection<FloatingIp> floatingIps = service.getFloatingIps();
            if (floatingIps == null) {
                return;
            }
            for (FloatingIp floatingIp : floatingIps) {
                this.printFloatingIp(floatingIp);
            }
        }
    }

    private void printFloatingIp(FloatingIp floatingIp) {
        this.print(FMT, new Object[]{floatingIp.id(), floatingIp.networkId(), floatingIp.tenantId(), floatingIp.portId(), floatingIp.routerId(), floatingIp.fixedIp(), floatingIp.floatingIp(), floatingIp.status()});
    }
}

