/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.vtnrsc.RouterId;
import org.onosproject.vtnrsc.TenantId;

public final class TenantRouter {
    private final TenantId tenantId;
    private final RouterId routerId;

    private TenantRouter(TenantId tenantId, RouterId routerId) {
        this.tenantId = (TenantId)((Object)Preconditions.checkNotNull((Object)((Object)tenantId), (Object)"tenantId cannot be null"));
        this.routerId = (RouterId)((Object)Preconditions.checkNotNull((Object)((Object)routerId), (Object)"routerId cannot be null"));
    }

    public static TenantRouter tenantRouter(TenantId tenantId, RouterId routerId) {
        return new TenantRouter(tenantId, routerId);
    }

    public TenantId tenantId() {
        return this.tenantId;
    }

    public RouterId routerId() {
        return this.routerId;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tenantId, this.routerId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TenantRouter) {
            TenantRouter that = (TenantRouter)obj;
            return this.getClass() == that.getClass() && Objects.equals((Object)this.tenantId, (Object)that.tenantId) && Objects.equals((Object)this.routerId, (Object)that.routerId);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tenantId", (Object)this.tenantId).add("routerId", (Object)this.routerId).toString();
    }
}

