/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.onosproject.net.DeviceId;
import org.onosproject.vtnrsc.FiveTuple;
import org.onosproject.vtnrsc.FlowClassifierId;
import org.onosproject.vtnrsc.LoadBalanceId;
import org.onosproject.vtnrsc.PortChain;
import org.onosproject.vtnrsc.PortChainId;
import org.onosproject.vtnrsc.PortPairGroupId;
import org.onosproject.vtnrsc.PortPairId;
import org.onosproject.vtnrsc.TenantId;

public final class DefaultPortChain
implements PortChain {
    private final PortChainId portChainId;
    private final TenantId tenantId;
    private final String name;
    private final String description;
    private final List<PortPairGroupId> portPairGroupList;
    private final List<FlowClassifierId> flowClassifierList;
    private final PortChain oldPortChain;
    private final Map<FiveTuple, LoadBalanceId> sfcLoadBalanceIdMap = new ConcurrentHashMap<FiveTuple, LoadBalanceId>();
    private final Map<LoadBalanceId, List<PortPairId>> sfcLoadBalancePathMap = new ConcurrentHashMap<LoadBalanceId, List<PortPairId>>();
    private final Map<LoadBalanceId, List<DeviceId>> sfcClassifiersMap = new ConcurrentHashMap<LoadBalanceId, List<DeviceId>>();
    private final Map<LoadBalanceId, List<DeviceId>> sfcForwardersMap = new ConcurrentHashMap<LoadBalanceId, List<DeviceId>>();

    private DefaultPortChain(PortChainId portChainId, TenantId tenantId, String name, String description, List<PortPairGroupId> portPairGroupList, List<FlowClassifierId> flowClassifierList, PortChain portChain) {
        this.portChainId = portChainId;
        this.tenantId = tenantId;
        this.name = name;
        this.description = description;
        this.portPairGroupList = portPairGroupList;
        this.flowClassifierList = flowClassifierList;
        this.oldPortChain = portChain;
    }

    public static PortChain create(PortChain newPortChain, PortChain oldPortChain) {
        return new DefaultPortChain(newPortChain.portChainId(), newPortChain.tenantId(), newPortChain.name(), newPortChain.description(), newPortChain.portPairGroups(), newPortChain.flowClassifiers(), oldPortChain);
    }

    private boolean comparePath(List<PortPairId> path1, List<PortPairId> path2) {
        Iterator<PortPairId> it = path1.iterator();
        for (PortPairId portPairId : path2) {
            if (portPairId.equals((Object)it.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public PortChainId portChainId() {
        return this.portChainId;
    }

    @Override
    public TenantId tenantId() {
        return this.tenantId;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public List<PortPairGroupId> portPairGroups() {
        return ImmutableList.copyOf(this.portPairGroupList);
    }

    @Override
    public List<FlowClassifierId> flowClassifiers() {
        return ImmutableList.copyOf(this.flowClassifierList);
    }

    @Override
    public PortChain oldPortChain() {
        return this.oldPortChain;
    }

    @Override
    public void addLoadBalancePath(FiveTuple fiveTuple, LoadBalanceId id, List<PortPairId> path) {
        this.sfcLoadBalanceIdMap.put(fiveTuple, id);
        this.sfcLoadBalancePathMap.put(id, path);
    }

    @Override
    public void addSfcClassifiers(LoadBalanceId id, List<DeviceId> classifierList) {
        this.sfcClassifiersMap.put(id, classifierList);
    }

    @Override
    public void addSfcForwarders(LoadBalanceId id, List<DeviceId> forwarderList) {
        this.sfcForwardersMap.put(id, forwarderList);
    }

    @Override
    public void removeSfcClassifiers(LoadBalanceId id, List<DeviceId> classifierList) {
        List<DeviceId> list = this.sfcClassifiersMap.get((Object)id);
        list.removeAll(classifierList);
        this.sfcForwardersMap.put(id, list);
    }

    @Override
    public void removeSfcForwarders(LoadBalanceId id, List<DeviceId> forwarderList) {
        List<DeviceId> list = this.sfcForwardersMap.get((Object)id);
        list.removeAll(forwarderList);
        this.sfcForwardersMap.put(id, list);
    }

    @Override
    public List<DeviceId> getSfcClassifiers(LoadBalanceId id) {
        return ImmutableList.copyOf((Collection)this.sfcClassifiersMap.get((Object)id));
    }

    @Override
    public List<DeviceId> getSfcForwarders(LoadBalanceId id) {
        return ImmutableList.copyOf((Collection)this.sfcForwardersMap.get((Object)id));
    }

    @Override
    public LoadBalanceId getLoadBalanceId(FiveTuple fiveTuple) {
        return this.sfcLoadBalanceIdMap.get(fiveTuple);
    }

    @Override
    public Set<FiveTuple> getLoadBalanceIdMapKeys() {
        return ImmutableSet.copyOf(this.sfcLoadBalanceIdMap.keySet());
    }

    @Override
    public Set<LoadBalanceId> getLoadBalancePathMapKeys() {
        return ImmutableSet.copyOf(this.sfcLoadBalancePathMap.keySet());
    }

    @Override
    public List<PortPairId> getLoadBalancePath(LoadBalanceId id) {
        return ImmutableList.copyOf((Collection)this.sfcLoadBalancePathMap.get((Object)id));
    }

    @Override
    public List<PortPairId> getLoadBalancePath(FiveTuple fiveTuple) {
        return ImmutableList.copyOf((Collection)this.sfcLoadBalancePathMap.get((Object)this.sfcLoadBalanceIdMap.get(fiveTuple)));
    }

    @Override
    public int getLoadBalancePathSize() {
        if (this.sfcLoadBalanceIdMap.isEmpty()) {
            return 0;
        }
        return this.sfcLoadBalanceIdMap.size();
    }

    @Override
    public LoadBalanceId matchPath(List<PortPairId> path) {
        LoadBalanceId id = null;
        for (Map.Entry<LoadBalanceId, List<PortPairId>> entry : this.sfcLoadBalancePathMap.entrySet()) {
            List<PortPairId> tempPath = entry.getValue();
            if (!this.comparePath(path, tempPath)) continue;
            id = entry.getKey();
            break;
        }
        return id;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.portChainId, this.tenantId, this.name, this.description, this.portPairGroupList, this.flowClassifierList});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultPortChain) {
            DefaultPortChain that = (DefaultPortChain)obj;
            return Objects.equals((Object)this.portChainId, (Object)that.portChainId) && Objects.equals((Object)this.tenantId, (Object)that.tenantId) && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.portPairGroupList, that.portPairGroupList) && Objects.equals(this.flowClassifierList, that.flowClassifierList);
        }
        return false;
    }

    @Override
    public boolean exactMatch(PortChain portChain) {
        return this.equals(portChain) && Objects.equals((Object)this.portChainId, (Object)portChain.portChainId()) && Objects.equals((Object)this.tenantId, (Object)portChain.tenantId());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.portChainId.toString()).add("tenantId", (Object)this.tenantId.toString()).add("name", (Object)this.name).add("description", (Object)this.description).add("portPairGroupList", this.portPairGroupList).add("flowClassifier", this.flowClassifierList).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements PortChain.Builder {
        private PortChainId portChainId;
        private TenantId tenantId;
        private String name;
        private String description;
        private List<PortPairGroupId> portPairGroupList;
        private List<FlowClassifierId> flowClassifierList;
        private PortChain portChain;

        @Override
        public Builder setId(PortChainId portChainId) {
            this.portChainId = portChainId;
            return this;
        }

        @Override
        public Builder setTenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Override
        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder setPortPairGroups(List<PortPairGroupId> portPairGroups) {
            this.portPairGroupList = portPairGroups;
            return this;
        }

        @Override
        public Builder setFlowClassifiers(List<FlowClassifierId> flowClassifiers) {
            this.flowClassifierList = flowClassifiers;
            return this;
        }

        @Override
        public PortChain build() {
            Preconditions.checkNotNull((Object)((Object)this.portChainId), (Object)"Port chain id cannot be null");
            Preconditions.checkNotNull((Object)((Object)this.tenantId), (Object)"Tenant id cannot be null");
            Preconditions.checkNotNull(this.portPairGroupList, (Object)"Port pair groups cannot be null");
            return new DefaultPortChain(this.portChainId, this.tenantId, this.name, this.description, this.portPairGroupList, this.flowClassifierList, this.portChain);
        }
    }
}

