/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.IpPrefix;
import org.onosproject.vtnrsc.FlowClassifier;
import org.onosproject.vtnrsc.FlowClassifierId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnrsc.VirtualPortId;

public final class DefaultFlowClassifier
implements FlowClassifier {
    private final FlowClassifierId flowClassifierId;
    private final TenantId tenantId;
    private final String name;
    private final String description;
    private final String etherType;
    private final String protocol;
    private final int priority;
    private final int minSrcPortRange;
    private final int maxSrcPortRange;
    private final int minDstPortRange;
    private final int maxDstPortRange;
    private final IpPrefix srcIpPrefix;
    private final IpPrefix dstIpPrefix;
    private final VirtualPortId srcPort;
    private final VirtualPortId dstPort;
    private static final int NULL_PORT = 0;
    private static final String FLOW_CLASSIFIER_ID_NOT_NULL = "FlowClassifier id can not be null.";
    private static final String TENANT_ID_NOT_NULL = "Tenant id can not be null.";
    private static final String NAME_NOT_NULL = "Name can not be null.";
    private static final String ETHER_TYPE_NOT_NULL = "Ether Type can not be null.";
    private static final int DEFAULT_CLASSIFIER_PRIORITY = 52000;

    private DefaultFlowClassifier(FlowClassifierId flowClassifierId, TenantId tenantId, String name, String description, String etherType, String protocol, int priority, int minSrcPortRange, int maxSrcPortRange, int minDstPortRange, int maxDstPortRange, IpPrefix srcIpPrefix, IpPrefix dstIpPrefix, VirtualPortId srcPort, VirtualPortId dstPort) {
        this.flowClassifierId = flowClassifierId;
        this.tenantId = tenantId;
        this.name = name;
        this.description = description;
        this.etherType = etherType;
        this.protocol = protocol;
        this.priority = priority;
        this.minSrcPortRange = minSrcPortRange;
        this.maxSrcPortRange = maxSrcPortRange;
        this.minDstPortRange = minDstPortRange;
        this.maxDstPortRange = maxDstPortRange;
        this.srcIpPrefix = srcIpPrefix;
        this.dstIpPrefix = dstIpPrefix;
        this.srcPort = srcPort;
        this.dstPort = dstPort;
    }

    @Override
    public FlowClassifierId flowClassifierId() {
        return this.flowClassifierId;
    }

    @Override
    public TenantId tenantId() {
        return this.tenantId;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public String etherType() {
        return this.etherType;
    }

    @Override
    public String protocol() {
        return this.protocol;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    @Override
    public int minSrcPortRange() {
        return this.minSrcPortRange;
    }

    @Override
    public int maxSrcPortRange() {
        return this.maxSrcPortRange;
    }

    @Override
    public int minDstPortRange() {
        return this.minDstPortRange;
    }

    @Override
    public int maxDstPortRange() {
        return this.maxDstPortRange;
    }

    @Override
    public IpPrefix srcIpPrefix() {
        return this.srcIpPrefix;
    }

    @Override
    public IpPrefix dstIpPrefix() {
        return this.dstIpPrefix;
    }

    @Override
    public VirtualPortId srcPort() {
        return this.srcPort;
    }

    @Override
    public VirtualPortId dstPort() {
        return this.dstPort;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.flowClassifierId, this.tenantId, this.name, this.description, this.etherType, this.protocol, this.minSrcPortRange, this.maxSrcPortRange, this.minDstPortRange, this.maxDstPortRange, this.srcIpPrefix, this.dstIpPrefix, this.srcPort, this.dstPort});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultFlowClassifier) {
            DefaultFlowClassifier other = (DefaultFlowClassifier)obj;
            return Objects.equals((Object)this.flowClassifierId, (Object)other.flowClassifierId) && Objects.equals((Object)this.tenantId, (Object)other.tenantId) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.etherType, other.etherType) && Objects.equals(this.protocol, other.protocol) && Objects.equals(this.priority, other.priority) && Objects.equals(this.minSrcPortRange, other.minSrcPortRange) && Objects.equals(this.maxSrcPortRange, other.maxSrcPortRange) && Objects.equals(this.minDstPortRange, other.minDstPortRange) && Objects.equals(this.maxDstPortRange, other.maxDstPortRange) && Objects.equals(this.srcIpPrefix, other.srcIpPrefix) && Objects.equals(this.dstIpPrefix, other.dstIpPrefix) && Objects.equals((Object)this.srcPort, (Object)other.srcPort) && Objects.equals((Object)this.dstPort, (Object)other.dstPort);
        }
        return false;
    }

    @Override
    public boolean exactMatch(FlowClassifier flowClassifier) {
        return this.equals(flowClassifier) && Objects.equals((Object)this.flowClassifierId, (Object)flowClassifier.flowClassifierId()) && Objects.equals((Object)this.tenantId, (Object)flowClassifier.tenantId()) && Objects.equals(this.name, flowClassifier.name()) && Objects.equals(this.description, flowClassifier.description()) && Objects.equals(this.etherType, flowClassifier.etherType()) && Objects.equals(this.protocol, flowClassifier.protocol()) && Objects.equals(this.priority, flowClassifier.priority()) && Objects.equals(this.minSrcPortRange, flowClassifier.minSrcPortRange()) && Objects.equals(this.maxSrcPortRange, flowClassifier.maxSrcPortRange()) && Objects.equals(this.minDstPortRange, flowClassifier.minDstPortRange()) && Objects.equals(this.maxDstPortRange, flowClassifier.maxDstPortRange()) && Objects.equals(this.srcIpPrefix, flowClassifier.srcIpPrefix()) && Objects.equals(this.dstIpPrefix, flowClassifier.dstIpPrefix()) && Objects.equals((Object)this.srcPort, (Object)flowClassifier.srcPort()) && Objects.equals((Object)this.dstPort, (Object)flowClassifier.dstPort());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("FlowClassifierId", (Object)this.flowClassifierId).add("TenantId", (Object)this.tenantId).add("Name", (Object)this.name).add("Description", (Object)this.description).add("String", (Object)this.etherType).add("Protocol", (Object)this.protocol).add("Priority", this.priority).add("MinSrcPortRange", this.minSrcPortRange).add("MaxSrcPortRange", this.maxSrcPortRange).add("MinDstPortRange", this.minDstPortRange).add("MaxDstPortRange", this.maxDstPortRange).add("SrcIpPrefix", (Object)this.srcIpPrefix).add("DstIpPrefix", (Object)this.dstIpPrefix).add("SrcPort", (Object)this.srcPort).add("DstPort", (Object)this.dstPort).toString();
    }

    public static class Builder
    implements FlowClassifier.Builder {
        private FlowClassifierId flowClassifierId;
        private TenantId tenantId;
        private String name;
        private String description;
        private boolean isFlowClassifierDescriptionSet = false;
        private String etherType;
        private String protocol;
        private boolean isProtocolSet = false;
        private int priority;
        private boolean isPrioritySet = false;
        private int minSrcPortRange;
        private boolean isMinSrcPortRangeSet = false;
        private int maxSrcPortRange;
        private boolean isMaxSrcPortRangeSet = false;
        private int minDstPortRange;
        private boolean isMinDstPortRangeSet = false;
        private int maxDstPortRange;
        private boolean isMaxDstPortRangeSet = false;
        private IpPrefix srcIpPrefix;
        private boolean isSrcIpPrefixSet = false;
        private IpPrefix dstIpPrefix;
        private boolean isDstIpPrefixSet = false;
        private VirtualPortId srcPort;
        private boolean isSrcPortSet = false;
        private VirtualPortId dstPort;
        private boolean isDstPortSet = false;

        @Override
        public FlowClassifier build() {
            Preconditions.checkNotNull((Object)((Object)this.flowClassifierId), (Object)DefaultFlowClassifier.FLOW_CLASSIFIER_ID_NOT_NULL);
            Preconditions.checkNotNull((Object)((Object)this.tenantId), (Object)DefaultFlowClassifier.TENANT_ID_NOT_NULL);
            Preconditions.checkNotNull((Object)this.name, (Object)DefaultFlowClassifier.NAME_NOT_NULL);
            Preconditions.checkNotNull((Object)this.etherType, (Object)DefaultFlowClassifier.ETHER_TYPE_NOT_NULL);
            String description = null;
            String protocol = null;
            int priority = 52000;
            int minSrcPortRange = 0;
            int maxSrcPortRange = 0;
            int minDstPortRange = 0;
            int maxDstPortRange = 0;
            IpPrefix srcIpPrefix = null;
            IpPrefix dstIpPrefix = null;
            VirtualPortId srcPort = null;
            VirtualPortId dstPort = null;
            if (this.isFlowClassifierDescriptionSet) {
                description = this.description;
            }
            if (this.isProtocolSet) {
                protocol = this.protocol;
            }
            if (this.isPrioritySet) {
                priority = this.priority;
            }
            if (this.isMinSrcPortRangeSet) {
                minSrcPortRange = this.minSrcPortRange;
            }
            if (this.isMaxSrcPortRangeSet) {
                maxSrcPortRange = this.maxSrcPortRange;
            }
            if (this.isMinDstPortRangeSet) {
                minDstPortRange = this.minDstPortRange;
            }
            if (this.isMaxDstPortRangeSet) {
                maxDstPortRange = this.maxDstPortRange;
            }
            if (this.isSrcIpPrefixSet) {
                srcIpPrefix = this.srcIpPrefix;
            }
            if (this.isDstIpPrefixSet) {
                dstIpPrefix = this.dstIpPrefix;
            }
            if (this.isSrcPortSet) {
                srcPort = this.srcPort;
            }
            if (this.isDstPortSet) {
                dstPort = this.dstPort;
            }
            return new DefaultFlowClassifier(this.flowClassifierId, this.tenantId, this.name, description, this.etherType, protocol, priority, minSrcPortRange, maxSrcPortRange, minDstPortRange, maxDstPortRange, srcIpPrefix, dstIpPrefix, srcPort, dstPort);
        }

        @Override
        public Builder setFlowClassifierId(FlowClassifierId flowClassifierId) {
            this.flowClassifierId = flowClassifierId;
            return this;
        }

        @Override
        public Builder setTenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Override
        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder setDescription(String description) {
            this.description = description;
            this.isFlowClassifierDescriptionSet = true;
            return this;
        }

        @Override
        public Builder setEtherType(String etherType) {
            this.etherType = etherType;
            return this;
        }

        @Override
        public Builder setProtocol(String protocol) {
            this.protocol = protocol;
            this.isProtocolSet = true;
            return this;
        }

        @Override
        public Builder setPriority(int priority) {
            this.priority = priority;
            this.isPrioritySet = true;
            return this;
        }

        @Override
        public Builder setMinSrcPortRange(int minSrcPortRange) {
            this.minSrcPortRange = minSrcPortRange;
            this.isMinSrcPortRangeSet = true;
            return this;
        }

        @Override
        public Builder setMaxSrcPortRange(int maxSrcPortRange) {
            this.maxSrcPortRange = maxSrcPortRange;
            this.isMaxSrcPortRangeSet = true;
            return this;
        }

        @Override
        public Builder setMinDstPortRange(int minDstPortRange) {
            this.minDstPortRange = minDstPortRange;
            this.isMinDstPortRangeSet = true;
            return this;
        }

        @Override
        public Builder setMaxDstPortRange(int maxDstPortRange) {
            this.maxDstPortRange = maxDstPortRange;
            this.isMaxDstPortRangeSet = true;
            return this;
        }

        @Override
        public Builder setSrcIpPrefix(IpPrefix srcIpPrefix) {
            this.srcIpPrefix = srcIpPrefix;
            this.isSrcIpPrefixSet = true;
            return this;
        }

        @Override
        public Builder setDstIpPrefix(IpPrefix dstIpPrefix) {
            this.dstIpPrefix = dstIpPrefix;
            this.isDstIpPrefixSet = true;
            return this;
        }

        @Override
        public Builder setSrcPort(VirtualPortId srcPort) {
            this.srcPort = srcPort;
            this.isSrcPortSet = true;
            return this;
        }

        @Override
        public Builder setDstPort(VirtualPortId dstPort) {
            this.dstPort = dstPort;
            this.isDstPortSet = true;
            return this;
        }
    }
}

