/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.IpAddress;
import org.onosproject.vtnrsc.AllocationPool;

public final class DefaultAllocationPool
implements AllocationPool {
    private final IpAddress startIp;
    private final IpAddress endIp;

    public DefaultAllocationPool(IpAddress startIp, IpAddress endIp) {
        Preconditions.checkNotNull((Object)startIp, (Object)"StartIp cannot be null");
        Preconditions.checkNotNull((Object)endIp, (Object)"EndIp cannot be null");
        this.startIp = startIp;
        this.endIp = endIp;
    }

    @Override
    public IpAddress startIp() {
        return this.startIp;
    }

    @Override
    public IpAddress endIp() {
        return this.endIp;
    }

    public int hashCode() {
        return Objects.hash(this.startIp, this.endIp);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultAllocationPool) {
            DefaultAllocationPool other = (DefaultAllocationPool)obj;
            return Objects.equals(this.startIp, other.startIp) && Objects.equals(this.endIp, other.endIp);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("startIp", (Object)this.startIp).add("endIp", (Object)this.endIp).toString();
    }
}

