/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;

public final class AllowedAddressPair {
    private final IpAddress ip;
    private final MacAddress mac;

    private AllowedAddressPair(IpAddress ip, MacAddress mac) {
        Preconditions.checkNotNull((Object)ip, (Object)"IpAddress cannot be null");
        Preconditions.checkNotNull((Object)mac, (Object)"MacAddress cannot be null");
        this.ip = ip;
        this.mac = mac;
    }

    public IpAddress ip() {
        return this.ip;
    }

    public MacAddress mac() {
        return this.mac;
    }

    public static AllowedAddressPair allowedAddressPair(IpAddress ip, MacAddress mac) {
        return new AllowedAddressPair(ip, mac);
    }

    public int hashCode() {
        return Objects.hash(this.ip, this.mac);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AllowedAddressPair) {
            AllowedAddressPair that = (AllowedAddressPair)obj;
            return Objects.equals(this.ip, that.ip) && Objects.equals(this.mac, that.mac);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ip", (Object)this.ip).add("mac", (Object)this.mac).toString();
    }
}

