/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vrouter;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.incubator.component.ComponentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class Vrouter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String APP_NAME = "org.onosproject.vrouter";
    private static final String DIRECT_HOST_MGR = "org.onosproject.routing.impl.DirectHostManager";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private ComponentService componentService;
    private ApplicationId appId;
    private List<String> baseComponents = Lists.newArrayList((Object[])new String[]{"org.onosproject.routing.impl.DirectHostManager"});

    @Activate
    protected void activate() {
        this.appId = this.coreService.registerApplication(APP_NAME);
        this.baseComponents.forEach(name -> this.componentService.activate(this.appId, name));
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.log.info("Stopped");
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindComponentService(ComponentService componentService) {
        this.componentService = componentService;
    }

    protected void unbindComponentService(ComponentService componentService) {
        if (this.componentService == componentService) {
            this.componentService = null;
        }
    }
}

