/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.flow.util;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.Ip4Prefix;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.Ip6Prefix;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.TpPort;
import org.onlab.packet.VlanId;
import org.onosproject.core.GroupId;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.DeviceId;
import org.onosproject.net.GridType;
import org.onosproject.net.Lambda;
import org.onosproject.net.OchSignalType;
import org.onosproject.net.OduSignalId;
import org.onosproject.net.OduSignalType;
import org.onosproject.net.PortNumber;
import org.onosproject.net.driver.DefaultDriverData;
import org.onosproject.net.driver.DefaultDriverHandler;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.driver.DriverData;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.flow.DefaultFlowEntry;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.ExtensionSelectorType;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.openflow.controller.ExtensionSelectorInterpreter;
import org.onosproject.openflow.controller.ExtensionTreatmentInterpreter;
import org.onosproject.provider.of.flow.impl.NewAdaptiveFlowStatsCollector;
import org.onosproject.provider.of.flow.util.NoMappingFoundException;
import org.onosproject.provider.of.flow.util.OpenFlowValueMapper;
import org.projectfloodlight.openflow.protocol.OFFlowMod;
import org.projectfloodlight.openflow.protocol.OFFlowRemoved;
import org.projectfloodlight.openflow.protocol.OFFlowStatsEntry;
import org.projectfloodlight.openflow.protocol.OFMatchV3;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFAction;
import org.projectfloodlight.openflow.protocol.action.OFActionCircuit;
import org.projectfloodlight.openflow.protocol.action.OFActionEnqueue;
import org.projectfloodlight.openflow.protocol.action.OFActionExperimenter;
import org.projectfloodlight.openflow.protocol.action.OFActionGroup;
import org.projectfloodlight.openflow.protocol.action.OFActionOutput;
import org.projectfloodlight.openflow.protocol.action.OFActionPopMpls;
import org.projectfloodlight.openflow.protocol.action.OFActionPushVlan;
import org.projectfloodlight.openflow.protocol.action.OFActionSetDlDst;
import org.projectfloodlight.openflow.protocol.action.OFActionSetDlSrc;
import org.projectfloodlight.openflow.protocol.action.OFActionSetField;
import org.projectfloodlight.openflow.protocol.action.OFActionSetNwDst;
import org.projectfloodlight.openflow.protocol.action.OFActionSetNwSrc;
import org.projectfloodlight.openflow.protocol.action.OFActionSetQueue;
import org.projectfloodlight.openflow.protocol.action.OFActionSetVlanPcp;
import org.projectfloodlight.openflow.protocol.action.OFActionSetVlanVid;
import org.projectfloodlight.openflow.protocol.instruction.OFInstruction;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionApplyActions;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionGotoTable;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionWriteActions;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionWriteMetadata;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmOchSigid;
import org.projectfloodlight.openflow.protocol.ver13.OFFactoryVer13;
import org.projectfloodlight.openflow.types.ArpOpcode;
import org.projectfloodlight.openflow.types.CircuitSignalID;
import org.projectfloodlight.openflow.types.EthType;
import org.projectfloodlight.openflow.types.ICMPv4Code;
import org.projectfloodlight.openflow.types.ICMPv4Type;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.IPv6Address;
import org.projectfloodlight.openflow.types.IPv6FlowLabel;
import org.projectfloodlight.openflow.types.IpDscp;
import org.projectfloodlight.openflow.types.IpEcn;
import org.projectfloodlight.openflow.types.IpProtocol;
import org.projectfloodlight.openflow.types.Masked;
import org.projectfloodlight.openflow.types.OFBooleanValue;
import org.projectfloodlight.openflow.types.OFMetadata;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.OFVlanVidMatch;
import org.projectfloodlight.openflow.types.OduSignalID;
import org.projectfloodlight.openflow.types.TransportPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.types.U8;
import org.projectfloodlight.openflow.types.VlanPcp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowEntryBuilder {
    private static final Logger log = LoggerFactory.getLogger(FlowEntryBuilder.class);
    private final OFFlowStatsEntry stat;
    private final OFFlowRemoved removed;
    private final OFFlowMod flowMod;
    private final Match match;
    private final List<OFInstruction> instructions;
    private final DeviceId deviceId;
    private final FlowType type;
    private final DriverService driverService;
    private NewAdaptiveFlowStatsCollector afsc;

    public FlowEntryBuilder(DeviceId deviceId, OFFlowStatsEntry entry, DriverService driverService) {
        this.stat = entry;
        this.match = entry.getMatch();
        this.instructions = this.getInstructions(entry);
        this.deviceId = deviceId;
        this.removed = null;
        this.flowMod = null;
        this.type = FlowType.STAT;
        this.driverService = driverService;
        this.afsc = null;
    }

    public FlowEntryBuilder(DeviceId deviceId, OFFlowRemoved removed, DriverService driverService) {
        this.match = removed.getMatch();
        this.removed = removed;
        this.deviceId = deviceId;
        this.instructions = null;
        this.stat = null;
        this.flowMod = null;
        this.type = FlowType.REMOVED;
        this.driverService = driverService;
        this.afsc = null;
    }

    public FlowEntryBuilder(DeviceId deviceId, OFFlowMod fm, DriverService driverService) {
        this.match = fm.getMatch();
        this.deviceId = deviceId;
        this.instructions = this.getInstructions(fm);
        this.type = FlowType.MOD;
        this.flowMod = fm;
        this.stat = null;
        this.removed = null;
        this.driverService = driverService;
        this.afsc = null;
    }

    public FlowEntryBuilder withSetAfsc(NewAdaptiveFlowStatsCollector afsc) {
        this.afsc = afsc;
        return this;
    }

    public FlowEntry build(FlowEntry.FlowEntryState ... state) {
        try {
            switch (this.type) {
                case STAT: {
                    FlowRule.Builder builder = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(this.buildSelector()).withTreatment(this.buildTreatment()).withPriority(this.stat.getPriority()).withIdleTimeout(this.stat.getIdleTimeout()).withCookie(this.stat.getCookie().getValue());
                    if (this.stat.getVersion() != OFVersion.OF_10) {
                        builder.forTable((int)this.stat.getTableId().getValue());
                    }
                    if (this.afsc != null) {
                        FlowEntry.FlowLiveType liveType = this.afsc.calFlowLiveType(this.stat.getDurationSec());
                        return new DefaultFlowEntry(builder.build(), FlowEntry.FlowEntryState.ADDED, TimeUnit.SECONDS.toNanos(this.stat.getDurationSec()) + this.stat.getDurationNsec(), TimeUnit.NANOSECONDS, liveType, this.stat.getPacketCount().getValue(), this.stat.getByteCount().getValue());
                    }
                    return new DefaultFlowEntry(builder.build(), FlowEntry.FlowEntryState.ADDED, this.stat.getDurationSec(), this.stat.getPacketCount().getValue(), this.stat.getByteCount().getValue());
                }
                case REMOVED: {
                    FlowRule.Builder builder = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(this.buildSelector()).withPriority(this.removed.getPriority()).withIdleTimeout(this.removed.getIdleTimeout()).withCookie(this.removed.getCookie().getValue()).withReason(FlowRule.FlowRemoveReason.parseShort((short)this.removed.getReason()));
                    if (this.removed.getVersion() != OFVersion.OF_10) {
                        builder.forTable((int)this.removed.getTableId().getValue());
                    }
                    if (this.afsc != null) {
                        FlowEntry.FlowLiveType liveType = this.afsc.calFlowLiveType(this.removed.getDurationSec());
                        return new DefaultFlowEntry(builder.build(), FlowEntry.FlowEntryState.REMOVED, TimeUnit.SECONDS.toNanos(this.removed.getDurationSec()) + this.removed.getDurationNsec(), TimeUnit.NANOSECONDS, liveType, this.removed.getPacketCount().getValue(), this.removed.getByteCount().getValue());
                    }
                    return new DefaultFlowEntry(builder.build(), FlowEntry.FlowEntryState.REMOVED, this.removed.getDurationSec(), this.removed.getPacketCount().getValue(), this.removed.getByteCount().getValue());
                }
                case MOD: {
                    FlowEntry.FlowEntryState flowState = state.length > 0 ? state[0] : FlowEntry.FlowEntryState.FAILED;
                    FlowRule.Builder builder = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(this.buildSelector()).withTreatment(this.buildTreatment()).withPriority(this.flowMod.getPriority()).withIdleTimeout(this.flowMod.getIdleTimeout()).withCookie(this.flowMod.getCookie().getValue());
                    if (this.flowMod.getVersion() != OFVersion.OF_10) {
                        builder.forTable((int)this.flowMod.getTableId().getValue());
                    }
                    if (this.afsc != null) {
                        FlowEntry.FlowLiveType liveType = FlowEntry.FlowLiveType.IMMEDIATE;
                        return new DefaultFlowEntry(builder.build(), flowState, 0L, liveType, 0L, 0L);
                    }
                    return new DefaultFlowEntry(builder.build(), flowState, 0L, 0L, 0L);
                }
            }
            log.error("Unknown flow type : {}", (Object)this.type);
            return null;
        }
        catch (UnsupportedOperationException e) {
            log.warn("Error building flow entry", (Throwable)e);
            return null;
        }
    }

    private List<OFInstruction> getInstructions(OFFlowMod entry) {
        switch (entry.getVersion()) {
            case OF_10: {
                return Lists.newArrayList((Object[])new OFInstruction[]{OFFactoryVer13.INSTANCE.instructions().applyActions(entry.getActions())});
            }
            case OF_11: 
            case OF_12: 
            case OF_13: {
                return entry.getInstructions();
            }
        }
        log.warn("Unknown OF version {}", (Object)entry.getVersion());
        return Lists.newLinkedList();
    }

    private List<OFInstruction> getInstructions(OFFlowStatsEntry entry) {
        switch (entry.getVersion()) {
            case OF_10: {
                return Lists.newArrayList((Object[])new OFInstruction[]{OFFactoryVer13.INSTANCE.instructions().applyActions(entry.getActions())});
            }
            case OF_11: 
            case OF_12: 
            case OF_13: {
                return entry.getInstructions();
            }
        }
        log.warn("Unknown OF version {}", (Object)entry.getVersion());
        return Lists.newLinkedList();
    }

    private TrafficTreatment buildTreatment() {
        TrafficTreatment.Builder builder = DefaultTrafficTreatment.builder();
        block9: for (OFInstruction in : this.instructions) {
            switch (in.getType()) {
                case GOTO_TABLE: {
                    builder.transition(Integer.valueOf(((OFInstructionGotoTable)in).getTableId().getValue()));
                    continue block9;
                }
                case WRITE_METADATA: {
                    OFInstructionWriteMetadata m = (OFInstructionWriteMetadata)in;
                    builder.writeMetadata(m.getMetadata().getValue(), m.getMetadataMask().getValue());
                    continue block9;
                }
                case WRITE_ACTIONS: {
                    builder.deferred();
                    this.buildActions(((OFInstructionWriteActions)in).getActions(), builder);
                    continue block9;
                }
                case APPLY_ACTIONS: {
                    builder.immediate();
                    this.buildActions(((OFInstructionApplyActions)in).getActions(), builder);
                    continue block9;
                }
                case CLEAR_ACTIONS: {
                    builder.wipeDeferred();
                    continue block9;
                }
                case EXPERIMENTER: {
                    continue block9;
                }
                case METER: {
                    continue block9;
                }
            }
            log.warn("Unknown instructions type {}", (Object)in.getType());
        }
        return builder.build();
    }

    public static TrafficTreatment.Builder configureTreatmentBuilder(List<OFAction> actions, TrafficTreatment.Builder builder, DriverHandler driverHandler, DeviceId deviceId) {
        ExtensionTreatmentInterpreter interpreter = driverHandler.hasBehaviour(ExtensionTreatmentInterpreter.class) ? (ExtensionTreatmentInterpreter)driverHandler.behaviour(ExtensionTreatmentInterpreter.class) : null;
        block22: for (OFAction act : actions) {
            switch (act.getType()) {
                case OUTPUT: {
                    OFActionOutput out = (OFActionOutput)act;
                    builder.setOutput(PortNumber.portNumber((long)out.getPort().getPortNumber()));
                    continue block22;
                }
                case SET_VLAN_VID: {
                    OFActionSetVlanVid vlan = (OFActionSetVlanVid)act;
                    builder.setVlanId(VlanId.vlanId((short)vlan.getVlanVid().getVlan()));
                    continue block22;
                }
                case SET_VLAN_PCP: {
                    OFActionSetVlanPcp pcp = (OFActionSetVlanPcp)act;
                    builder.setVlanPcp(Byte.valueOf(pcp.getVlanPcp().getValue()));
                    continue block22;
                }
                case SET_DL_DST: {
                    OFActionSetDlDst dldst = (OFActionSetDlDst)act;
                    builder.setEthDst(MacAddress.valueOf((long)dldst.getDlAddr().getLong()));
                    continue block22;
                }
                case SET_DL_SRC: {
                    OFActionSetDlSrc dlsrc = (OFActionSetDlSrc)act;
                    builder.setEthSrc(MacAddress.valueOf((long)dlsrc.getDlAddr().getLong()));
                    continue block22;
                }
                case SET_NW_DST: {
                    OFActionSetNwDst nwdst = (OFActionSetNwDst)act;
                    IPv4Address di = nwdst.getNwAddr();
                    builder.setIpDst((IpAddress)Ip4Address.valueOf((int)di.getInt()));
                    continue block22;
                }
                case SET_NW_SRC: {
                    OFActionSetNwSrc nwsrc = (OFActionSetNwSrc)act;
                    IPv4Address si = nwsrc.getNwAddr();
                    builder.setIpSrc((IpAddress)Ip4Address.valueOf((int)si.getInt()));
                    continue block22;
                }
                case EXPERIMENTER: {
                    OFActionExperimenter exp = (OFActionExperimenter)act;
                    if (exp.getExperimenter() == -2147460602L || exp.getExperimenter() == 7636849L) {
                        OFActionCircuit ct = (OFActionCircuit)exp;
                        CircuitSignalID circuitSignalID = ((OFOxmOchSigid)ct.getField()).getValue();
                        builder.add((Instruction)Instructions.modL0Lambda((Lambda)Lambda.ochSignal((GridType)OpenFlowValueMapper.lookupGridType(circuitSignalID.getGridType()), (ChannelSpacing)OpenFlowValueMapper.lookupChannelSpacing(circuitSignalID.getChannelSpacing()), (int)circuitSignalID.getChannelNumber(), (int)circuitSignalID.getSpectralWidth())));
                        continue block22;
                    }
                    if (interpreter != null) {
                        builder.extension(interpreter.mapAction((OFAction)exp), deviceId);
                        continue block22;
                    }
                    log.warn("Unsupported OFActionExperimenter {}", (Object)exp.getExperimenter());
                    continue block22;
                }
                case SET_FIELD: {
                    OFActionSetField setField = (OFActionSetField)act;
                    FlowEntryBuilder.handleSetField(builder, setField, driverHandler, deviceId);
                    continue block22;
                }
                case POP_MPLS: {
                    OFActionPopMpls popMpls = (OFActionPopMpls)act;
                    builder.popMpls(new org.onlab.packet.EthType(popMpls.getEthertype().getValue()));
                    continue block22;
                }
                case PUSH_MPLS: {
                    builder.pushMpls();
                    continue block22;
                }
                case COPY_TTL_IN: {
                    builder.copyTtlIn();
                    continue block22;
                }
                case COPY_TTL_OUT: {
                    builder.copyTtlOut();
                    continue block22;
                }
                case DEC_MPLS_TTL: {
                    builder.decMplsTtl();
                    continue block22;
                }
                case DEC_NW_TTL: {
                    builder.decNwTtl();
                    continue block22;
                }
                case GROUP: {
                    OFActionGroup group = (OFActionGroup)act;
                    builder.group(new GroupId(group.getGroup().getGroupNumber()));
                    continue block22;
                }
                case SET_QUEUE: {
                    OFActionSetQueue setQueue = (OFActionSetQueue)act;
                    builder.setQueue(setQueue.getQueueId());
                    continue block22;
                }
                case ENQUEUE: {
                    OFActionEnqueue enqueue = (OFActionEnqueue)act;
                    builder.setQueue(enqueue.getQueueId(), PortNumber.portNumber((long)enqueue.getPort().getPortNumber()));
                    continue block22;
                }
                case STRIP_VLAN: 
                case POP_VLAN: {
                    builder.popVlan();
                    continue block22;
                }
                case PUSH_VLAN: {
                    OFActionPushVlan pushVlan = (OFActionPushVlan)act;
                    builder.pushVlan(new org.onlab.packet.EthType((short)pushVlan.getEthertype().getValue()));
                    continue block22;
                }
            }
            log.warn("Action type {} not yet implemented.", (Object)act.getType());
        }
        return builder;
    }

    private TrafficTreatment.Builder buildActions(List<OFAction> actions, TrafficTreatment.Builder builder) {
        DriverHandler driverHandler = this.getDriver(this.deviceId);
        return FlowEntryBuilder.configureTreatmentBuilder(actions, builder, driverHandler, this.deviceId);
    }

    private static void handleSetField(TrafficTreatment.Builder builder, OFActionSetField action, DriverHandler driverHandler, DeviceId deviceId) {
        ExtensionTreatmentInterpreter treatmentInterpreter = driverHandler.hasBehaviour(ExtensionTreatmentInterpreter.class) ? (ExtensionTreatmentInterpreter)driverHandler.behaviour(ExtensionTreatmentInterpreter.class) : null;
        OFOxm oxm = action.getField();
        switch (oxm.getMatchField().id) {
            case VLAN_PCP: {
                OFOxm vlanpcp = oxm;
                builder.setVlanPcp(Byte.valueOf(((VlanPcp)vlanpcp.getValue()).getValue()));
                break;
            }
            case VLAN_VID: {
                if (treatmentInterpreter != null) {
                    try {
                        builder.extension(treatmentInterpreter.mapAction((OFAction)action), deviceId);
                        break;
                    }
                    catch (UnsupportedOperationException e) {
                        log.debug("Unsupported action extension; defaulting to native OF");
                    }
                }
                OFOxm vlanvid = oxm;
                builder.setVlanId(VlanId.vlanId((short)((OFVlanVidMatch)vlanvid.getValue()).getVlan()));
                break;
            }
            case ETH_DST: {
                OFOxm ethdst = oxm;
                builder.setEthDst(MacAddress.valueOf((long)((org.projectfloodlight.openflow.types.MacAddress)ethdst.getValue()).getLong()));
                break;
            }
            case ETH_SRC: {
                OFOxm ethsrc = oxm;
                builder.setEthSrc(MacAddress.valueOf((long)((org.projectfloodlight.openflow.types.MacAddress)ethsrc.getValue()).getLong()));
                break;
            }
            case IPV4_DST: {
                OFOxm ip4dst = oxm;
                builder.setIpDst((IpAddress)Ip4Address.valueOf((int)((IPv4Address)ip4dst.getValue()).getInt()));
                break;
            }
            case IPV4_SRC: {
                OFOxm ip4src = oxm;
                builder.setIpSrc((IpAddress)Ip4Address.valueOf((int)((IPv4Address)ip4src.getValue()).getInt()));
                break;
            }
            case MPLS_LABEL: {
                OFOxm labelId = oxm;
                builder.setMpls(MplsLabel.mplsLabel((int)((int)((U32)labelId.getValue()).getValue())));
                break;
            }
            case MPLS_BOS: {
                OFOxm mplsBos = oxm;
                builder.setMplsBos(((OFBooleanValue)mplsBos.getValue()).getValue());
                break;
            }
            case TUNNEL_ID: {
                OFOxm tunnelId = oxm;
                builder.setTunnelId(((U64)tunnelId.getValue()).getValue());
                break;
            }
            case TCP_DST: {
                OFOxm tcpdst = oxm;
                builder.setTcpDst(TpPort.tpPort((int)((TransportPort)tcpdst.getValue()).getPort()));
                break;
            }
            case TCP_SRC: {
                OFOxm tcpsrc = oxm;
                builder.setTcpSrc(TpPort.tpPort((int)((TransportPort)tcpsrc.getValue()).getPort()));
                break;
            }
            case UDP_DST: {
                OFOxm udpdst = oxm;
                builder.setUdpDst(TpPort.tpPort((int)((TransportPort)udpdst.getValue()).getPort()));
                break;
            }
            case UDP_SRC: {
                OFOxm udpsrc = oxm;
                builder.setUdpSrc(TpPort.tpPort((int)((TransportPort)udpsrc.getValue()).getPort()));
                break;
            }
            case TUNNEL_IPV4_DST: 
            case NSP: 
            case NSI: 
            case NSH_C1: 
            case NSH_C2: 
            case NSH_C3: 
            case NSH_C4: 
            case NSH_MDTYPE: 
            case NSH_NP: 
            case ENCAP_ETH_SRC: 
            case ENCAP_ETH_DST: 
            case ENCAP_ETH_TYPE: 
            case TUN_GPE_NP: {
                if (treatmentInterpreter == null) break;
                try {
                    builder.extension(treatmentInterpreter.mapAction((OFAction)action), deviceId);
                }
                catch (UnsupportedOperationException e) {
                    log.debug(e.getMessage());
                }
                break;
            }
            case EXP_ODU_SIG_ID: {
                OFOxm oduID = oxm;
                OduSignalID oduSignalID = (OduSignalID)oduID.getValue();
                OduSignalId oduSignalId = OduSignalId.oduSignalId((int)oduSignalID.getTpn(), (int)oduSignalID.getTslen(), (byte[])oduSignalID.getTsmap());
                builder.add((Instruction)Instructions.modL1OduSignalId((OduSignalId)oduSignalId));
                break;
            }
            case EXP_OCH_SIG_ID: {
                try {
                    OFOxm ochId = oxm;
                    CircuitSignalID circuitSignalID = (CircuitSignalID)ochId.getValue();
                    builder.add((Instruction)Instructions.modL0Lambda((Lambda)Lambda.ochSignal((GridType)OpenFlowValueMapper.lookupGridType(circuitSignalID.getGridType()), (ChannelSpacing)OpenFlowValueMapper.lookupChannelSpacing(circuitSignalID.getChannelSpacing()), (int)circuitSignalID.getChannelNumber(), (int)circuitSignalID.getSpectralWidth())));
                }
                catch (NoMappingFoundException e) {
                    log.warn(e.getMessage());
                }
                break;
            }
            case ARP_OP: {
                OFOxm arpop = oxm;
                builder.setArpOp((short)((ArpOpcode)arpop.getValue()).getOpcode());
                break;
            }
            case ARP_SHA: {
                OFOxm arpsha = oxm;
                builder.setArpSha(MacAddress.valueOf((long)((org.projectfloodlight.openflow.types.MacAddress)arpsha.getValue()).getLong()));
                break;
            }
            case ARP_SPA: {
                OFOxm arpspa = oxm;
                builder.setArpSpa((IpAddress)Ip4Address.valueOf((int)((IPv4Address)arpspa.getValue()).getInt()));
                break;
            }
            case OFDPA_MPLS_TYPE: 
            case OFDPA_OVID: 
            case OFDPA_MPLS_L2_PORT: 
            case OFDPA_QOS_INDEX: {
                if (treatmentInterpreter == null) break;
                try {
                    builder.extension(treatmentInterpreter.mapAction((OFAction)action), deviceId);
                }
                catch (UnsupportedOperationException e) {
                    log.warn("Unsupported action extension");
                }
                break;
            }
            default: {
                log.warn("Set field type {} not yet implemented.", (Object)oxm.getMatchField().id);
            }
        }
    }

    private TrafficSelector buildSelector() {
        DriverHandler driverHandler = this.getDriver(this.deviceId);
        ExtensionSelectorInterpreter selectorInterpreter = driverHandler.hasBehaviour(ExtensionSelectorInterpreter.class) ? (ExtensionSelectorInterpreter)driverHandler.behaviour(ExtensionSelectorInterpreter.class) : null;
        TrafficSelector.Builder builder = DefaultTrafficSelector.builder();
        block72: for (MatchField field : this.match.getMatchFields()) {
            switch (field.id) {
                case IN_PORT: {
                    builder.matchInPort(PortNumber.portNumber((long)((OFPort)this.match.get(MatchField.IN_PORT)).getPortNumber()));
                    break;
                }
                case IN_PHY_PORT: {
                    builder.matchInPhyPort(PortNumber.portNumber((long)((OFPort)this.match.get(MatchField.IN_PHY_PORT)).getPortNumber()));
                    break;
                }
                case METADATA: {
                    long metadata = ((OFMetadata)this.match.get(MatchField.METADATA)).getValue().getValue();
                    builder.matchMetadata(metadata);
                    break;
                }
                case ETH_DST: {
                    if (this.match.isPartiallyMasked(MatchField.ETH_DST)) {
                        Masked maskedMac = this.match.getMasked(MatchField.ETH_DST);
                        builder.matchEthDstMasked(MacAddress.valueOf((long)((org.projectfloodlight.openflow.types.MacAddress)maskedMac.getValue()).getLong()), MacAddress.valueOf((long)((org.projectfloodlight.openflow.types.MacAddress)maskedMac.getMask()).getLong()));
                        break;
                    }
                    MacAddress mac = MacAddress.valueOf((long)((org.projectfloodlight.openflow.types.MacAddress)this.match.get(MatchField.ETH_DST)).getLong());
                    builder.matchEthDst(mac);
                    break;
                }
                case ETH_SRC: {
                    if (this.match.isPartiallyMasked(MatchField.ETH_SRC)) {
                        Masked maskedMac = this.match.getMasked(MatchField.ETH_SRC);
                        builder.matchEthSrcMasked(MacAddress.valueOf((long)((org.projectfloodlight.openflow.types.MacAddress)maskedMac.getValue()).getLong()), MacAddress.valueOf((long)((org.projectfloodlight.openflow.types.MacAddress)maskedMac.getMask()).getLong()));
                        break;
                    }
                    MacAddress mac = MacAddress.valueOf((long)((org.projectfloodlight.openflow.types.MacAddress)this.match.get(MatchField.ETH_SRC)).getLong());
                    builder.matchEthSrc(mac);
                    break;
                }
                case ETH_TYPE: {
                    int ethType = ((EthType)this.match.get(MatchField.ETH_TYPE)).getValue();
                    builder.matchEthType((short)ethType);
                    break;
                }
                case VLAN_VID: {
                    if (selectorInterpreter != null && selectorInterpreter.supported(ExtensionSelectorType.ExtensionSelectorTypes.OFDPA_MATCH_VLAN_VID.type())) {
                        if (!this.match.getVersion().equals((Object)OFVersion.OF_13)) continue block72;
                        OFOxm oxm = ((OFMatchV3)this.match).getOxmList().get(MatchField.VLAN_VID);
                        builder.extension(selectorInterpreter.mapOxm(oxm), this.deviceId);
                        break;
                    }
                    VlanId vlanId = null;
                    if (this.match.isPartiallyMasked(MatchField.VLAN_VID)) {
                        Masked masked = this.match.getMasked(MatchField.VLAN_VID);
                        if (((OFVlanVidMatch)masked.getValue()).equals((Object)OFVlanVidMatch.PRESENT) && ((OFVlanVidMatch)masked.getMask()).equals((Object)OFVlanVidMatch.PRESENT)) {
                            vlanId = VlanId.ANY;
                        }
                    } else {
                        vlanId = !((OFVlanVidMatch)this.match.get(MatchField.VLAN_VID)).isPresentBitSet() ? VlanId.NONE : VlanId.vlanId((short)((OFVlanVidMatch)this.match.get(MatchField.VLAN_VID)).getVlan());
                    }
                    if (vlanId == null) continue block72;
                    builder.matchVlanId(vlanId);
                    break;
                }
                case VLAN_PCP: {
                    byte vlanPcp = ((VlanPcp)this.match.get(MatchField.VLAN_PCP)).getValue();
                    builder.matchVlanPcp(vlanPcp);
                    break;
                }
                case IP_DSCP: {
                    byte ipDscp = ((IpDscp)this.match.get(MatchField.IP_DSCP)).getDscpValue();
                    builder.matchIPDscp(ipDscp);
                    break;
                }
                case IP_ECN: {
                    byte ipEcn = ((IpEcn)this.match.get(MatchField.IP_ECN)).getEcnValue();
                    builder.matchIPEcn(ipEcn);
                    break;
                }
                case IP_PROTO: {
                    short proto = ((IpProtocol)this.match.get(MatchField.IP_PROTO)).getIpProtocolNumber();
                    builder.matchIPProtocol((byte)proto);
                    break;
                }
                case IPV4_SRC: {
                    Ip4Prefix ip4Prefix;
                    if (this.match.isPartiallyMasked(MatchField.IPV4_SRC)) {
                        Masked maskedIp = this.match.getMasked(MatchField.IPV4_SRC);
                        ip4Prefix = Ip4Prefix.valueOf((int)((IPv4Address)maskedIp.getValue()).getInt(), (int)((IPv4Address)maskedIp.getMask()).asCidrMaskLength());
                    } else {
                        ip4Prefix = Ip4Prefix.valueOf((int)((IPv4Address)this.match.get(MatchField.IPV4_SRC)).getInt(), (int)32);
                    }
                    builder.matchIPSrc((IpPrefix)ip4Prefix);
                    break;
                }
                case IPV4_DST: {
                    Ip4Prefix ip4Prefix;
                    if (this.match.isPartiallyMasked(MatchField.IPV4_DST)) {
                        Masked maskedIp = this.match.getMasked(MatchField.IPV4_DST);
                        ip4Prefix = Ip4Prefix.valueOf((int)((IPv4Address)maskedIp.getValue()).getInt(), (int)((IPv4Address)maskedIp.getMask()).asCidrMaskLength());
                    } else {
                        ip4Prefix = Ip4Prefix.valueOf((int)((IPv4Address)this.match.get(MatchField.IPV4_DST)).getInt(), (int)32);
                    }
                    builder.matchIPDst((IpPrefix)ip4Prefix);
                    break;
                }
                case TCP_SRC: {
                    if (this.match.isPartiallyMasked(MatchField.TCP_SRC)) {
                        Masked maskedPort = this.match.getMasked(MatchField.TCP_SRC);
                        builder.matchTcpSrcMasked(TpPort.tpPort((int)((TransportPort)maskedPort.getValue()).getPort()), TpPort.tpPort((int)((TransportPort)maskedPort.getMask()).getPort()));
                        break;
                    }
                    builder.matchTcpSrc(TpPort.tpPort((int)((TransportPort)this.match.get(MatchField.TCP_SRC)).getPort()));
                    break;
                }
                case TCP_DST: {
                    if (this.match.isPartiallyMasked(MatchField.TCP_DST)) {
                        Masked maskedPort = this.match.getMasked(MatchField.TCP_DST);
                        builder.matchTcpDstMasked(TpPort.tpPort((int)((TransportPort)maskedPort.getValue()).getPort()), TpPort.tpPort((int)((TransportPort)maskedPort.getMask()).getPort()));
                        break;
                    }
                    builder.matchTcpDst(TpPort.tpPort((int)((TransportPort)this.match.get(MatchField.TCP_DST)).getPort()));
                    break;
                }
                case UDP_SRC: {
                    if (this.match.isPartiallyMasked(MatchField.UDP_SRC)) {
                        Masked maskedPort = this.match.getMasked(MatchField.UDP_SRC);
                        builder.matchUdpSrcMasked(TpPort.tpPort((int)((TransportPort)maskedPort.getValue()).getPort()), TpPort.tpPort((int)((TransportPort)maskedPort.getMask()).getPort()));
                        break;
                    }
                    builder.matchUdpSrc(TpPort.tpPort((int)((TransportPort)this.match.get(MatchField.UDP_SRC)).getPort()));
                    break;
                }
                case UDP_DST: {
                    if (this.match.isPartiallyMasked(MatchField.UDP_DST)) {
                        Masked maskedPort = this.match.getMasked(MatchField.UDP_DST);
                        builder.matchUdpDstMasked(TpPort.tpPort((int)((TransportPort)maskedPort.getValue()).getPort()), TpPort.tpPort((int)((TransportPort)maskedPort.getMask()).getPort()));
                        break;
                    }
                    builder.matchUdpDst(TpPort.tpPort((int)((TransportPort)this.match.get(MatchField.UDP_DST)).getPort()));
                    break;
                }
                case MPLS_LABEL: {
                    builder.matchMplsLabel(MplsLabel.mplsLabel((int)((int)((U32)this.match.get(MatchField.MPLS_LABEL)).getValue())));
                    break;
                }
                case MPLS_BOS: {
                    builder.matchMplsBos(((OFBooleanValue)this.match.get(MatchField.MPLS_BOS)).getValue());
                    break;
                }
                case SCTP_SRC: {
                    if (this.match.isPartiallyMasked(MatchField.SCTP_SRC)) {
                        Masked maskedPort = this.match.getMasked(MatchField.SCTP_SRC);
                        builder.matchSctpSrcMasked(TpPort.tpPort((int)((TransportPort)maskedPort.getValue()).getPort()), TpPort.tpPort((int)((TransportPort)maskedPort.getMask()).getPort()));
                        break;
                    }
                    builder.matchSctpSrc(TpPort.tpPort((int)((TransportPort)this.match.get(MatchField.SCTP_SRC)).getPort()));
                    break;
                }
                case SCTP_DST: {
                    if (this.match.isPartiallyMasked(MatchField.SCTP_DST)) {
                        Masked maskedPort = this.match.getMasked(MatchField.SCTP_DST);
                        builder.matchSctpDstMasked(TpPort.tpPort((int)((TransportPort)maskedPort.getValue()).getPort()), TpPort.tpPort((int)((TransportPort)maskedPort.getMask()).getPort()));
                        break;
                    }
                    builder.matchSctpDst(TpPort.tpPort((int)((TransportPort)this.match.get(MatchField.SCTP_DST)).getPort()));
                    break;
                }
                case ICMPV4_TYPE: {
                    byte icmpType = (byte)((ICMPv4Type)this.match.get(MatchField.ICMPV4_TYPE)).getType();
                    builder.matchIcmpType(icmpType);
                    break;
                }
                case ICMPV4_CODE: {
                    byte icmpCode = (byte)((ICMPv4Code)this.match.get(MatchField.ICMPV4_CODE)).getCode();
                    builder.matchIcmpCode(icmpCode);
                    break;
                }
                case IPV6_SRC: {
                    Ip6Prefix ip6Prefix;
                    if (this.match.isPartiallyMasked(MatchField.IPV6_SRC)) {
                        Masked maskedIp = this.match.getMasked(MatchField.IPV6_SRC);
                        ip6Prefix = Ip6Prefix.valueOf((byte[])((IPv6Address)maskedIp.getValue()).getBytes(), (int)((IPv6Address)maskedIp.getMask()).asCidrMaskLength());
                    } else {
                        ip6Prefix = Ip6Prefix.valueOf((byte[])((IPv6Address)this.match.get(MatchField.IPV6_SRC)).getBytes(), (int)128);
                    }
                    builder.matchIPv6Src((IpPrefix)ip6Prefix);
                    break;
                }
                case IPV6_DST: {
                    Ip6Prefix ip6Prefix;
                    if (this.match.isPartiallyMasked(MatchField.IPV6_DST)) {
                        Masked maskedIp = this.match.getMasked(MatchField.IPV6_DST);
                        ip6Prefix = Ip6Prefix.valueOf((byte[])((IPv6Address)maskedIp.getValue()).getBytes(), (int)((IPv6Address)maskedIp.getMask()).asCidrMaskLength());
                    } else {
                        ip6Prefix = Ip6Prefix.valueOf((byte[])((IPv6Address)this.match.get(MatchField.IPV6_DST)).getBytes(), (int)128);
                    }
                    builder.matchIPv6Dst((IpPrefix)ip6Prefix);
                    break;
                }
                case IPV6_FLABEL: {
                    int flowLabel = ((IPv6FlowLabel)this.match.get(MatchField.IPV6_FLABEL)).getIPv6FlowLabelValue();
                    builder.matchIPv6FlowLabel(flowLabel);
                    break;
                }
                case ICMPV6_TYPE: {
                    byte icmpv6type = (byte)((U8)this.match.get(MatchField.ICMPV6_TYPE)).getValue();
                    builder.matchIcmpv6Type(icmpv6type);
                    break;
                }
                case ICMPV6_CODE: {
                    byte icmpv6code = (byte)((U8)this.match.get(MatchField.ICMPV6_CODE)).getValue();
                    builder.matchIcmpv6Code(icmpv6code);
                    break;
                }
                case IPV6_ND_TARGET: {
                    Ip6Address ip6Address = Ip6Address.valueOf((byte[])((IPv6Address)this.match.get(MatchField.IPV6_ND_TARGET)).getBytes());
                    builder.matchIPv6NDTargetAddress(ip6Address);
                    break;
                }
                case IPV6_ND_SLL: {
                    MacAddress mac = MacAddress.valueOf((long)((org.projectfloodlight.openflow.types.MacAddress)this.match.get(MatchField.IPV6_ND_SLL)).getLong());
                    builder.matchIPv6NDSourceLinkLayerAddress(mac);
                    break;
                }
                case IPV6_ND_TLL: {
                    MacAddress mac = MacAddress.valueOf((long)((org.projectfloodlight.openflow.types.MacAddress)this.match.get(MatchField.IPV6_ND_TLL)).getLong());
                    builder.matchIPv6NDTargetLinkLayerAddress(mac);
                    break;
                }
                case IPV6_EXTHDR: {
                    builder.matchIPv6ExthdrFlags((short)((U16)this.match.get(MatchField.IPV6_EXTHDR)).getValue());
                    break;
                }
                case OCH_SIGID: {
                    CircuitSignalID sigId = (CircuitSignalID)this.match.get(MatchField.OCH_SIGID);
                    builder.add(Criteria.matchLambda((Lambda)Lambda.ochSignal((GridType)OpenFlowValueMapper.lookupGridType(sigId.getGridType()), (ChannelSpacing)OpenFlowValueMapper.lookupChannelSpacing(sigId.getChannelSpacing()), (int)sigId.getChannelNumber(), (int)sigId.getSpectralWidth())));
                    break;
                }
                case OCH_SIGTYPE: {
                    U8 sigType = (U8)this.match.get(MatchField.OCH_SIGTYPE);
                    builder.add(Criteria.matchOchSignalType((OchSignalType)OpenFlowValueMapper.lookupOchSignalType((byte)sigType.getValue())));
                    break;
                }
                case EXP_OCH_SIG_ID: {
                    try {
                        CircuitSignalID expSigId = (CircuitSignalID)this.match.get(MatchField.EXP_OCH_SIG_ID);
                        builder.add(Criteria.matchLambda((Lambda)Lambda.ochSignal((GridType)OpenFlowValueMapper.lookupGridType(expSigId.getGridType()), (ChannelSpacing)OpenFlowValueMapper.lookupChannelSpacing(expSigId.getChannelSpacing()), (int)expSigId.getChannelNumber(), (int)expSigId.getSpectralWidth())));
                    }
                    catch (NoMappingFoundException e) {
                        log.warn(e.getMessage());
                    }
                    break;
                }
                case EXP_OCH_SIGTYPE: {
                    try {
                        U8 expOchSigType = (U8)this.match.get(MatchField.EXP_OCH_SIGTYPE);
                        builder.add(Criteria.matchOchSignalType((OchSignalType)OpenFlowValueMapper.lookupOchSignalType((byte)expOchSigType.getValue())));
                    }
                    catch (NoMappingFoundException e) {
                        log.warn(e.getMessage());
                    }
                    break;
                }
                case EXP_ODU_SIG_ID: {
                    OduSignalId oduSignalId = OduSignalId.oduSignalId((int)((OduSignalID)this.match.get(MatchField.EXP_ODU_SIG_ID)).getTpn(), (int)((OduSignalID)this.match.get(MatchField.EXP_ODU_SIG_ID)).getTslen(), (byte[])((OduSignalID)this.match.get(MatchField.EXP_ODU_SIG_ID)).getTsmap());
                    builder.add(Criteria.matchOduSignalId((OduSignalId)oduSignalId));
                    break;
                }
                case EXP_ODU_SIGTYPE: {
                    try {
                        U8 oduSigType = (U8)this.match.get(MatchField.EXP_ODU_SIGTYPE);
                        builder.add(Criteria.matchOduSignalType((OduSignalType)OpenFlowValueMapper.lookupOduSignalType((byte)oduSigType.getValue())));
                    }
                    catch (NoMappingFoundException e) {
                        log.warn(e.getMessage());
                    }
                    break;
                }
                case TUNNEL_ID: {
                    long tunnelId = ((U64)this.match.get(MatchField.TUNNEL_ID)).getValue();
                    builder.matchTunnelId(tunnelId);
                    break;
                }
                case ARP_OP: {
                    int arpOp = ((ArpOpcode)this.match.get(MatchField.ARP_OP)).getOpcode();
                    builder.matchArpOp(arpOp);
                    break;
                }
                case ARP_SHA: {
                    MacAddress mac = MacAddress.valueOf((long)((org.projectfloodlight.openflow.types.MacAddress)this.match.get(MatchField.ARP_SHA)).getLong());
                    builder.matchArpSha(mac);
                    break;
                }
                case ARP_SPA: {
                    Ip4Address ip = Ip4Address.valueOf((int)((IPv4Address)this.match.get(MatchField.ARP_SPA)).getInt());
                    builder.matchArpSpa(ip);
                    break;
                }
                case ARP_THA: {
                    MacAddress mac = MacAddress.valueOf((long)((org.projectfloodlight.openflow.types.MacAddress)this.match.get(MatchField.ARP_THA)).getLong());
                    builder.matchArpTha(mac);
                    break;
                }
                case ARP_TPA: {
                    Ip4Address ip = Ip4Address.valueOf((int)((IPv4Address)this.match.get(MatchField.ARP_TPA)).getInt());
                    builder.matchArpTpa(ip);
                    break;
                }
                case NSP: {
                    OFOxm oxm;
                    if (selectorInterpreter == null) continue block72;
                    try {
                        oxm = ((OFMatchV3)this.match).getOxmList().get(MatchField.NSP);
                        builder.extension(selectorInterpreter.mapOxm(oxm), this.deviceId);
                    }
                    catch (UnsupportedOperationException e) {
                        log.debug(e.getMessage());
                    }
                    break;
                }
                case NSI: {
                    OFOxm oxm;
                    if (selectorInterpreter == null) continue block72;
                    try {
                        oxm = ((OFMatchV3)this.match).getOxmList().get(MatchField.NSI);
                        builder.extension(selectorInterpreter.mapOxm(oxm), this.deviceId);
                    }
                    catch (UnsupportedOperationException e) {
                        log.debug(e.getMessage());
                    }
                    break;
                }
                case ENCAP_ETH_TYPE: {
                    OFOxm oxm;
                    if (selectorInterpreter == null) continue block72;
                    try {
                        oxm = ((OFMatchV3)this.match).getOxmList().get(MatchField.ENCAP_ETH_TYPE);
                        builder.extension(selectorInterpreter.mapOxm(oxm), this.deviceId);
                    }
                    catch (UnsupportedOperationException e) {
                        log.debug(e.getMessage());
                    }
                    break;
                }
                case CONNTRACK_STATE: {
                    OFOxm oxm;
                    if (selectorInterpreter == null || !selectorInterpreter.supported(ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_CONNTRACK_STATE.type())) continue block72;
                    try {
                        oxm = ((OFMatchV3)this.match).getOxmList().get(MatchField.CONNTRACK_STATE);
                        builder.extension(selectorInterpreter.mapOxm(oxm), this.deviceId);
                    }
                    catch (UnsupportedOperationException e) {
                        log.debug(e.getMessage());
                    }
                    break;
                }
                case CONNTRACK_ZONE: {
                    OFOxm oxm;
                    if (selectorInterpreter == null || !selectorInterpreter.supported(ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_CONNTRACK_ZONE.type())) continue block72;
                    try {
                        oxm = ((OFMatchV3)this.match).getOxmList().get(MatchField.CONNTRACK_ZONE);
                        builder.extension(selectorInterpreter.mapOxm(oxm), this.deviceId);
                    }
                    catch (UnsupportedOperationException e) {
                        log.debug(e.getMessage());
                    }
                    break;
                }
                case CONNTRACK_MARK: {
                    OFOxm oxm;
                    if (selectorInterpreter == null || !selectorInterpreter.supported(ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_CONNTRACK_MARK.type())) continue block72;
                    try {
                        oxm = ((OFMatchV3)this.match).getOxmList().get(MatchField.CONNTRACK_MARK);
                        builder.extension(selectorInterpreter.mapOxm(oxm), this.deviceId);
                    }
                    catch (UnsupportedOperationException e) {
                        log.debug(e.getMessage());
                    }
                    break;
                }
                case OFDPA_OVID: {
                    if (selectorInterpreter == null || !selectorInterpreter.supported(ExtensionSelectorType.ExtensionSelectorTypes.OFDPA_MATCH_OVID.type()) || !this.match.getVersion().equals((Object)OFVersion.OF_13)) continue block72;
                    OFOxm oxm = ((OFMatchV3)this.match).getOxmList().get(MatchField.OFDPA_OVID);
                    builder.extension(selectorInterpreter.mapOxm(oxm), this.deviceId);
                    break;
                }
                case OFDPA_MPLS_L2_PORT: {
                    if (selectorInterpreter == null || !selectorInterpreter.supported(ExtensionSelectorType.ExtensionSelectorTypes.OFDPA_MATCH_MPLS_L2_PORT.type()) || !this.match.getVersion().equals((Object)OFVersion.OF_13)) continue block72;
                    OFOxm oxm = ((OFMatchV3)this.match).getOxmList().get(MatchField.OFDPA_MPLS_L2_PORT);
                    builder.extension(selectorInterpreter.mapOxm(oxm), this.deviceId);
                    break;
                }
                default: {
                    log.warn("Match type {} not yet implemented.", (Object)field.id);
                }
            }
        }
        return builder.build();
    }

    private DriverHandler getDriver(DeviceId devId) {
        Driver driver = this.driverService.getDriver(devId);
        DefaultDriverHandler handler = new DefaultDriverHandler((DriverData)new DefaultDriverData(driver, devId));
        return handler;
    }

    public static enum FlowType {
        STAT,
        REMOVED,
        MOD;

    }
}

