/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.flow.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.flow.CompletedBatchOperation;
import org.onosproject.net.flow.DefaultTableStatisticsEntry;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleBatchEntry;
import org.onosproject.net.flow.FlowRuleBatchOperation;
import org.onosproject.net.flow.FlowRuleExtPayLoad;
import org.onosproject.net.flow.FlowRuleProvider;
import org.onosproject.net.flow.FlowRuleProviderRegistry;
import org.onosproject.net.flow.FlowRuleProviderService;
import org.onosproject.net.flow.TableStatisticsEntry;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.statistic.DefaultLoad;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.OpenFlowController;
import org.onosproject.openflow.controller.OpenFlowEventListener;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.onosproject.openflow.controller.OpenFlowSwitchListener;
import org.onosproject.openflow.controller.RoleState;
import org.onosproject.openflow.controller.ThirdPartyMessage;
import org.onosproject.provider.of.flow.impl.FlowModBuilder;
import org.onosproject.provider.of.flow.impl.FlowStatsCollector;
import org.onosproject.provider.of.flow.impl.NewAdaptiveFlowStatsCollector;
import org.onosproject.provider.of.flow.impl.SwitchDataCollector;
import org.onosproject.provider.of.flow.impl.TableStatisticsCollector;
import org.onosproject.provider.of.flow.util.FlowEntryBuilder;
import org.osgi.service.component.ComponentContext;
import org.projectfloodlight.openflow.protocol.OFBadRequestCode;
import org.projectfloodlight.openflow.protocol.OFBarrierRequest;
import org.projectfloodlight.openflow.protocol.OFErrorMsg;
import org.projectfloodlight.openflow.protocol.OFFlowMod;
import org.projectfloodlight.openflow.protocol.OFFlowRemoved;
import org.projectfloodlight.openflow.protocol.OFFlowStatsEntry;
import org.projectfloodlight.openflow.protocol.OFFlowStatsReply;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFPortStatus;
import org.projectfloodlight.openflow.protocol.OFStatsReply;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFTableStatsEntry;
import org.projectfloodlight.openflow.protocol.OFTableStatsReply;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.errormsg.OFBadActionErrorMsg;
import org.projectfloodlight.openflow.protocol.errormsg.OFBadInstructionErrorMsg;
import org.projectfloodlight.openflow.protocol.errormsg.OFBadMatchErrorMsg;
import org.projectfloodlight.openflow.protocol.errormsg.OFBadRequestErrorMsg;
import org.projectfloodlight.openflow.protocol.errormsg.OFFlowModFailedErrorMsg;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class OpenFlowRuleProvider
extends AbstractProvider
implements FlowRuleProvider {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowRuleProviderRegistry providerRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenFlowController controller;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DriverService driverService;
    private static final int DEFAULT_POLL_FREQUENCY = 5;
    private static final int MIN_EXPECTED_BYTE_LEN = 56;
    private static final int SKIP_BYTES = 4;
    private static final boolean DEFAULT_ADAPTIVE_FLOW_SAMPLING = false;
    @Property(name="flowPollFrequency", intValue={5}, label="Frequency (in seconds) for polling flow statistics")
    private int flowPollFrequency = 5;
    @Property(name="adaptiveFlowSampling", boolValue={false}, label="Adaptive Flow Sampling is on or off")
    private boolean adaptiveFlowSampling = false;
    private FlowRuleProviderService providerService;
    private final InternalFlowProvider listener = new InternalFlowProvider();
    private Cache<Long, InternalCacheEntry> pendingBatches;
    private final Timer timer = new Timer("onos-openflow-collector");
    private final Map<Dpid, FlowStatsCollector> simpleCollectors = Maps.newConcurrentMap();
    private final Map<Dpid, NewAdaptiveFlowStatsCollector> afsCollectors = Maps.newConcurrentMap();
    private final Map<Dpid, TableStatisticsCollector> tableStatsCollectors = Maps.newConcurrentMap();

    public OpenFlowRuleProvider() {
        super(new ProviderId("of", "org.onosproject.provider.openflow"));
    }

    @Activate
    protected void activate(ComponentContext context) {
        this.cfgService.registerProperties(((Object)((Object)this)).getClass());
        this.providerService = (FlowRuleProviderService)this.providerRegistry.register((Provider)this);
        this.controller.addListener((OpenFlowSwitchListener)this.listener);
        this.controller.addEventListener((OpenFlowEventListener)this.listener);
        this.modified(context);
        this.pendingBatches = this.createBatchCache();
        this.createCollectors();
        this.log.info("Started with flowPollFrequency = {}, adaptiveFlowSampling = {}", (Object)this.flowPollFrequency, (Object)this.adaptiveFlowSampling);
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.cfgService.unregisterProperties(((Object)((Object)this)).getClass(), false);
        this.stopCollectors();
        this.providerRegistry.unregister((Provider)this);
        this.providerService = null;
        this.log.info("Stopped");
    }

    @Modified
    protected void modified(ComponentContext context) {
        boolean newAdaptiveFlowSampling;
        int newFlowPollFrequency;
        Dictionary properties = context.getProperties();
        try {
            String s = Tools.get((Dictionary)properties, (String)"flowPollFrequency");
            newFlowPollFrequency = Strings.isNullOrEmpty((String)s) ? this.flowPollFrequency : Integer.parseInt(s.trim());
        }
        catch (ClassCastException | NumberFormatException e) {
            newFlowPollFrequency = this.flowPollFrequency;
        }
        if (newFlowPollFrequency != this.flowPollFrequency) {
            this.flowPollFrequency = newFlowPollFrequency;
            this.adjustRate();
        }
        this.log.info("Settings: flowPollFrequency={}", (Object)this.flowPollFrequency);
        String s = Tools.get((Dictionary)properties, (String)"adaptiveFlowSampling");
        boolean bl = newAdaptiveFlowSampling = Strings.isNullOrEmpty((String)s) ? this.adaptiveFlowSampling : Boolean.parseBoolean(s.trim());
        if (newAdaptiveFlowSampling != this.adaptiveFlowSampling) {
            this.stopCollectors();
            this.adaptiveFlowSampling = newAdaptiveFlowSampling;
            this.createCollectors();
        }
        this.log.info("Settings: adaptiveFlowSampling={}", (Object)this.adaptiveFlowSampling);
    }

    private Cache<Long, InternalCacheEntry> createBatchCache() {
        return CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).removalListener(notification -> {
            if (notification.getCause() == RemovalCause.EXPIRED) {
                this.providerService.batchOperationCompleted(((Long)notification.getKey()).longValue(), ((InternalCacheEntry)notification.getValue()).failedCompletion());
            }
        }).build();
    }

    private void createCollectors() {
        this.controller.getSwitches().forEach(this::createCollector);
    }

    private void createCollector(OpenFlowSwitch sw) {
        SwitchDataCollector fsc;
        if (sw == null) {
            return;
        }
        if (this.adaptiveFlowSampling) {
            fsc = new NewAdaptiveFlowStatsCollector(this.driverService, sw, this.flowPollFrequency);
            ((NewAdaptiveFlowStatsCollector)fsc).start();
            this.stopCollectorIfNeeded(this.afsCollectors.put(new Dpid(sw.getId()), (NewAdaptiveFlowStatsCollector)fsc));
        } else {
            fsc = new FlowStatsCollector(this.timer, sw, this.flowPollFrequency);
            ((FlowStatsCollector)fsc).start();
            this.stopCollectorIfNeeded(this.simpleCollectors.put(new Dpid(sw.getId()), (FlowStatsCollector)fsc));
        }
        TableStatisticsCollector tsc = new TableStatisticsCollector(this.timer, sw, this.flowPollFrequency);
        tsc.start();
        this.stopCollectorIfNeeded(this.tableStatsCollectors.put(new Dpid(sw.getId()), tsc));
    }

    private void stopCollectorIfNeeded(SwitchDataCollector collector) {
        if (collector != null) {
            collector.stop();
        }
    }

    private void stopCollectors() {
        if (this.adaptiveFlowSampling) {
            this.afsCollectors.values().forEach(NewAdaptiveFlowStatsCollector::stop);
            this.afsCollectors.clear();
        } else {
            this.simpleCollectors.values().forEach(FlowStatsCollector::stop);
            this.simpleCollectors.clear();
        }
        this.tableStatsCollectors.values().forEach(TableStatisticsCollector::stop);
        this.tableStatsCollectors.clear();
    }

    private void adjustRate() {
        DefaultLoad.setPollInterval((long)this.flowPollFrequency);
        if (this.adaptiveFlowSampling) {
            this.afsCollectors.values().forEach(fsc -> fsc.adjustCalAndPollInterval(this.flowPollFrequency));
        } else {
            this.simpleCollectors.values().forEach(fsc -> fsc.adjustPollInterval(this.flowPollFrequency));
        }
        this.tableStatsCollectors.values().forEach(tsc -> tsc.adjustPollInterval(this.flowPollFrequency));
    }

    public void applyFlowRule(FlowRule ... flowRules) {
        for (FlowRule flowRule : flowRules) {
            this.applyRule(flowRule);
        }
    }

    private void applyRule(FlowRule flowRule) {
        Dpid dpid = Dpid.dpid((URI)flowRule.deviceId().uri());
        OpenFlowSwitch sw = this.controller.getSwitch(dpid);
        if (sw == null) {
            return;
        }
        FlowRuleExtPayLoad flowRuleExtPayLoad = flowRule.payLoad();
        if (this.hasPayload(flowRuleExtPayLoad)) {
            ThirdPartyMessage msg = new ThirdPartyMessage(flowRuleExtPayLoad.payLoad());
            sw.sendMsg((OFMessage)msg);
            return;
        }
        sw.sendMsg((OFMessage)FlowModBuilder.builder(flowRule, sw.factory(), Optional.empty(), Optional.of(this.driverService)).buildFlowAdd());
    }

    public void removeFlowRule(FlowRule ... flowRules) {
        for (FlowRule flowRule : flowRules) {
            this.removeRule(flowRule);
        }
    }

    private void removeRule(FlowRule flowRule) {
        Dpid dpid = Dpid.dpid((URI)flowRule.deviceId().uri());
        OpenFlowSwitch sw = this.controller.getSwitch(dpid);
        if (sw == null) {
            return;
        }
        FlowRuleExtPayLoad flowRuleExtPayLoad = flowRule.payLoad();
        if (this.hasPayload(flowRuleExtPayLoad)) {
            ThirdPartyMessage msg = new ThirdPartyMessage(flowRuleExtPayLoad.payLoad());
            sw.sendMsg((OFMessage)msg);
            return;
        }
        sw.sendMsg((OFMessage)FlowModBuilder.builder(flowRule, sw.factory(), Optional.empty(), Optional.of(this.driverService)).buildFlowDel());
    }

    public void removeRulesById(ApplicationId id, FlowRule ... flowRules) {
        this.removeFlowRule(flowRules);
    }

    public void executeBatch(FlowRuleBatchOperation batch) {
        Preconditions.checkNotNull((Object)batch);
        Dpid dpid = Dpid.dpid((URI)batch.deviceId().uri());
        OpenFlowSwitch sw = this.controller.getSwitch(dpid);
        if (sw == null) {
            ImmutableSet failures = ImmutableSet.copyOf((Collection)Lists.transform((List)batch.getOperations(), e -> (FlowRule)e.target()));
            this.providerService.batchOperationCompleted(batch.id(), new CompletedBatchOperation(false, (Set)failures, batch.deviceId()));
            return;
        }
        this.pendingBatches.put((Object)batch.id(), (Object)new InternalCacheEntry(batch));
        block5: for (FlowRuleBatchEntry fbe : batch.getOperations()) {
            OFFlowMod mod;
            FlowRuleExtPayLoad flowRuleExtPayLoad = ((FlowRule)fbe.target()).payLoad();
            if (this.hasPayload(flowRuleExtPayLoad)) {
                ThirdPartyMessage msg = new ThirdPartyMessage(flowRuleExtPayLoad.payLoad());
                sw.sendMsg((OFMessage)msg);
                continue;
            }
            FlowModBuilder builder = FlowModBuilder.builder((FlowRule)fbe.target(), sw.factory(), Optional.of(batch.id()), Optional.of(this.driverService));
            NewAdaptiveFlowStatsCollector collector = this.afsCollectors.get(dpid);
            switch ((FlowRuleBatchEntry.FlowRuleOperation)fbe.operator()) {
                case ADD: {
                    mod = builder.buildFlowAdd();
                    break;
                }
                case REMOVE: {
                    mod = builder.buildFlowDel();
                    break;
                }
                case MODIFY: {
                    mod = builder.buildFlowMod();
                    break;
                }
                default: {
                    this.log.error("Unsupported batch operation {}; skipping flowmod {}", (Object)fbe.operator(), (Object)fbe);
                    continue block5;
                }
            }
            sw.sendMsg((OFMessage)mod);
        }
        OFBarrierRequest.Builder builder = sw.factory().buildBarrierRequest().setXid(batch.id());
        sw.sendMsg((OFMessage)builder.build());
    }

    private boolean hasPayload(FlowRuleExtPayLoad flowRuleExtPayLoad) {
        return flowRuleExtPayLoad != null && flowRuleExtPayLoad.payLoad() != null && flowRuleExtPayLoad.payLoad().length > 0;
    }

    protected void bindProviderRegistry(FlowRuleProviderRegistry flowRuleProviderRegistry) {
        this.providerRegistry = flowRuleProviderRegistry;
    }

    protected void unbindProviderRegistry(FlowRuleProviderRegistry flowRuleProviderRegistry) {
        if (this.providerRegistry == flowRuleProviderRegistry) {
            this.providerRegistry = null;
        }
    }

    protected void bindController(OpenFlowController openFlowController) {
        this.controller = openFlowController;
    }

    protected void unbindController(OpenFlowController openFlowController) {
        if (this.controller == openFlowController) {
            this.controller = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }

    protected void bindDriverService(DriverService driverService) {
        this.driverService = driverService;
    }

    protected void unbindDriverService(DriverService driverService) {
        if (this.driverService == driverService) {
            this.driverService = null;
        }
    }

    private class InternalCacheEntry {
        private final FlowRuleBatchOperation operation;
        private final Set<FlowRule> failures = Sets.newConcurrentHashSet();

        public InternalCacheEntry(FlowRuleBatchOperation operation) {
            this.operation = operation;
        }

        public void appendFailure(FlowRule rule) {
            this.failures.add(rule);
        }

        public CompletedBatchOperation failedCompletion() {
            Set fails = this.operation.getOperations().stream().map(op -> (FlowRule)op.target()).collect(Collectors.toSet());
            return new CompletedBatchOperation(false, Collections.unmodifiableSet(fails), this.operation.deviceId());
        }

        public CompletedBatchOperation completed() {
            return new CompletedBatchOperation(this.failures.isEmpty(), Collections.unmodifiableSet(this.failures), this.operation.deviceId());
        }
    }

    private class InternalFlowProvider
    implements OpenFlowSwitchListener,
    OpenFlowEventListener {
        private InternalFlowProvider() {
        }

        public void switchAdded(Dpid dpid) {
            OpenFlowRuleProvider.this.createCollector(OpenFlowRuleProvider.this.controller.getSwitch(dpid));
        }

        public void switchRemoved(Dpid dpid) {
            if (OpenFlowRuleProvider.this.adaptiveFlowSampling) {
                OpenFlowRuleProvider.this.stopCollectorIfNeeded((SwitchDataCollector)OpenFlowRuleProvider.this.afsCollectors.remove(dpid));
            } else {
                OpenFlowRuleProvider.this.stopCollectorIfNeeded((SwitchDataCollector)OpenFlowRuleProvider.this.simpleCollectors.remove(dpid));
            }
            OpenFlowRuleProvider.this.stopCollectorIfNeeded((SwitchDataCollector)OpenFlowRuleProvider.this.tableStatsCollectors.remove(dpid));
        }

        public void switchChanged(Dpid dpid) {
        }

        public void portChanged(Dpid dpid, OFPortStatus status) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Dpid dpid, OFMessage msg) {
            if (OpenFlowRuleProvider.this.providerService == null) {
                return;
            }
            DeviceId deviceId = DeviceId.deviceId((URI)Dpid.uri((Dpid)dpid));
            switch (msg.getType()) {
                case FLOW_REMOVED: {
                    OFFlowRemoved removed = (OFFlowRemoved)msg;
                    FlowEntry fr = new FlowEntryBuilder(deviceId, removed, OpenFlowRuleProvider.this.driverService).build(new FlowEntry.FlowEntryState[0]);
                    OpenFlowRuleProvider.this.providerService.flowRemoved(fr);
                    break;
                }
                case STATS_REPLY: {
                    if (((OFStatsReply)msg).getStatsType() == OFStatsType.FLOW) {
                        this.pushFlowMetrics(dpid, (OFFlowStatsReply)msg);
                        break;
                    }
                    if (((OFStatsReply)msg).getStatsType() != OFStatsType.TABLE) break;
                    this.pushTableStatistics(dpid, (OFTableStatsReply)msg);
                    break;
                }
                case BARRIER_REPLY: {
                    try {
                        InternalCacheEntry entry = (InternalCacheEntry)OpenFlowRuleProvider.this.pendingBatches.getIfPresent((Object)msg.getXid());
                        if (entry != null) {
                            OpenFlowRuleProvider.this.providerService.batchOperationCompleted(msg.getXid(), entry.completed());
                            break;
                        }
                        OpenFlowRuleProvider.this.log.warn("Received unknown Barrier Reply: {}", (Object)msg.getXid());
                        break;
                    }
                    finally {
                        OpenFlowRuleProvider.this.pendingBatches.invalidate((Object)msg.getXid());
                    }
                }
                case ERROR: {
                    if (msg instanceof OFBadRequestErrorMsg && ((OFBadRequestErrorMsg)msg).getCode() == OFBadRequestCode.BAD_TYPE) {
                        OpenFlowRuleProvider.this.log.debug("Received error message {} from {}", (Object)msg, (Object)dpid);
                    } else {
                        OpenFlowRuleProvider.this.log.warn("Received error message {} from {}", (Object)msg, (Object)dpid);
                    }
                    this.handleErrorMsg(deviceId, msg);
                    break;
                }
                default: {
                    OpenFlowRuleProvider.this.log.debug("Unhandled message type: {}", (Object)msg.getType());
                }
            }
        }

        private void handleErrorMsg(DeviceId deviceId, OFMessage msg) {
            InternalCacheEntry entry = (InternalCacheEntry)OpenFlowRuleProvider.this.pendingBatches.getIfPresent((Object)msg.getXid());
            OFErrorMsg error = (OFErrorMsg)msg;
            OFMessage ofMessage = null;
            switch (error.getErrType()) {
                case BAD_ACTION: {
                    OFBadActionErrorMsg baErrorMsg = (OFBadActionErrorMsg)error;
                    if (!baErrorMsg.getData().getParsedMessage().isPresent()) break;
                    ofMessage = (OFMessage)baErrorMsg.getData().getParsedMessage().get();
                    break;
                }
                case BAD_INSTRUCTION: {
                    OFBadInstructionErrorMsg biErrorMsg = (OFBadInstructionErrorMsg)error;
                    if (!biErrorMsg.getData().getParsedMessage().isPresent()) break;
                    ofMessage = (OFMessage)biErrorMsg.getData().getParsedMessage().get();
                    break;
                }
                case BAD_MATCH: {
                    OFBadMatchErrorMsg bmErrorMsg = (OFBadMatchErrorMsg)error;
                    if (!bmErrorMsg.getData().getParsedMessage().isPresent()) break;
                    ofMessage = (OFMessage)bmErrorMsg.getData().getParsedMessage().get();
                    break;
                }
                case FLOW_MOD_FAILED: {
                    OFFlowModFailedErrorMsg fmFailed = (OFFlowModFailedErrorMsg)error;
                    if (!fmFailed.getData().getParsedMessage().isPresent()) break;
                    ofMessage = (OFMessage)fmFailed.getData().getParsedMessage().get();
                    break;
                }
                default: {
                    return;
                }
            }
            if (ofMessage != null) {
                if (entry != null) {
                    OFFlowMod ofFlowMod = (OFFlowMod)ofMessage;
                    entry.appendFailure((FlowRule)new FlowEntryBuilder(deviceId, ofFlowMod, OpenFlowRuleProvider.this.driverService).build(new FlowEntry.FlowEntryState[0]));
                } else {
                    OpenFlowRuleProvider.this.log.error("No matching batch for this error: {}", (Object)error);
                }
            } else {
                U64 cookieId = this.readCookieIdFromOFErrorMsg(error, msg.getVersion());
                if (cookieId != null) {
                    long flowId = cookieId.getValue();
                    if (entry != null) {
                        for (FlowRuleBatchEntry fbEntry : entry.operation.getOperations()) {
                            if (((FlowRule)fbEntry.target()).id().value() != flowId) continue;
                            entry.appendFailure((FlowRule)fbEntry.target());
                            break;
                        }
                    } else {
                        OpenFlowRuleProvider.this.log.error("No matching batch for this error: {}", (Object)error);
                    }
                } else {
                    OpenFlowRuleProvider.this.log.error("Flow installation failed but switch didn't tell us which one.");
                }
            }
        }

        private U64 readCookieIdFromOFErrorMsg(OFErrorMsg msg, OFVersion ofVersion) {
            if (ofVersion.wireVersion < OFVersion.OF_13.wireVersion) {
                OpenFlowRuleProvider.this.log.debug("Unhandled error msg with OF version {} which is less than {}", (Object)ofVersion, (Object)OFVersion.OF_13);
                return null;
            }
            ChannelBuffer bb = ChannelBuffers.wrappedBuffer((byte[])msg.getData().getData());
            if (bb.readableBytes() < 56) {
                OpenFlowRuleProvider.this.log.debug("Wrong length: Expected to be >= {}, was: {}", (Object)56, (Object)bb.readableBytes());
                return null;
            }
            byte ofVer = bb.readByte();
            if (ofVer != ofVersion.wireVersion) {
                OpenFlowRuleProvider.this.log.debug("Wrong version: Expected={}, got={}", (Object)ofVersion.wireVersion, (Object)ofVer);
                return null;
            }
            byte type = bb.readByte();
            if (type != OFType.FLOW_MOD.ordinal()) {
                OpenFlowRuleProvider.this.log.debug("Wrong type: Expected={}, got={}", (Object)OFType.FLOW_MOD.ordinal(), (Object)type);
                return null;
            }
            int length = U16.f((short)bb.readShort());
            if (length < 56) {
                OpenFlowRuleProvider.this.log.debug("Wrong length: Expected to be >= {}, was: {}", (Object)56, (Object)length);
                return null;
            }
            bb.skipBytes(4);
            return U64.ofRaw((long)bb.readLong());
        }

        public void receivedRoleReply(Dpid dpid, RoleState requested, RoleState response) {
        }

        private void pushFlowMetrics(Dpid dpid, OFFlowStatsReply replies) {
            DeviceId did = DeviceId.deviceId((URI)Dpid.uri((Dpid)dpid));
            NewAdaptiveFlowStatsCollector afsc = (NewAdaptiveFlowStatsCollector)OpenFlowRuleProvider.this.afsCollectors.get(dpid);
            if (OpenFlowRuleProvider.this.adaptiveFlowSampling && afsc != null) {
                List flowEntries = replies.getEntries().stream().map(entry -> new FlowEntryBuilder(did, (OFFlowStatsEntry)entry, OpenFlowRuleProvider.this.driverService).withSetAfsc(afsc).build(new FlowEntry.FlowEntryState[0])).collect(Collectors.toList());
                if (afsc.getFlowMissingXid() != -1L) {
                    OpenFlowRuleProvider.this.log.debug("OpenFlowRuleProvider:pushFlowMetrics, flowMissingXid={}, OFFlowStatsReply Xid={}, for {}", new Object[]{afsc.getFlowMissingXid(), replies.getXid(), dpid});
                    if (afsc.getFlowMissingXid() == replies.getXid()) {
                        OpenFlowRuleProvider.this.providerService.pushFlowMetrics(did, flowEntries);
                    }
                    afsc.setFlowMissingXid(-1L);
                } else {
                    OpenFlowRuleProvider.this.providerService.pushFlowMetricsWithoutFlowMissing(did, flowEntries);
                }
            } else {
                List flowEntries = replies.getEntries().stream().map(entry -> new FlowEntryBuilder(did, (OFFlowStatsEntry)entry, OpenFlowRuleProvider.this.driverService).build(new FlowEntry.FlowEntryState[0])).collect(Collectors.toList());
                OpenFlowRuleProvider.this.providerService.pushFlowMetrics(did, flowEntries);
            }
        }

        private void pushTableStatistics(Dpid dpid, OFTableStatsReply replies) {
            DeviceId did = DeviceId.deviceId((URI)Dpid.uri((Dpid)dpid));
            List tableStatsEntries = replies.getEntries().stream().map(entry -> this.buildTableStatistics(did, (OFTableStatsEntry)entry)).filter(Objects::nonNull).collect(Collectors.toList());
            OpenFlowRuleProvider.this.providerService.pushTableStatistics(did, tableStatsEntries);
        }

        private TableStatisticsEntry buildTableStatistics(DeviceId deviceId, OFTableStatsEntry ofEntry) {
            DefaultTableStatisticsEntry entry = null;
            if (ofEntry != null) {
                entry = new DefaultTableStatisticsEntry(deviceId, (int)ofEntry.getTableId().getValue(), ofEntry.getActiveCount(), ofEntry.getLookupCount().getValue(), ofEntry.getMatchedCount().getValue());
            }
            return entry;
        }
    }
}

