/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.flow.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onlab.util.Tools;
import org.onosproject.net.DeviceId;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.StoredFlowEntry;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.statistic.DefaultLoad;
import org.onosproject.net.statistic.PollInterval;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.onosproject.openflow.controller.RoleState;
import org.onosproject.provider.of.flow.impl.FlowModBuilder;
import org.onosproject.provider.of.flow.impl.SwitchDataCollector;
import org.projectfloodlight.openflow.protocol.OFFlowStatsRequest;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.TableId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewAdaptiveFlowStatsCollector
implements SwitchDataCollector {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String CHECK_AND_MOVE_LOG = "checkAndMoveLiveFlowInternal: flowId={}, state={}, afterLiveType={}, liveTime={}, life={}, bytes={}, packets={}, fromLastSeen={}, priority={}, selector={}, treatment={} dpid={}";
    private static final String CHECK_AND_MOVE_COUNT_LOG = "checkAndMoveLiveFlowAll: Total Flow_Count={}, , IMMEDIATE_FLOW_Count={}, SHORT_FLOW_Count={}, MID_FLOW_Count={}, LONG_FLOW_Count={}, UNKNOWN_FLOW_Count={}";
    private static final int SLEEP_LOOP_COUNT = 10;
    private static final int SLEEP_MS = 100;
    private final DriverService driverService;
    private final OpenFlowSwitch sw;
    private final DeviceId did;
    private ScheduledExecutorService adaptiveFlowStatsScheduler = Executors.newScheduledThreadPool(4, Tools.groupedThreads((String)"onos/flow", (String)"device-stats-collector-%d", (Logger)this.log));
    private ScheduledFuture<?> calAndShortFlowsThread;
    private ScheduledFuture<?> midFlowsThread;
    private ScheduledFuture<?> longFlowsThread;
    private CalAndShortFlowsTask calAndShortFlowsTask;
    private MidFlowsTask midFlowsTask;
    private LongFlowsTask longFlowsTask;
    private static final int CAL_AND_POLL_TIMES = 1;
    private static final int MID_POLL_TIMES = 2;
    private static final int LONG_POLL_TIMES = 3;
    private static final int ENTIRE_POLL_TIMES = 6;
    private static final int DEFAULT_CAL_AND_POLL_FREQUENCY = 5;
    private static final int MIN_CAL_AND_POLL_FREQUENCY = 2;
    private static final int MAX_CAL_AND_POLL_FREQUENCY = 60;
    private int calAndPollInterval;
    private int midPollInterval;
    private int longPollInterval;
    private int entirePollInterval;
    private int callCountCalAndShortFlowsTask = 0;
    private int callCountMidFlowsTask = 0;
    private int callCountLongFlowsTask = 0;
    private boolean isFirstTimeStart = true;
    public static final long NO_FLOW_MISSING_XID = -1L;
    private long flowMissingXid = -1L;
    private FlowRuleService flowRuleService;

    NewAdaptiveFlowStatsCollector(DriverService driverService, OpenFlowSwitch sw, int pollInterval) {
        this.driverService = driverService;
        this.sw = sw;
        this.did = DeviceId.deviceId((URI)Dpid.uri((long)sw.getId()));
        this.flowRuleService = NewAdaptiveFlowStatsCollector.get(FlowRuleService.class);
        this.initMemberVars(pollInterval);
    }

    private static <T> T get(Class<T> serviceClass) {
        return (T)DefaultServiceDirectory.getService(serviceClass);
    }

    private void initMemberVars(int pollInterval) {
        this.calAndPollInterval = pollInterval < 2 ? 2 : (pollInterval >= 60 ? 60 : pollInterval);
        this.calAndPollInterval = 1 * this.calAndPollInterval;
        this.midPollInterval = 2 * this.calAndPollInterval;
        this.longPollInterval = 3 * this.calAndPollInterval;
        this.entirePollInterval = 6 * this.calAndPollInterval;
        DefaultLoad.setPollInterval((long)this.calAndPollInterval);
        PollInterval pollInterval1Instance = PollInterval.getInstance();
        pollInterval1Instance.setPollInterval((long)this.calAndPollInterval);
        pollInterval1Instance.setMidPollInterval((long)this.midPollInterval);
        pollInterval1Instance.setLongPollInterval((long)this.longPollInterval);
        pollInterval1Instance.setEntirePollInterval((long)this.entirePollInterval);
        this.callCountCalAndShortFlowsTask = 0;
        this.callCountMidFlowsTask = 0;
        this.callCountLongFlowsTask = 0;
        this.flowMissingXid = -1L;
    }

    synchronized void adjustCalAndPollInterval(int pollInterval) {
        this.initMemberVars(pollInterval);
        if (this.calAndShortFlowsThread != null) {
            this.calAndShortFlowsThread.cancel(false);
        }
        if (this.midFlowsThread != null) {
            this.midFlowsThread.cancel(false);
        }
        if (this.longFlowsThread != null) {
            this.longFlowsThread.cancel(false);
        }
        this.calAndShortFlowsTask = new CalAndShortFlowsTask();
        this.calAndShortFlowsThread = this.adaptiveFlowStatsScheduler.scheduleWithFixedDelay(this.calAndShortFlowsTask, 0L, this.calAndPollInterval, TimeUnit.SECONDS);
        this.midFlowsTask = new MidFlowsTask();
        this.midFlowsThread = this.adaptiveFlowStatsScheduler.scheduleWithFixedDelay(this.midFlowsTask, 0L, this.midPollInterval, TimeUnit.SECONDS);
        this.longFlowsTask = new LongFlowsTask();
        this.longFlowsThread = this.adaptiveFlowStatsScheduler.scheduleWithFixedDelay(this.longFlowsTask, 0L, this.longPollInterval, TimeUnit.SECONDS);
        this.log.debug("calAndPollInterval={} is adjusted", (Object)this.calAndPollInterval);
    }

    private synchronized void ofFlowStatsRequestAllSend() {
        OFFlowStatsRequest request = this.sw.factory().buildFlowStatsRequest().setMatch(this.sw.factory().matchWildcardAll()).setTableId(TableId.ALL).setOutPort(OFPort.NO_MASK).build();
        this.setFlowMissingXid(request.getXid());
        this.log.debug("ofFlowStatsRequestAllSend: request={}, dpid={}", (Object)request.toString(), (Object)this.sw.getStringId());
        this.sw.sendMsg((OFMessage)request);
    }

    private void ofFlowStatsRequestFlowSend(FlowEntry fe) {
        Match match = FlowModBuilder.builder((FlowRule)fe, this.sw.factory(), Optional.empty(), Optional.of(this.driverService)).buildMatch();
        TableId tableId = TableId.of((int)fe.tableId());
        Instruction ins = fe.treatment().allInstructions().stream().filter(i -> i.type() == Instruction.Type.OUTPUT).findFirst().orElse(null);
        OFPort ofPort = OFPort.NO_MASK;
        if (ins != null) {
            Instructions.OutputInstruction out = (Instructions.OutputInstruction)ins;
            ofPort = OFPort.of((int)((int)out.port().toLong()));
        }
        OFFlowStatsRequest request = this.sw.factory().buildFlowStatsRequest().setMatch(match).setTableId(tableId).setOutPort(ofPort).build();
        int loop = 0;
        boolean interrupted = false;
        while (!interrupted && this.getFlowMissingXid() != -1L) {
            if (loop++ < 10) {
                this.log.debug("ofFlowStatsRequestFlowSend: previous FlowStatsRequestAll (xid={}) does not be processed yet, do sleep for {} ms, for {}", new Object[]{this.getFlowMissingXid(), 100, this.sw.getStringId()});
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    this.log.debug("ofFlowStatsRequestFlowSend: Interrupted Exception = {}, for {}", (Object)ie.toString(), (Object)this.sw.getStringId());
                    interrupted = true;
                }
                continue;
            }
            this.log.debug("ofFlowStatsRequestFlowSend: previous FlowStatsRequestAll (xid={}) does not be processed yet, for {} ms, just set xid with NO_FLOW_MISSING_XID, for {}", new Object[]{this.getFlowMissingXid(), loop * 100, this.sw.getStringId()});
            this.setFlowMissingXid(-1L);
            break;
        }
        this.sw.sendMsg((OFMessage)request);
    }

    private void calAndShortFlowsTaskInternal() {
        this.checkAndMoveLiveFlowAll();
        this.ofFlowStatsRequestInternal(FlowEntry.FlowLiveType.SHORT);
    }

    private void ofFlowStatsRequestInternal(FlowEntry.FlowLiveType liveType) {
        Iterable flowEntries = this.flowRuleService.getFlowEntriesByLiveType(this.did, liveType);
        flowEntries.forEach(fe -> this.ofFlowStatsRequestFlowSend((FlowEntry)fe));
    }

    private void midFlowsTaskInternal() {
        this.ofFlowStatsRequestInternal(FlowEntry.FlowLiveType.MID);
    }

    private void longFlowsTaskInternal() {
        this.ofFlowStatsRequestInternal(FlowEntry.FlowLiveType.LONG);
    }

    @Override
    public synchronized void start() {
        this.log.debug("Starting AdaptiveStats collection thread for {}", (Object)this.sw.getStringId());
        this.callCountCalAndShortFlowsTask = 0;
        this.callCountMidFlowsTask = 0;
        this.callCountLongFlowsTask = 0;
        this.isFirstTimeStart = true;
        this.calAndShortFlowsTask = new CalAndShortFlowsTask();
        this.calAndShortFlowsThread = this.adaptiveFlowStatsScheduler.scheduleWithFixedDelay(this.calAndShortFlowsTask, 1L, this.calAndPollInterval, TimeUnit.SECONDS);
        this.midFlowsTask = new MidFlowsTask();
        this.midFlowsThread = this.adaptiveFlowStatsScheduler.scheduleWithFixedDelay(this.midFlowsTask, 1L, this.midPollInterval, TimeUnit.SECONDS);
        this.longFlowsTask = new LongFlowsTask();
        this.longFlowsThread = this.adaptiveFlowStatsScheduler.scheduleWithFixedDelay(this.longFlowsTask, 1L, this.longPollInterval, TimeUnit.SECONDS);
        this.log.info("Started");
    }

    @Override
    public synchronized void stop() {
        this.log.debug("Stopping AdaptiveStats collection thread for {}", (Object)this.sw.getStringId());
        if (this.calAndShortFlowsThread != null) {
            this.calAndShortFlowsThread.cancel(true);
        }
        if (this.midFlowsThread != null) {
            this.midFlowsThread.cancel(true);
        }
        if (this.longFlowsThread != null) {
            this.longFlowsThread.cancel(true);
        }
        this.adaptiveFlowStatsScheduler.shutdownNow();
        this.isFirstTimeStart = false;
        this.log.info("Stopped");
    }

    public long getFlowMissingXid() {
        return this.flowMissingXid;
    }

    public void setFlowMissingXid(long flowMissingXid) {
        this.flowMissingXid = flowMissingXid;
    }

    public FlowEntry.FlowLiveType calFlowLiveType(long life) {
        if (life < 0L) {
            return FlowEntry.FlowLiveType.UNKNOWN;
        }
        if (life < (long)this.calAndPollInterval) {
            return FlowEntry.FlowLiveType.IMMEDIATE;
        }
        if (life < (long)this.midPollInterval) {
            return FlowEntry.FlowLiveType.SHORT;
        }
        if (life < (long)this.longPollInterval) {
            return FlowEntry.FlowLiveType.MID;
        }
        return FlowEntry.FlowLiveType.LONG;
    }

    public FlowEntry.FlowLiveType calAndSetFlowLiveType(StoredFlowEntry fe) {
        Preconditions.checkNotNull((Object)fe);
        long life = fe.life();
        if (life < 0L) {
            fe.setLiveType(FlowEntry.FlowLiveType.UNKNOWN);
        } else if (life < (long)this.calAndPollInterval) {
            fe.setLiveType(FlowEntry.FlowLiveType.IMMEDIATE);
        } else if (life < (long)this.midPollInterval) {
            fe.setLiveType(FlowEntry.FlowLiveType.SHORT);
        } else if (life < (long)this.longPollInterval) {
            fe.setLiveType(FlowEntry.FlowLiveType.MID);
        } else {
            fe.setLiveType(FlowEntry.FlowLiveType.LONG);
        }
        return fe.liveType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndMoveLiveFlowAll() {
        Iterable flowEntries = this.flowRuleService.getFlowEntries(this.did);
        flowEntries.forEach(fe -> this.checkAndMoveLiveFlowInternal((StoredFlowEntry)fe));
        if (this.log.isDebugEnabled()) {
            NewAdaptiveFlowStatsCollector newAdaptiveFlowStatsCollector = this;
            synchronized (newAdaptiveFlowStatsCollector) {
                long totalFlowCount = this.flowRuleService.getFlowRuleCount();
                Iterable fes = this.flowRuleService.getFlowEntriesByLiveType(this.did, FlowEntry.FlowLiveType.IMMEDIATE);
                long immediateFlowCount = Iterables.size((Iterable)fes);
                fes = this.flowRuleService.getFlowEntriesByLiveType(this.did, FlowEntry.FlowLiveType.SHORT);
                long shortFlowCount = Iterables.size((Iterable)fes);
                fes = this.flowRuleService.getFlowEntriesByLiveType(this.did, FlowEntry.FlowLiveType.MID);
                long midFlowCount = Iterables.size((Iterable)fes);
                fes = this.flowRuleService.getFlowEntriesByLiveType(this.did, FlowEntry.FlowLiveType.LONG);
                long longFlowCount = Iterables.size((Iterable)fes);
                fes = this.flowRuleService.getFlowEntriesByLiveType(this.did, FlowEntry.FlowLiveType.UNKNOWN);
                long unknownFlowCount = Iterables.size((Iterable)fes);
                this.log.trace(CHECK_AND_MOVE_COUNT_LOG, new Object[]{totalFlowCount, immediateFlowCount, shortFlowCount, midFlowCount, longFlowCount, unknownFlowCount});
                if (immediateFlowCount < 0L) {
                    this.log.error("Immediate flow count is negative");
                }
            }
        }
        this.log.trace("checkAndMoveLiveFlowAll, AdaptiveStats for {}", (Object)this.sw.getStringId());
    }

    private boolean checkAndMoveLiveFlowInternal(StoredFlowEntry fe) {
        long fromLastSeen = (System.currentTimeMillis() - fe.lastSeen()) / 1000L;
        long liveTime = fe.life() + fromLastSeen;
        FlowEntry.FlowLiveType oldLiveType = fe.liveType();
        switch (fe.liveType()) {
            case IMMEDIATE: {
                if (liveTime < (long)this.calAndPollInterval) break;
                fe.setLiveType(FlowEntry.FlowLiveType.SHORT);
                break;
            }
            case SHORT: {
                if (liveTime < (long)this.midPollInterval) break;
                fe.setLiveType(FlowEntry.FlowLiveType.MID);
                break;
            }
            case MID: {
                if (liveTime < (long)this.longPollInterval) break;
                fe.setLiveType(FlowEntry.FlowLiveType.LONG);
                break;
            }
            case LONG: {
                if (fromLastSeen <= (long)this.entirePollInterval) break;
                this.log.trace("checkAndMoveLiveFlowInternal, flow may be already removed at switch.");
                return false;
            }
            case UNKNOWN: {
                this.calAndSetFlowLiveType(fe);
                break;
            }
            default: {
                this.log.error("checkAndMoveLiveFlowInternal, Unknown Live Type error! AdaptiveStats collection thread for {}", (Object)this.sw.getStringId());
                return false;
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(CHECK_AND_MOVE_LOG, new Object[]{fe.id(), fe.state(), fe.liveType(), liveTime, fe.life(), fe.bytes(), fe.packets(), fromLastSeen, fe.priority(), fe.selector().criteria(), fe.treatment(), this.sw.getStringId()});
        }
        return true;
    }

    private class LongFlowsTask
    implements Runnable {
        private LongFlowsTask() {
        }

        @Override
        public void run() {
            if (NewAdaptiveFlowStatsCollector.this.sw.getRole() == RoleState.MASTER) {
                NewAdaptiveFlowStatsCollector.this.log.trace("LongFlowsTask Collecting AdaptiveStats for {}", (Object)NewAdaptiveFlowStatsCollector.this.sw.getStringId());
                if (NewAdaptiveFlowStatsCollector.this.callCountLongFlowsTask == 6) {
                    NewAdaptiveFlowStatsCollector.this.callCountLongFlowsTask = 3;
                } else {
                    NewAdaptiveFlowStatsCollector.this.longFlowsTaskInternal();
                    NewAdaptiveFlowStatsCollector.this.callCountLongFlowsTask = NewAdaptiveFlowStatsCollector.this.callCountLongFlowsTask + 3;
                }
            }
        }
    }

    private class MidFlowsTask
    implements Runnable {
        private MidFlowsTask() {
        }

        @Override
        public void run() {
            if (NewAdaptiveFlowStatsCollector.this.sw.getRole() == RoleState.MASTER) {
                NewAdaptiveFlowStatsCollector.this.log.trace("MidFlowsTask Collecting AdaptiveStats for {}", (Object)NewAdaptiveFlowStatsCollector.this.sw.getStringId());
                if (NewAdaptiveFlowStatsCollector.this.callCountMidFlowsTask == 6) {
                    NewAdaptiveFlowStatsCollector.this.callCountMidFlowsTask = 2;
                } else {
                    NewAdaptiveFlowStatsCollector.this.midFlowsTaskInternal();
                    NewAdaptiveFlowStatsCollector.this.callCountMidFlowsTask = NewAdaptiveFlowStatsCollector.this.callCountMidFlowsTask + 2;
                }
            }
        }
    }

    private class CalAndShortFlowsTask
    implements Runnable {
        private CalAndShortFlowsTask() {
        }

        @Override
        public void run() {
            if (NewAdaptiveFlowStatsCollector.this.sw.getRole() == RoleState.MASTER) {
                NewAdaptiveFlowStatsCollector.this.log.trace("CalAndShortFlowsTask Collecting AdaptiveStats for {}", (Object)NewAdaptiveFlowStatsCollector.this.sw.getStringId());
                if (NewAdaptiveFlowStatsCollector.this.isFirstTimeStart) {
                    NewAdaptiveFlowStatsCollector.this.log.trace("CalAndShortFlowsTask Collecting Entire AdaptiveStats at first time start for {}", (Object)NewAdaptiveFlowStatsCollector.this.sw.getStringId());
                    NewAdaptiveFlowStatsCollector.this.ofFlowStatsRequestAllSend();
                    NewAdaptiveFlowStatsCollector.this.callCountCalAndShortFlowsTask = NewAdaptiveFlowStatsCollector.this.callCountCalAndShortFlowsTask + 1;
                    NewAdaptiveFlowStatsCollector.this.isFirstTimeStart = false;
                } else if (NewAdaptiveFlowStatsCollector.this.callCountCalAndShortFlowsTask == 6) {
                    NewAdaptiveFlowStatsCollector.this.log.trace("CalAndShortFlowsTask Collecting Entire AdaptiveStats for {}", (Object)NewAdaptiveFlowStatsCollector.this.sw.getStringId());
                    NewAdaptiveFlowStatsCollector.this.ofFlowStatsRequestAllSend();
                    NewAdaptiveFlowStatsCollector.this.callCountCalAndShortFlowsTask = 1;
                } else {
                    NewAdaptiveFlowStatsCollector.this.calAndShortFlowsTaskInternal();
                    NewAdaptiveFlowStatsCollector.this.callCountCalAndShortFlowsTask = NewAdaptiveFlowStatsCollector.this.callCountCalAndShortFlowsTask + 1;
                }
            }
        }
    }
}

