/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.flow.impl;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.Ip6Address;
import org.onosproject.net.OchSignal;
import org.onosproject.net.OduSignalId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.driver.DefaultDriverData;
import org.onosproject.net.driver.DefaultDriverHandler;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.driver.DriverData;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.instructions.ExtensionTreatment;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flow.instructions.L0ModificationInstruction;
import org.onosproject.net.flow.instructions.L1ModificationInstruction;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flow.instructions.L3ModificationInstruction;
import org.onosproject.net.flow.instructions.L4ModificationInstruction;
import org.onosproject.openflow.controller.ExtensionTreatmentInterpreter;
import org.onosproject.provider.of.flow.impl.FlowModBuilder;
import org.onosproject.provider.of.flow.util.NoMappingFoundException;
import org.onosproject.provider.of.flow.util.OpenFlowValueMapper;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFFlowAdd;
import org.projectfloodlight.openflow.protocol.OFFlowDeleteStrict;
import org.projectfloodlight.openflow.protocol.OFFlowMod;
import org.projectfloodlight.openflow.protocol.OFFlowModFlags;
import org.projectfloodlight.openflow.protocol.OFFlowModify;
import org.projectfloodlight.openflow.protocol.action.OFAction;
import org.projectfloodlight.openflow.protocol.action.OFActionGroup;
import org.projectfloodlight.openflow.protocol.action.OFActionOutput;
import org.projectfloodlight.openflow.protocol.action.OFActionSetQueue;
import org.projectfloodlight.openflow.protocol.instruction.OFInstruction;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionGotoTable;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionWriteMetadata;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmArpSha;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmExpOchSigId;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmExpOduSigId;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmTcpSrc;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmVlanPcp;
import org.projectfloodlight.openflow.types.ArpOpcode;
import org.projectfloodlight.openflow.types.CircuitSignalID;
import org.projectfloodlight.openflow.types.EthType;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.IPv6Address;
import org.projectfloodlight.openflow.types.IPv6FlowLabel;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.OFBooleanValue;
import org.projectfloodlight.openflow.types.OFBufferId;
import org.projectfloodlight.openflow.types.OFGroup;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.OFVlanVidMatch;
import org.projectfloodlight.openflow.types.OduSignalID;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.TransportPort;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.types.VlanPcp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowModBuilderVer13
extends FlowModBuilder {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int OFPCML_NO_BUFFER = 65535;
    private final TrafficTreatment treatment;

    protected FlowModBuilderVer13(FlowRule flowRule, OFFactory factory, Optional<Long> xid, Optional<DriverService> driverService) {
        super(flowRule, factory, xid, driverService);
        this.treatment = flowRule.treatment();
    }

    @Override
    public OFFlowMod buildFlowAdd() {
        Match match = this.buildMatch();
        List<OFAction> deferredActions = this.buildActions(this.treatment.deferred());
        List<OFAction> immediateActions = this.buildActions(this.treatment.immediate());
        LinkedList instructions = Lists.newLinkedList();
        if (this.treatment.clearedDeferred()) {
            instructions.add(this.factory().instructions().clearActions());
        }
        if (!immediateActions.isEmpty()) {
            instructions.add(this.factory().instructions().applyActions(immediateActions));
        }
        if (!deferredActions.isEmpty()) {
            instructions.add(this.factory().instructions().writeActions(deferredActions));
        }
        if (this.treatment.tableTransition() != null) {
            instructions.add(this.buildTableGoto(this.treatment.tableTransition()));
        }
        if (this.treatment.writeMetadata() != null) {
            instructions.add(this.buildMetadata(this.treatment.writeMetadata()));
        }
        if (this.treatment.metered() != null) {
            instructions.add(this.buildMeter(this.treatment.metered()));
        }
        long cookie = this.flowRule().id().value();
        OFFlowAdd fm = this.factory().buildFlowAdd().setXid(this.xid.longValue()).setCookie(U64.of((long)cookie)).setBufferId(OFBufferId.NO_BUFFER).setInstructions((List)instructions).setMatch(match).setFlags(Collections.singleton(OFFlowModFlags.SEND_FLOW_REM)).setPriority(this.flowRule().priority()).setTableId(TableId.of((int)this.flowRule().tableId())).setHardTimeout(this.flowRule().hardTimeout()).build();
        return fm;
    }

    @Override
    public OFFlowMod buildFlowMod() {
        Match match = this.buildMatch();
        List<OFAction> deferredActions = this.buildActions(this.treatment.deferred());
        List<OFAction> immediateActions = this.buildActions(this.treatment.immediate());
        LinkedList instructions = Lists.newLinkedList();
        if (!immediateActions.isEmpty()) {
            instructions.add(this.factory().instructions().applyActions(immediateActions));
        }
        if (this.treatment.clearedDeferred()) {
            instructions.add(this.factory().instructions().clearActions());
        }
        if (!deferredActions.isEmpty()) {
            instructions.add(this.factory().instructions().writeActions(deferredActions));
        }
        if (this.treatment.tableTransition() != null) {
            instructions.add(this.buildTableGoto(this.treatment.tableTransition()));
        }
        if (this.treatment.writeMetadata() != null) {
            instructions.add(this.buildMetadata(this.treatment.writeMetadata()));
        }
        if (this.treatment.metered() != null) {
            instructions.add(this.buildMeter(this.treatment.metered()));
        }
        long cookie = this.flowRule().id().value();
        OFFlowModify fm = this.factory().buildFlowModify().setXid(this.xid.longValue()).setCookie(U64.of((long)cookie)).setBufferId(OFBufferId.NO_BUFFER).setInstructions((List)instructions).setMatch(match).setFlags(Collections.singleton(OFFlowModFlags.SEND_FLOW_REM)).setPriority(this.flowRule().priority()).setTableId(TableId.of((int)this.flowRule().tableId())).setHardTimeout(this.flowRule().hardTimeout()).build();
        return fm;
    }

    @Override
    public OFFlowMod buildFlowDel() {
        Match match = this.buildMatch();
        long cookie = this.flowRule().id().value();
        OFFlowDeleteStrict fm = this.factory().buildFlowDeleteStrict().setXid(this.xid.longValue()).setCookie(U64.of((long)cookie)).setBufferId(OFBufferId.NO_BUFFER).setMatch(match).setFlags(Collections.singleton(OFFlowModFlags.SEND_FLOW_REM)).setPriority(this.flowRule().priority()).setTableId(TableId.of((int)this.flowRule().tableId())).setHardTimeout(this.flowRule().hardTimeout()).build();
        return fm;
    }

    private List<OFAction> buildActions(List<Instruction> treatments) {
        if (this.treatment == null) {
            return Collections.emptyList();
        }
        boolean tableFound = false;
        LinkedList<OFAction> actions = new LinkedList<OFAction>();
        block13: for (Instruction i : treatments) {
            switch (i.type()) {
                case NOACTION: {
                    return Collections.emptyList();
                }
                case L0MODIFICATION: {
                    actions.add(this.buildL0Modification(i));
                    continue block13;
                }
                case L1MODIFICATION: {
                    actions.add(this.buildL1Modification(i));
                    continue block13;
                }
                case L2MODIFICATION: {
                    actions.add(this.buildL2Modification(i));
                    continue block13;
                }
                case L3MODIFICATION: {
                    actions.add(this.buildL3Modification(i));
                    continue block13;
                }
                case L4MODIFICATION: {
                    actions.add(this.buildL4Modification(i));
                    continue block13;
                }
                case OUTPUT: {
                    Instructions.OutputInstruction out = (Instructions.OutputInstruction)i;
                    OFActionOutput.Builder action = this.factory().actions().buildOutput().setPort(OFPort.of((int)((int)out.port().toLong())));
                    if (out.port().equals((Object)PortNumber.CONTROLLER)) {
                        action.setMaxLen(65535);
                    }
                    actions.add((OFAction)action.build());
                    continue block13;
                }
                case GROUP: {
                    Instructions.GroupInstruction group = (Instructions.GroupInstruction)i;
                    OFActionGroup.Builder groupBuilder = this.factory().actions().buildGroup().setGroup(OFGroup.of((int)((Integer)group.groupId().id())));
                    actions.add((OFAction)groupBuilder.build());
                    continue block13;
                }
                case QUEUE: {
                    Instructions.SetQueueInstruction queue = (Instructions.SetQueueInstruction)i;
                    OFActionSetQueue.Builder queueBuilder = this.factory().actions().buildSetQueue().setQueueId(queue.queueId());
                    actions.add((OFAction)queueBuilder.build());
                    continue block13;
                }
                case TABLE: {
                    tableFound = true;
                    continue block13;
                }
                case EXTENSION: {
                    actions.add(this.buildExtensionAction(((Instructions.ExtensionInstructionWrapper)i).extensionInstruction()));
                    continue block13;
                }
            }
            this.log.warn("Instruction type {} not yet implemented.", (Object)i.type());
        }
        if (tableFound && actions.isEmpty()) {
            return Collections.emptyList();
        }
        return actions;
    }

    private OFInstruction buildTableGoto(Instructions.TableTypeTransition i) {
        OFInstructionGotoTable instruction = this.factory().instructions().gotoTable(TableId.of((int)i.tableId()));
        return instruction;
    }

    private OFInstruction buildMetadata(Instructions.MetadataInstruction m) {
        OFInstructionWriteMetadata instruction = this.factory().instructions().writeMetadata(U64.of((long)m.metadata()), U64.of((long)m.metadataMask()));
        return instruction;
    }

    private OFInstruction buildMeter(Instructions.MeterInstruction metered) {
        return this.factory().instructions().meter(((Long)metered.meterId().id()).longValue());
    }

    private OFAction buildL0Modification(Instruction i) {
        L0ModificationInstruction l0m = (L0ModificationInstruction)i;
        OFOxmExpOchSigId oxm = null;
        switch (l0m.subtype()) {
            case OCH: {
                try {
                    L0ModificationInstruction.ModOchSignalInstruction modOchSignalInstruction = (L0ModificationInstruction.ModOchSignalInstruction)l0m;
                    OchSignal signal = modOchSignalInstruction.lambda();
                    byte gridType = OpenFlowValueMapper.lookupGridType(signal.gridType());
                    byte channelSpacing = OpenFlowValueMapper.lookupChannelSpacing(signal.channelSpacing());
                    oxm = this.factory().oxms().expOchSigId(new CircuitSignalID(gridType, channelSpacing, (short)signal.spacingMultiplier(), (short)signal.slotGranularity()));
                }
                catch (NoMappingFoundException e) {
                    this.log.warn(e.getMessage());
                }
                break;
            }
            default: {
                this.log.warn("Unimplemented action type {}.", (Object)l0m.subtype());
            }
        }
        if (oxm != null) {
            return this.factory().actions().buildSetField().setField(oxm).build();
        }
        return null;
    }

    private OFAction buildL1Modification(Instruction i) {
        L1ModificationInstruction l1m = (L1ModificationInstruction)i;
        OFOxmExpOduSigId oxm = null;
        switch (l1m.subtype()) {
            case ODU_SIGID: {
                L1ModificationInstruction.ModOduSignalIdInstruction modOduSignalIdInstruction = (L1ModificationInstruction.ModOduSignalIdInstruction)l1m;
                OduSignalId oduSignalId = modOduSignalIdInstruction.oduSignalId();
                OduSignalID oduSignalID = new OduSignalID((int)((short)oduSignalId.tributaryPortNumber()), (int)((short)oduSignalId.tributarySlotLength()), oduSignalId.tributarySlotBitmap());
                oxm = this.factory().oxms().expOduSigId(oduSignalID);
                break;
            }
            default: {
                this.log.warn("Unimplemented action type {}.", (Object)l1m.subtype());
            }
        }
        if (oxm != null) {
            return this.factory().actions().buildSetField().setField(oxm).build();
        }
        return null;
    }

    private OFAction buildL2Modification(Instruction i) {
        L2ModificationInstruction l2m = (L2ModificationInstruction)i;
        OFOxmVlanPcp oxm = null;
        switch (l2m.subtype()) {
            case ETH_DST: {
                L2ModificationInstruction.ModEtherInstruction eth = (L2ModificationInstruction.ModEtherInstruction)l2m;
                oxm = this.factory().oxms().ethDst(MacAddress.of((long)eth.mac().toLong()));
                break;
            }
            case ETH_SRC: {
                L2ModificationInstruction.ModEtherInstruction eth = (L2ModificationInstruction.ModEtherInstruction)l2m;
                oxm = this.factory().oxms().ethSrc(MacAddress.of((long)eth.mac().toLong()));
                break;
            }
            case VLAN_ID: {
                L2ModificationInstruction.ModVlanIdInstruction vlanId = (L2ModificationInstruction.ModVlanIdInstruction)l2m;
                oxm = this.factory().oxms().vlanVid(OFVlanVidMatch.ofVlan((int)vlanId.vlanId().toShort()));
                break;
            }
            case VLAN_PCP: {
                L2ModificationInstruction.ModVlanPcpInstruction vlanPcp = (L2ModificationInstruction.ModVlanPcpInstruction)l2m;
                oxm = this.factory().oxms().vlanPcp(VlanPcp.of((byte)vlanPcp.vlanPcp()));
                break;
            }
            case MPLS_PUSH: {
                L2ModificationInstruction.ModMplsHeaderInstruction pushHeaderInstructions = (L2ModificationInstruction.ModMplsHeaderInstruction)l2m;
                return this.factory().actions().pushMpls(EthType.of((int)pushHeaderInstructions.ethernetType().toShort()));
            }
            case MPLS_POP: {
                L2ModificationInstruction.ModMplsHeaderInstruction popHeaderInstructions = (L2ModificationInstruction.ModMplsHeaderInstruction)l2m;
                return this.factory().actions().popMpls(EthType.of((int)popHeaderInstructions.ethernetType().toShort()));
            }
            case MPLS_LABEL: {
                L2ModificationInstruction.ModMplsLabelInstruction mplsLabel = (L2ModificationInstruction.ModMplsLabelInstruction)l2m;
                oxm = this.factory().oxms().mplsLabel(U32.of((long)mplsLabel.label().toInt()));
                break;
            }
            case MPLS_BOS: {
                L2ModificationInstruction.ModMplsBosInstruction mplsBos = (L2ModificationInstruction.ModMplsBosInstruction)l2m;
                oxm = this.factory().oxms().mplsBos(mplsBos.mplsBos() ? OFBooleanValue.TRUE : OFBooleanValue.FALSE);
                break;
            }
            case DEC_MPLS_TTL: {
                return this.factory().actions().decMplsTtl();
            }
            case VLAN_POP: {
                return this.factory().actions().popVlan();
            }
            case VLAN_PUSH: {
                L2ModificationInstruction.ModVlanHeaderInstruction pushVlanInstruction = (L2ModificationInstruction.ModVlanHeaderInstruction)l2m;
                return this.factory().actions().pushVlan(EthType.of((int)pushVlanInstruction.ethernetType().toShort()));
            }
            case TUNNEL_ID: {
                L2ModificationInstruction.ModTunnelIdInstruction tunnelId = (L2ModificationInstruction.ModTunnelIdInstruction)l2m;
                oxm = this.factory().oxms().tunnelId(U64.of((long)tunnelId.tunnelId()));
                break;
            }
            default: {
                this.log.warn("Unimplemented action type {}.", (Object)l2m.subtype());
            }
        }
        if (oxm != null) {
            return this.factory().actions().buildSetField().setField((OFOxm)oxm).build();
        }
        return null;
    }

    private OFAction buildL3Modification(Instruction i) {
        L3ModificationInstruction l3m = (L3ModificationInstruction)i;
        OFOxmArpSha oxm = null;
        switch (l3m.subtype()) {
            case IPV4_SRC: {
                L3ModificationInstruction.ModIPInstruction ip = (L3ModificationInstruction.ModIPInstruction)i;
                Ip4Address ip4 = ip.ip().getIp4Address();
                oxm = this.factory().oxms().ipv4Src(IPv4Address.of((int)ip4.toInt()));
                break;
            }
            case IPV4_DST: {
                L3ModificationInstruction.ModIPInstruction ip = (L3ModificationInstruction.ModIPInstruction)i;
                Ip4Address ip4 = ip.ip().getIp4Address();
                oxm = this.factory().oxms().ipv4Dst(IPv4Address.of((int)ip4.toInt()));
                break;
            }
            case IPV6_SRC: {
                L3ModificationInstruction.ModIPInstruction ip = (L3ModificationInstruction.ModIPInstruction)i;
                Ip6Address ip6 = ip.ip().getIp6Address();
                oxm = this.factory().oxms().ipv6Src(IPv6Address.of((byte[])ip6.toOctets()));
                break;
            }
            case IPV6_DST: {
                L3ModificationInstruction.ModIPInstruction ip = (L3ModificationInstruction.ModIPInstruction)i;
                Ip6Address ip6 = ip.ip().getIp6Address();
                oxm = this.factory().oxms().ipv6Dst(IPv6Address.of((byte[])ip6.toOctets()));
                break;
            }
            case IPV6_FLABEL: {
                L3ModificationInstruction.ModIPv6FlowLabelInstruction flowLabelInstruction = (L3ModificationInstruction.ModIPv6FlowLabelInstruction)i;
                int flowLabel = flowLabelInstruction.flowLabel();
                oxm = this.factory().oxms().ipv6Flabel(IPv6FlowLabel.of((int)flowLabel));
                break;
            }
            case ARP_SPA: {
                L3ModificationInstruction.ModArpIPInstruction aip = (L3ModificationInstruction.ModArpIPInstruction)i;
                Ip4Address ip4 = aip.ip().getIp4Address();
                oxm = this.factory().oxms().arpSpa(IPv4Address.of((int)ip4.toInt()));
                break;
            }
            case ARP_SHA: {
                L3ModificationInstruction.ModArpEthInstruction ei = (L3ModificationInstruction.ModArpEthInstruction)i;
                oxm = this.factory().oxms().arpSha(MacAddress.of((long)ei.mac().toLong()));
                break;
            }
            case ARP_OP: {
                L3ModificationInstruction.ModArpOpInstruction oi = (L3ModificationInstruction.ModArpOpInstruction)i;
                oxm = this.factory().oxms().arpOp(ArpOpcode.of((int)((int)oi.op())));
                break;
            }
            case DEC_TTL: {
                return this.factory().actions().decNwTtl();
            }
            case TTL_IN: {
                return this.factory().actions().copyTtlIn();
            }
            case TTL_OUT: {
                return this.factory().actions().copyTtlOut();
            }
            default: {
                this.log.warn("Unimplemented action type {}.", (Object)l3m.subtype());
            }
        }
        if (oxm != null) {
            return this.factory().actions().buildSetField().setField((OFOxm)oxm).build();
        }
        return null;
    }

    private OFAction buildL4Modification(Instruction i) {
        L4ModificationInstruction l4m = (L4ModificationInstruction)i;
        OFOxmTcpSrc oxm = null;
        switch (l4m.subtype()) {
            case TCP_SRC: {
                L4ModificationInstruction.ModTransportPortInstruction tp = (L4ModificationInstruction.ModTransportPortInstruction)l4m;
                oxm = this.factory().oxms().tcpSrc(TransportPort.of((int)tp.port().toInt()));
                break;
            }
            case TCP_DST: {
                L4ModificationInstruction.ModTransportPortInstruction tp = (L4ModificationInstruction.ModTransportPortInstruction)l4m;
                oxm = this.factory().oxms().tcpDst(TransportPort.of((int)tp.port().toInt()));
                break;
            }
            case UDP_SRC: {
                L4ModificationInstruction.ModTransportPortInstruction tp = (L4ModificationInstruction.ModTransportPortInstruction)l4m;
                oxm = this.factory().oxms().udpSrc(TransportPort.of((int)tp.port().toInt()));
                break;
            }
            case UDP_DST: {
                L4ModificationInstruction.ModTransportPortInstruction tp = (L4ModificationInstruction.ModTransportPortInstruction)l4m;
                oxm = this.factory().oxms().udpDst(TransportPort.of((int)tp.port().toInt()));
                break;
            }
            default: {
                this.log.warn("Unimplemented action type {}.", (Object)l4m.subtype());
            }
        }
        if (oxm != null) {
            return this.factory().actions().buildSetField().setField((OFOxm)oxm).build();
        }
        return null;
    }

    private OFAction buildExtensionAction(ExtensionTreatment i) {
        if (!this.driverService.isPresent()) {
            this.log.error("No driver service present");
            return null;
        }
        Driver driver = ((DriverService)this.driverService.get()).getDriver(this.deviceId);
        if (driver.hasBehaviour(ExtensionTreatmentInterpreter.class)) {
            DefaultDriverHandler handler = new DefaultDriverHandler((DriverData)new DefaultDriverData(driver, this.deviceId));
            ExtensionTreatmentInterpreter interpreter = (ExtensionTreatmentInterpreter)handler.behaviour(ExtensionTreatmentInterpreter.class);
            return interpreter.mapInstruction(this.factory(), i);
        }
        return null;
    }
}

