/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.flow.impl;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.onlab.packet.Ip4Address;
import org.onosproject.net.PortNumber;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flow.instructions.L3ModificationInstruction;
import org.onosproject.provider.of.flow.impl.FlowModBuilder;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFFlowAdd;
import org.projectfloodlight.openflow.protocol.OFFlowDelete;
import org.projectfloodlight.openflow.protocol.OFFlowMod;
import org.projectfloodlight.openflow.protocol.OFFlowModFlags;
import org.projectfloodlight.openflow.protocol.OFFlowModify;
import org.projectfloodlight.openflow.protocol.action.OFAction;
import org.projectfloodlight.openflow.protocol.action.OFActionEnqueue;
import org.projectfloodlight.openflow.protocol.action.OFActionOutput;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.OFBufferId;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.types.VlanPcp;
import org.projectfloodlight.openflow.types.VlanVid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowModBuilderVer10
extends FlowModBuilder {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int OFPCML_NO_BUFFER = 65535;
    private final TrafficTreatment treatment;

    protected FlowModBuilderVer10(FlowRule flowRule, OFFactory factory, Optional<Long> xid, Optional<DriverService> driverService) {
        super(flowRule, factory, xid, driverService);
        this.treatment = flowRule.treatment();
    }

    public OFFlowAdd buildFlowAdd() {
        Match match = this.buildMatch();
        List<OFAction> actions = this.buildActions();
        long cookie = this.flowRule().id().value();
        OFFlowAdd fm = this.factory().buildFlowAdd().setXid(this.xid.longValue()).setCookie(U64.of((long)cookie)).setBufferId(OFBufferId.NO_BUFFER).setActions(actions).setMatch(match).setFlags(Collections.singleton(OFFlowModFlags.SEND_FLOW_REM)).setPriority(this.flowRule().priority()).setHardTimeout(this.flowRule().hardTimeout()).build();
        return fm;
    }

    @Override
    public OFFlowMod buildFlowMod() {
        Match match = this.buildMatch();
        List<OFAction> actions = this.buildActions();
        long cookie = this.flowRule().id().value();
        OFFlowModify fm = this.factory().buildFlowModify().setXid(this.xid.longValue()).setCookie(U64.of((long)cookie)).setBufferId(OFBufferId.NO_BUFFER).setActions(actions).setMatch(match).setFlags(Collections.singleton(OFFlowModFlags.SEND_FLOW_REM)).setPriority(this.flowRule().priority()).setHardTimeout(this.flowRule().hardTimeout()).build();
        return fm;
    }

    public OFFlowDelete buildFlowDel() {
        Match match = this.buildMatch();
        long cookie = this.flowRule().id().value();
        OFFlowDelete fm = this.factory().buildFlowDelete().setXid(this.xid.longValue()).setCookie(U64.of((long)cookie)).setBufferId(OFBufferId.NO_BUFFER).setMatch(match).setFlags(Collections.singleton(OFFlowModFlags.SEND_FLOW_REM)).setPriority(this.flowRule().priority()).setHardTimeout(this.flowRule().hardTimeout()).build();
        return fm;
    }

    private List<OFAction> buildActions() {
        LinkedList<OFAction> acts = new LinkedList<OFAction>();
        if (this.treatment == null) {
            return acts;
        }
        block8: for (Instruction i : this.treatment.immediate()) {
            switch (i.type()) {
                case NOACTION: {
                    return Collections.emptyList();
                }
                case L2MODIFICATION: {
                    OFAction act = this.buildL2Modification(i);
                    if (act == null) continue block8;
                    acts.add(this.buildL2Modification(i));
                    continue block8;
                }
                case L3MODIFICATION: {
                    OFAction act = this.buildL3Modification(i);
                    if (act == null) continue block8;
                    acts.add(this.buildL3Modification(i));
                    continue block8;
                }
                case OUTPUT: {
                    Instructions.OutputInstruction out = (Instructions.OutputInstruction)i;
                    OFActionOutput.Builder action = this.factory().actions().buildOutput().setPort(OFPort.of((int)((int)out.port().toLong())));
                    if (out.port().equals((Object)PortNumber.CONTROLLER)) {
                        action.setMaxLen(65535);
                    }
                    acts.add((OFAction)action.build());
                    continue block8;
                }
                case QUEUE: {
                    Instructions.SetQueueInstruction queue = (Instructions.SetQueueInstruction)i;
                    if (queue.port() == null) {
                        this.log.warn("Required argument 'port' undefined for OFActionEnqueue");
                    }
                    OFActionEnqueue.Builder queueBuilder = this.factory().actions().buildEnqueue().setQueueId(queue.queueId()).setPort(OFPort.ofInt((int)((int)queue.port().toLong())));
                    acts.add((OFAction)queueBuilder.build());
                    continue block8;
                }
                case L0MODIFICATION: 
                case L1MODIFICATION: 
                case GROUP: 
                case TABLE: 
                case METADATA: {
                    this.log.warn("Instruction type {} not supported with protocol version {}", (Object)i.type(), (Object)this.factory().getVersion());
                    continue block8;
                }
            }
            this.log.warn("Instruction type {} not yet implemented.", (Object)i.type());
        }
        return acts;
    }

    private OFAction buildL3Modification(Instruction i) {
        L3ModificationInstruction l3m = (L3ModificationInstruction)i;
        switch (l3m.subtype()) {
            case IPV4_SRC: {
                L3ModificationInstruction.ModIPInstruction ip = (L3ModificationInstruction.ModIPInstruction)i;
                Ip4Address ip4 = ip.ip().getIp4Address();
                return this.factory().actions().setNwSrc(IPv4Address.of((int)ip4.toInt()));
            }
            case IPV4_DST: {
                L3ModificationInstruction.ModIPInstruction ip = (L3ModificationInstruction.ModIPInstruction)i;
                Ip4Address ip4 = ip.ip().getIp4Address();
                return this.factory().actions().setNwDst(IPv4Address.of((int)ip4.toInt()));
            }
        }
        this.log.warn("Unimplemented action type {}.", (Object)l3m.subtype());
        return null;
    }

    private OFAction buildL2Modification(Instruction i) {
        L2ModificationInstruction l2m = (L2ModificationInstruction)i;
        switch (l2m.subtype()) {
            case ETH_DST: {
                L2ModificationInstruction.ModEtherInstruction eth = (L2ModificationInstruction.ModEtherInstruction)l2m;
                return this.factory().actions().setDlDst(MacAddress.of((long)eth.mac().toLong()));
            }
            case ETH_SRC: {
                L2ModificationInstruction.ModEtherInstruction eth = (L2ModificationInstruction.ModEtherInstruction)l2m;
                return this.factory().actions().setDlSrc(MacAddress.of((long)eth.mac().toLong()));
            }
            case VLAN_ID: {
                L2ModificationInstruction.ModVlanIdInstruction vlanId = (L2ModificationInstruction.ModVlanIdInstruction)l2m;
                return this.factory().actions().setVlanVid(VlanVid.ofVlan((int)vlanId.vlanId().toShort()));
            }
            case VLAN_PCP: {
                L2ModificationInstruction.ModVlanPcpInstruction vlanPcp = (L2ModificationInstruction.ModVlanPcpInstruction)l2m;
                return this.factory().actions().setVlanPcp(VlanPcp.of((byte)vlanPcp.vlanPcp()));
            }
            case VLAN_POP: {
                return this.factory().actions().stripVlan();
            }
            case VLAN_PUSH: {
                return null;
            }
        }
        this.log.warn("Unimplemented action type {}.", (Object)l2m.subtype());
        return null;
    }
}

