/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.flow.impl;

import java.util.Optional;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.Ip4Prefix;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.Ip6Prefix;
import org.onlab.packet.VlanId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.OchSignal;
import org.onosproject.net.OduSignalId;
import org.onosproject.net.driver.DefaultDriverData;
import org.onosproject.net.driver.DefaultDriverHandler;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.driver.DriverData;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.criteria.ArpHaCriterion;
import org.onosproject.net.flow.criteria.ArpOpCriterion;
import org.onosproject.net.flow.criteria.ArpPaCriterion;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthCriterion;
import org.onosproject.net.flow.criteria.EthTypeCriterion;
import org.onosproject.net.flow.criteria.ExtensionCriterion;
import org.onosproject.net.flow.criteria.ExtensionSelector;
import org.onosproject.net.flow.criteria.IPCriterion;
import org.onosproject.net.flow.criteria.IPDscpCriterion;
import org.onosproject.net.flow.criteria.IPEcnCriterion;
import org.onosproject.net.flow.criteria.IPProtocolCriterion;
import org.onosproject.net.flow.criteria.IPv6ExthdrFlagsCriterion;
import org.onosproject.net.flow.criteria.IPv6FlowLabelCriterion;
import org.onosproject.net.flow.criteria.IPv6NDLinkLayerAddressCriterion;
import org.onosproject.net.flow.criteria.IPv6NDTargetAddressCriterion;
import org.onosproject.net.flow.criteria.IcmpCodeCriterion;
import org.onosproject.net.flow.criteria.IcmpTypeCriterion;
import org.onosproject.net.flow.criteria.Icmpv6CodeCriterion;
import org.onosproject.net.flow.criteria.Icmpv6TypeCriterion;
import org.onosproject.net.flow.criteria.MetadataCriterion;
import org.onosproject.net.flow.criteria.MplsBosCriterion;
import org.onosproject.net.flow.criteria.MplsCriterion;
import org.onosproject.net.flow.criteria.OchSignalCriterion;
import org.onosproject.net.flow.criteria.OchSignalTypeCriterion;
import org.onosproject.net.flow.criteria.OduSignalIdCriterion;
import org.onosproject.net.flow.criteria.OduSignalTypeCriterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.criteria.SctpPortCriterion;
import org.onosproject.net.flow.criteria.TcpPortCriterion;
import org.onosproject.net.flow.criteria.TunnelIdCriterion;
import org.onosproject.net.flow.criteria.UdpPortCriterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.criteria.VlanPcpCriterion;
import org.onosproject.openflow.controller.ExtensionSelectorInterpreter;
import org.onosproject.provider.of.flow.impl.FlowModBuilderVer10;
import org.onosproject.provider.of.flow.impl.FlowModBuilderVer13;
import org.onosproject.provider.of.flow.util.NoMappingFoundException;
import org.onosproject.provider.of.flow.util.OpenFlowValueMapper;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFFlowMod;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.types.ArpOpcode;
import org.projectfloodlight.openflow.types.CircuitSignalID;
import org.projectfloodlight.openflow.types.EthType;
import org.projectfloodlight.openflow.types.ICMPv4Code;
import org.projectfloodlight.openflow.types.ICMPv4Type;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.IPv6Address;
import org.projectfloodlight.openflow.types.IPv6FlowLabel;
import org.projectfloodlight.openflow.types.IpDscp;
import org.projectfloodlight.openflow.types.IpEcn;
import org.projectfloodlight.openflow.types.IpProtocol;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.Masked;
import org.projectfloodlight.openflow.types.OFBooleanValue;
import org.projectfloodlight.openflow.types.OFMetadata;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.OFValueType;
import org.projectfloodlight.openflow.types.OFVlanVidMatch;
import org.projectfloodlight.openflow.types.OduSignalID;
import org.projectfloodlight.openflow.types.TransportPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.types.U8;
import org.projectfloodlight.openflow.types.VlanPcp;
import org.projectfloodlight.openflow.types.VlanVid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FlowModBuilder {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final OFFactory factory;
    private final FlowRule flowRule;
    private final TrafficSelector selector;
    protected final Long xid;
    protected final Optional<DriverService> driverService;
    protected final DeviceId deviceId;

    public static FlowModBuilder builder(FlowRule flowRule, OFFactory factory, Optional<Long> xid, Optional<DriverService> driverService) {
        switch (factory.getVersion()) {
            case OF_10: {
                return new FlowModBuilderVer10(flowRule, factory, xid, driverService);
            }
            case OF_13: 
            case OF_14: {
                return new FlowModBuilderVer13(flowRule, factory, xid, driverService);
            }
        }
        throw new UnsupportedOperationException("No flow mod builder for protocol version " + factory.getVersion());
    }

    protected FlowModBuilder(FlowRule flowRule, OFFactory factory, Optional<Long> xid, Optional<DriverService> driverService) {
        this.factory = factory;
        this.flowRule = flowRule;
        this.selector = flowRule.selector();
        this.xid = xid.orElse(0L);
        this.driverService = driverService;
        this.deviceId = flowRule.deviceId();
    }

    public abstract OFFlowMod buildFlowAdd();

    public abstract OFFlowMod buildFlowMod();

    public abstract OFFlowMod buildFlowDel();

    protected Match buildMatch() {
        Match.Builder mBuilder = this.factory.buildMatch();
        block59: for (Criterion c : this.selector.criteria()) {
            switch (c.type()) {
                case IN_PORT: {
                    PortCriterion inPort = (PortCriterion)c;
                    mBuilder.setExact(MatchField.IN_PORT, (OFValueType)OFPort.of((int)((int)inPort.port().toLong())));
                    continue block59;
                }
                case IN_PHY_PORT: {
                    PortCriterion inPhyPort = (PortCriterion)c;
                    mBuilder.setExact(MatchField.IN_PORT, (OFValueType)OFPort.of((int)((int)inPhyPort.port().toLong())));
                    continue block59;
                }
                case METADATA: {
                    MetadataCriterion metadata = (MetadataCriterion)c;
                    mBuilder.setExact(MatchField.METADATA, (OFValueType)OFMetadata.ofRaw((long)metadata.metadata()));
                    continue block59;
                }
                case ETH_DST: {
                    EthCriterion ethCriterion = (EthCriterion)c;
                    mBuilder.setExact(MatchField.ETH_DST, (OFValueType)MacAddress.of((long)ethCriterion.mac().toLong()));
                    continue block59;
                }
                case ETH_DST_MASKED: {
                    EthCriterion ethCriterion = (EthCriterion)c;
                    mBuilder.setMasked(MatchField.ETH_DST, (OFValueType)MacAddress.of((long)ethCriterion.mac().toLong()), (OFValueType)MacAddress.of((long)ethCriterion.mask().toLong()));
                    continue block59;
                }
                case ETH_SRC: {
                    EthCriterion ethCriterion = (EthCriterion)c;
                    mBuilder.setExact(MatchField.ETH_SRC, (OFValueType)MacAddress.of((long)ethCriterion.mac().toLong()));
                    continue block59;
                }
                case ETH_SRC_MASKED: {
                    EthCriterion ethCriterion = (EthCriterion)c;
                    mBuilder.setMasked(MatchField.ETH_SRC, (OFValueType)MacAddress.of((long)ethCriterion.mac().toLong()), (OFValueType)MacAddress.of((long)ethCriterion.mask().toLong()));
                    continue block59;
                }
                case ETH_TYPE: {
                    EthTypeCriterion ethType = (EthTypeCriterion)c;
                    mBuilder.setExact(MatchField.ETH_TYPE, (OFValueType)EthType.of((int)ethType.ethType().toShort()));
                    continue block59;
                }
                case VLAN_VID: {
                    VlanIdCriterion vid = (VlanIdCriterion)c;
                    if (vid.vlanId().equals((Object)VlanId.ANY)) {
                        mBuilder.setMasked(MatchField.VLAN_VID, (OFValueType)OFVlanVidMatch.PRESENT, (OFValueType)OFVlanVidMatch.PRESENT);
                        continue block59;
                    }
                    if (vid.vlanId().equals((Object)VlanId.NONE)) {
                        mBuilder.setExact(MatchField.VLAN_VID, (OFValueType)OFVlanVidMatch.NONE);
                        continue block59;
                    }
                    mBuilder.setExact(MatchField.VLAN_VID, (OFValueType)OFVlanVidMatch.ofVlanVid((VlanVid)VlanVid.ofVlan((int)vid.vlanId().toShort())));
                    continue block59;
                }
                case VLAN_PCP: {
                    VlanPcpCriterion vpcp = (VlanPcpCriterion)c;
                    mBuilder.setExact(MatchField.VLAN_PCP, (OFValueType)VlanPcp.of((byte)vpcp.priority()));
                    continue block59;
                }
                case IP_DSCP: {
                    IPDscpCriterion ipDscpCriterion = (IPDscpCriterion)c;
                    mBuilder.setExact(MatchField.IP_DSCP, (OFValueType)IpDscp.of((byte)ipDscpCriterion.ipDscp()));
                    continue block59;
                }
                case IP_ECN: {
                    IPEcnCriterion ipEcnCriterion = (IPEcnCriterion)c;
                    mBuilder.setExact(MatchField.IP_ECN, (OFValueType)IpEcn.of((byte)ipEcnCriterion.ipEcn()));
                    continue block59;
                }
                case IP_PROTO: {
                    IPProtocolCriterion p = (IPProtocolCriterion)c;
                    mBuilder.setExact(MatchField.IP_PROTO, (OFValueType)IpProtocol.of((short)p.protocol()));
                    continue block59;
                }
                case IPV4_SRC: {
                    Masked maskedIp;
                    Ip4Address maskAddr;
                    IPCriterion ipCriterion = (IPCriterion)c;
                    Ip4Prefix ip4Prefix = ipCriterion.ip().getIp4Prefix();
                    if (ip4Prefix.prefixLength() != 32) {
                        maskAddr = Ip4Address.makeMaskPrefix((int)ip4Prefix.prefixLength());
                        maskedIp = Masked.of((OFValueType)IPv4Address.of((int)ip4Prefix.address().toInt()), (OFValueType)IPv4Address.of((int)maskAddr.toInt()));
                        mBuilder.setMasked(MatchField.IPV4_SRC, maskedIp);
                        continue block59;
                    }
                    mBuilder.setExact(MatchField.IPV4_SRC, (OFValueType)IPv4Address.of((int)ip4Prefix.address().toInt()));
                    continue block59;
                }
                case IPV4_DST: {
                    Masked maskedIp;
                    Ip4Address maskAddr;
                    IPCriterion ipCriterion = (IPCriterion)c;
                    Ip4Prefix ip4Prefix = ipCriterion.ip().getIp4Prefix();
                    if (ip4Prefix.prefixLength() != 32) {
                        maskAddr = Ip4Address.makeMaskPrefix((int)ip4Prefix.prefixLength());
                        maskedIp = Masked.of((OFValueType)IPv4Address.of((int)ip4Prefix.address().toInt()), (OFValueType)IPv4Address.of((int)maskAddr.toInt()));
                        mBuilder.setMasked(MatchField.IPV4_DST, maskedIp);
                        continue block59;
                    }
                    mBuilder.setExact(MatchField.IPV4_DST, (OFValueType)IPv4Address.of((int)ip4Prefix.address().toInt()));
                    continue block59;
                }
                case TCP_SRC: {
                    TcpPortCriterion tcpPortCriterion = (TcpPortCriterion)c;
                    mBuilder.setExact(MatchField.TCP_SRC, (OFValueType)TransportPort.of((int)tcpPortCriterion.tcpPort().toInt()));
                    continue block59;
                }
                case TCP_SRC_MASKED: {
                    TcpPortCriterion tcpPortCriterion = (TcpPortCriterion)c;
                    mBuilder.setMasked(MatchField.TCP_SRC, (OFValueType)TransportPort.of((int)tcpPortCriterion.tcpPort().toInt()), (OFValueType)TransportPort.of((int)tcpPortCriterion.mask().toInt()));
                    continue block59;
                }
                case TCP_DST: {
                    TcpPortCriterion tcpPortCriterion = (TcpPortCriterion)c;
                    mBuilder.setExact(MatchField.TCP_DST, (OFValueType)TransportPort.of((int)tcpPortCriterion.tcpPort().toInt()));
                    continue block59;
                }
                case TCP_DST_MASKED: {
                    TcpPortCriterion tcpPortCriterion = (TcpPortCriterion)c;
                    mBuilder.setMasked(MatchField.TCP_DST, (OFValueType)TransportPort.of((int)tcpPortCriterion.tcpPort().toInt()), (OFValueType)TransportPort.of((int)tcpPortCriterion.mask().toInt()));
                    continue block59;
                }
                case UDP_SRC: {
                    UdpPortCriterion udpPortCriterion = (UdpPortCriterion)c;
                    mBuilder.setExact(MatchField.UDP_SRC, (OFValueType)TransportPort.of((int)udpPortCriterion.udpPort().toInt()));
                    continue block59;
                }
                case UDP_SRC_MASKED: {
                    UdpPortCriterion udpPortCriterion = (UdpPortCriterion)c;
                    mBuilder.setMasked(MatchField.UDP_SRC, (OFValueType)TransportPort.of((int)udpPortCriterion.udpPort().toInt()), (OFValueType)TransportPort.of((int)udpPortCriterion.mask().toInt()));
                    continue block59;
                }
                case UDP_DST: {
                    UdpPortCriterion udpPortCriterion = (UdpPortCriterion)c;
                    mBuilder.setExact(MatchField.UDP_DST, (OFValueType)TransportPort.of((int)udpPortCriterion.udpPort().toInt()));
                    continue block59;
                }
                case UDP_DST_MASKED: {
                    UdpPortCriterion udpPortCriterion = (UdpPortCriterion)c;
                    mBuilder.setMasked(MatchField.UDP_DST, (OFValueType)TransportPort.of((int)udpPortCriterion.udpPort().toInt()), (OFValueType)TransportPort.of((int)udpPortCriterion.mask().toInt()));
                    continue block59;
                }
                case SCTP_SRC: {
                    SctpPortCriterion sctpPortCriterion = (SctpPortCriterion)c;
                    mBuilder.setExact(MatchField.SCTP_SRC, (OFValueType)TransportPort.of((int)sctpPortCriterion.sctpPort().toInt()));
                    continue block59;
                }
                case SCTP_SRC_MASKED: {
                    SctpPortCriterion sctpPortCriterion = (SctpPortCriterion)c;
                    mBuilder.setMasked(MatchField.SCTP_SRC, (OFValueType)TransportPort.of((int)sctpPortCriterion.sctpPort().toInt()), (OFValueType)TransportPort.of((int)sctpPortCriterion.mask().toInt()));
                    continue block59;
                }
                case SCTP_DST: {
                    SctpPortCriterion sctpPortCriterion = (SctpPortCriterion)c;
                    mBuilder.setExact(MatchField.SCTP_DST, (OFValueType)TransportPort.of((int)sctpPortCriterion.sctpPort().toInt()));
                    continue block59;
                }
                case SCTP_DST_MASKED: {
                    SctpPortCriterion sctpPortCriterion = (SctpPortCriterion)c;
                    mBuilder.setMasked(MatchField.SCTP_DST, (OFValueType)TransportPort.of((int)sctpPortCriterion.sctpPort().toInt()), (OFValueType)TransportPort.of((int)sctpPortCriterion.mask().toInt()));
                    continue block59;
                }
                case ICMPV4_TYPE: {
                    IcmpTypeCriterion icmpType = (IcmpTypeCriterion)c;
                    mBuilder.setExact(MatchField.ICMPV4_TYPE, (OFValueType)ICMPv4Type.of((short)icmpType.icmpType()));
                    continue block59;
                }
                case ICMPV4_CODE: {
                    IcmpCodeCriterion icmpCode = (IcmpCodeCriterion)c;
                    mBuilder.setExact(MatchField.ICMPV4_CODE, (OFValueType)ICMPv4Code.of((short)icmpCode.icmpCode()));
                    continue block59;
                }
                case IPV6_SRC: {
                    Masked maskedIp;
                    Ip6Address maskAddr;
                    IPCriterion ipCriterion = (IPCriterion)c;
                    Ip6Prefix ip6Prefix = ipCriterion.ip().getIp6Prefix();
                    if (ip6Prefix.prefixLength() != 128) {
                        maskAddr = Ip6Address.makeMaskPrefix((int)ip6Prefix.prefixLength());
                        maskedIp = Masked.of((OFValueType)IPv6Address.of((String)ip6Prefix.address().toString()), (OFValueType)IPv6Address.of((String)maskAddr.toString()));
                        mBuilder.setMasked(MatchField.IPV6_SRC, maskedIp);
                        continue block59;
                    }
                    mBuilder.setExact(MatchField.IPV6_SRC, (OFValueType)IPv6Address.of((String)ip6Prefix.address().toString()));
                    continue block59;
                }
                case IPV6_DST: {
                    Masked maskedIp;
                    Ip6Address maskAddr;
                    IPCriterion ipCriterion = (IPCriterion)c;
                    Ip6Prefix ip6Prefix = ipCriterion.ip().getIp6Prefix();
                    if (ip6Prefix.prefixLength() != 128) {
                        maskAddr = Ip6Address.makeMaskPrefix((int)ip6Prefix.prefixLength());
                        maskedIp = Masked.of((OFValueType)IPv6Address.of((String)ip6Prefix.address().toString()), (OFValueType)IPv6Address.of((String)maskAddr.toString()));
                        mBuilder.setMasked(MatchField.IPV6_DST, maskedIp);
                        continue block59;
                    }
                    mBuilder.setExact(MatchField.IPV6_DST, (OFValueType)IPv6Address.of((String)ip6Prefix.address().toString()));
                    continue block59;
                }
                case IPV6_FLABEL: {
                    IPv6FlowLabelCriterion flowLabelCriterion = (IPv6FlowLabelCriterion)c;
                    mBuilder.setExact(MatchField.IPV6_FLABEL, (OFValueType)IPv6FlowLabel.of((int)flowLabelCriterion.flowLabel()));
                    continue block59;
                }
                case ICMPV6_TYPE: {
                    Icmpv6TypeCriterion icmpv6Type = (Icmpv6TypeCriterion)c;
                    mBuilder.setExact(MatchField.ICMPV6_TYPE, (OFValueType)U8.of((short)icmpv6Type.icmpv6Type()));
                    continue block59;
                }
                case ICMPV6_CODE: {
                    Icmpv6CodeCriterion icmpv6Code = (Icmpv6CodeCriterion)c;
                    mBuilder.setExact(MatchField.ICMPV6_CODE, (OFValueType)U8.of((short)icmpv6Code.icmpv6Code()));
                    continue block59;
                }
                case IPV6_ND_TARGET: {
                    IPv6NDTargetAddressCriterion targetAddressCriterion = (IPv6NDTargetAddressCriterion)c;
                    Ip6Address ip6Address = targetAddressCriterion.targetAddress();
                    mBuilder.setExact(MatchField.IPV6_ND_TARGET, (OFValueType)IPv6Address.of((byte[])ip6Address.toOctets()));
                    continue block59;
                }
                case IPV6_ND_SLL: {
                    IPv6NDLinkLayerAddressCriterion llAddressCriterion = (IPv6NDLinkLayerAddressCriterion)c;
                    mBuilder.setExact(MatchField.IPV6_ND_SLL, (OFValueType)MacAddress.of((long)llAddressCriterion.mac().toLong()));
                    continue block59;
                }
                case IPV6_ND_TLL: {
                    IPv6NDLinkLayerAddressCriterion llAddressCriterion = (IPv6NDLinkLayerAddressCriterion)c;
                    mBuilder.setExact(MatchField.IPV6_ND_TLL, (OFValueType)MacAddress.of((long)llAddressCriterion.mac().toLong()));
                    continue block59;
                }
                case MPLS_LABEL: {
                    MplsCriterion mp = (MplsCriterion)c;
                    mBuilder.setExact(MatchField.MPLS_LABEL, (OFValueType)U32.of((long)mp.label().toInt()));
                    continue block59;
                }
                case IPV6_EXTHDR: {
                    IPv6ExthdrFlagsCriterion exthdrFlagsCriterion = (IPv6ExthdrFlagsCriterion)c;
                    mBuilder.setExact(MatchField.IPV6_EXTHDR, (OFValueType)U16.of((int)exthdrFlagsCriterion.exthdrFlags()));
                    continue block59;
                }
                case OCH_SIGID: {
                    try {
                        OchSignalCriterion ochSignalCriterion = (OchSignalCriterion)c;
                        OchSignal signal = ochSignalCriterion.lambda();
                        byte gridType = OpenFlowValueMapper.lookupGridType(signal.gridType());
                        byte channelSpacing = OpenFlowValueMapper.lookupChannelSpacing(signal.channelSpacing());
                        mBuilder.setExact(MatchField.EXP_OCH_SIG_ID, (OFValueType)new CircuitSignalID(gridType, channelSpacing, (short)signal.spacingMultiplier(), (short)signal.slotGranularity()));
                    }
                    catch (NoMappingFoundException e) {
                        this.log.warn(e.getMessage());
                    }
                    continue block59;
                }
                case OCH_SIGTYPE: {
                    try {
                        OchSignalTypeCriterion sc = (OchSignalTypeCriterion)c;
                        byte signalType = OpenFlowValueMapper.lookupOchSignalType(sc.signalType());
                        mBuilder.setExact(MatchField.EXP_OCH_SIGTYPE, (OFValueType)U8.of((short)signalType));
                    }
                    catch (NoMappingFoundException e) {
                        this.log.warn(e.getMessage());
                    }
                    continue block59;
                }
                case ODU_SIGID: {
                    OduSignalIdCriterion oduSignalIdCriterion = (OduSignalIdCriterion)c;
                    OduSignalId oduSignalId = oduSignalIdCriterion.oduSignalId();
                    mBuilder.setExact(MatchField.EXP_ODU_SIG_ID, (OFValueType)new OduSignalID((int)((short)oduSignalId.tributaryPortNumber()), (int)((short)oduSignalId.tributarySlotLength()), oduSignalId.tributarySlotBitmap()));
                    continue block59;
                }
                case ODU_SIGTYPE: {
                    try {
                        OduSignalTypeCriterion oduSignalTypeCriterion = (OduSignalTypeCriterion)c;
                        byte oduSigType = OpenFlowValueMapper.lookupOduSignalType(oduSignalTypeCriterion.signalType());
                        mBuilder.setExact(MatchField.EXP_ODU_SIGTYPE, (OFValueType)U8.of((short)oduSigType));
                    }
                    catch (NoMappingFoundException e) {
                        this.log.warn(e.getMessage());
                    }
                    continue block59;
                }
                case TUNNEL_ID: {
                    TunnelIdCriterion tunnelId = (TunnelIdCriterion)c;
                    mBuilder.setExact(MatchField.TUNNEL_ID, (OFValueType)U64.of((long)tunnelId.tunnelId()));
                    continue block59;
                }
                case MPLS_BOS: {
                    MplsBosCriterion mplsBos = (MplsBosCriterion)c;
                    mBuilder.setExact(MatchField.MPLS_BOS, (OFValueType)(mplsBos.mplsBos() ? OFBooleanValue.TRUE : OFBooleanValue.FALSE));
                    continue block59;
                }
                case ARP_OP: {
                    ArpOpCriterion arpOp = (ArpOpCriterion)c;
                    mBuilder.setExact(MatchField.ARP_OP, (OFValueType)ArpOpcode.of((int)arpOp.arpOp()));
                    continue block59;
                }
                case ARP_SHA: {
                    ArpHaCriterion arpHaCriterion = (ArpHaCriterion)c;
                    mBuilder.setExact(MatchField.ARP_SHA, (OFValueType)MacAddress.of((long)arpHaCriterion.mac().toLong()));
                    continue block59;
                }
                case ARP_SPA: {
                    ArpPaCriterion arpPaCriterion = (ArpPaCriterion)c;
                    mBuilder.setExact(MatchField.ARP_SPA, (OFValueType)IPv4Address.of((int)arpPaCriterion.ip().toInt()));
                    continue block59;
                }
                case ARP_THA: {
                    ArpHaCriterion arpHaCriterion = (ArpHaCriterion)c;
                    mBuilder.setExact(MatchField.ARP_THA, (OFValueType)MacAddress.of((long)arpHaCriterion.mac().toLong()));
                    continue block59;
                }
                case ARP_TPA: {
                    ArpPaCriterion arpPaCriterion = (ArpPaCriterion)c;
                    mBuilder.setExact(MatchField.ARP_TPA, (OFValueType)IPv4Address.of((int)arpPaCriterion.ip().toInt()));
                    continue block59;
                }
                case EXTENSION: {
                    ExtensionCriterion extensionCriterion = (ExtensionCriterion)c;
                    OFOxm oxm = this.buildExtensionOxm(extensionCriterion.extensionSelector());
                    if (oxm == null) {
                        this.log.warn("Unable to build extension selector");
                        continue block59;
                    }
                    if (oxm.isMasked()) {
                        mBuilder.setMasked(oxm.getMatchField(), oxm.getValue(), oxm.getMask());
                        continue block59;
                    }
                    mBuilder.setExact(oxm.getMatchField(), oxm.getValue());
                    continue block59;
                }
            }
            this.log.warn("Match type {} not yet implemented.", (Object)c.type());
        }
        return mBuilder.build();
    }

    protected FlowRule flowRule() {
        return this.flowRule;
    }

    protected OFFactory factory() {
        return this.factory;
    }

    private OFOxm buildExtensionOxm(ExtensionSelector extension) {
        if (!this.driverService.isPresent()) {
            this.log.error("No driver service present");
            return null;
        }
        Driver driver = this.driverService.get().getDriver(this.deviceId);
        if (driver.hasBehaviour(ExtensionSelectorInterpreter.class)) {
            DefaultDriverHandler handler = new DefaultDriverHandler((DriverData)new DefaultDriverData(driver, this.deviceId));
            ExtensionSelectorInterpreter interpreter = (ExtensionSelectorInterpreter)handler.behaviour(ExtensionSelectorInterpreter.class);
            return interpreter.mapSelector(this.factory(), extension);
        }
        return null;
    }
}

