/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.resource.impl;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.onlab.util.GuavaCollectors;
import org.onosproject.net.resource.ContinuousResource;
import org.onosproject.net.resource.ResourceAllocation;
import org.onosproject.net.resource.ResourceConsumerId;

final class ContinuousResourceAllocation {
    private final ContinuousResource original;
    private final ImmutableList<ResourceAllocation> allocations;

    static ContinuousResourceAllocation empty(ContinuousResource original) {
        return new ContinuousResourceAllocation(original, (ImmutableList<ResourceAllocation>)ImmutableList.of());
    }

    ContinuousResourceAllocation(ContinuousResource original, ImmutableList<ResourceAllocation> allocations) {
        this.original = original;
        this.allocations = allocations;
    }

    private ContinuousResourceAllocation() {
        this.original = null;
        this.allocations = null;
    }

    boolean hasEnoughResource(ContinuousResource request) {
        double allocated = this.allocations.stream().filter(x -> x.resource() instanceof ContinuousResource).map(x -> (ContinuousResource)x.resource()).mapToDouble(ContinuousResource::value).sum();
        double left = this.original.value() - allocated;
        return request.value() <= left;
    }

    ImmutableList<ResourceAllocation> allocations() {
        return this.allocations;
    }

    ContinuousResourceAllocation allocate(ResourceAllocation value) {
        return new ContinuousResourceAllocation(this.original, (ImmutableList<ResourceAllocation>)ImmutableList.builder().addAll(this.allocations).add((Object)value).build());
    }

    ContinuousResourceAllocation release(ContinuousResource resource, ResourceConsumerId consumerId) {
        List nonMatched = this.allocations.stream().filter(x -> !x.consumerId().equals((Object)consumerId) || ((ContinuousResource)x.resource()).value() != resource.value()).collect(Collectors.toList());
        List matched = this.allocations.stream().filter(x -> x.consumerId().equals((Object)consumerId) && ((ContinuousResource)x.resource()).value() == resource.value()).collect(Collectors.toList());
        if (!matched.isEmpty()) {
            matched.remove(0);
        }
        return new ContinuousResourceAllocation(this.original, (ImmutableList<ResourceAllocation>)((ImmutableList)Stream.concat(nonMatched.stream(), matched.stream()).collect(GuavaCollectors.toImmutableList())));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContinuousResourceAllocation that = (ContinuousResourceAllocation)o;
        if (!this.original.equals((Object)that.original)) {
            return false;
        }
        return this.allocations.equals(that.allocations);
    }

    public int hashCode() {
        return Objects.hash(this.original, this.allocations);
    }
}

