/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.resource.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.onlab.util.GuavaCollectors;
import org.onosproject.net.resource.ContinuousResource;
import org.onosproject.net.resource.ContinuousResourceId;
import org.onosproject.net.resource.DiscreteResource;
import org.onosproject.net.resource.DiscreteResourceId;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.ResourceAllocation;
import org.onosproject.net.resource.ResourceConsumerId;
import org.onosproject.store.resource.impl.ConsistentResourceStore;
import org.onosproject.store.resource.impl.ConsistentResourceSubStore;
import org.onosproject.store.resource.impl.ContinuousResourceAllocation;
import org.onosproject.store.resource.impl.TransactionalContinuousResourceSubStore;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.TransactionContext;
import org.onosproject.store.service.Versioned;

class ConsistentContinuousResourceSubStore
implements ConsistentResourceSubStore<ContinuousResourceId, ContinuousResource, TransactionalContinuousResourceSubStore> {
    private ConsistentMap<ContinuousResourceId, ContinuousResourceAllocation> consumers;
    private ConsistentMap<DiscreteResourceId, Set<ContinuousResource>> childMap;

    ConsistentContinuousResourceSubStore(StorageService service) {
        this.consumers = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)service.consistentMapBuilder().withName("onos-continuous-consumers")).withSerializer(ConsistentResourceStore.SERIALIZER)).build();
        this.childMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)service.consistentMapBuilder().withName("onos-resource-continuous-children")).withSerializer(ConsistentResourceStore.SERIALIZER)).build();
        this.childMap.put((Object)Resource.ROOT.id(), new LinkedHashSet());
    }

    @Override
    public TransactionalContinuousResourceSubStore transactional(TransactionContext tx) {
        return new TransactionalContinuousResourceSubStore(tx);
    }

    @Override
    public List<ResourceAllocation> getResourceAllocations(ContinuousResourceId resource) {
        Versioned allocations = this.consumers.get((Object)resource);
        if (allocations == null) {
            return ImmutableList.of();
        }
        return (List)((ContinuousResourceAllocation)allocations.value()).allocations().stream().filter(x -> x.resource().id().equals(resource)).collect(GuavaCollectors.toImmutableList());
    }

    @Override
    public Set<ContinuousResource> getChildResources(DiscreteResourceId parent) {
        Versioned children = this.childMap.get((Object)parent);
        if (children == null) {
            return ImmutableSet.of();
        }
        return (Set)children.value();
    }

    @Override
    public Set<ContinuousResource> getChildResources(DiscreteResourceId parent, Class<?> cls) {
        return this.getChildResources(parent).stream().filter(x -> x.isTypeOf(cls)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public boolean isAvailable(ContinuousResource resource) {
        Versioned children = this.childMap.get((Object)((DiscreteResource)resource.parent().get()).id());
        if (children == null) {
            return false;
        }
        boolean notEnoughRegistered = ((Set)children.value()).stream().filter(c -> c.id().equals((Object)resource.id())).findFirst().map(registered -> registered.value() < resource.value()).orElse(true);
        if (notEnoughRegistered) {
            return false;
        }
        Versioned allocation = this.consumers.get((Object)resource.id());
        if (allocation == null) {
            return true;
        }
        return ((ContinuousResourceAllocation)allocation.value()).hasEnoughResource(resource);
    }

    @Override
    public Stream<ContinuousResource> getAllocatedResources(DiscreteResourceId parent, Class<?> cls) {
        Set<ContinuousResource> children = this.getChildResources(parent);
        if (children.isEmpty()) {
            return Stream.of(new ContinuousResource[0]);
        }
        return children.stream().filter(x -> x.id().equals((Object)parent.child(cls))).filter(resource -> {
            Versioned allocation = this.consumers.get((Object)resource.id());
            if (allocation == null) {
                return false;
            }
            return !((ContinuousResourceAllocation)allocation.value()).allocations().isEmpty();
        });
    }

    @Override
    public Stream<ContinuousResource> getResources(ResourceConsumerId consumerId) {
        return this.consumers.values().stream().flatMap(x -> ((ContinuousResourceAllocation)x.value()).allocations().stream()).filter(x -> x.consumerId().equals((Object)consumerId)).map(x -> (ContinuousResource)x.resource());
    }
}

