/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.device.impl;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.PortDescription;
import org.onosproject.store.Timestamp;
import org.onosproject.store.impl.Timestamped;

class DeviceDescriptions {
    private volatile Timestamped<DeviceDescription> deviceDesc;
    private final ConcurrentMap<PortNumber, Timestamped<PortDescription>> portDescs;

    public DeviceDescriptions(Timestamped<DeviceDescription> desc) {
        this.deviceDesc = (Timestamped)Preconditions.checkNotNull(desc);
        this.portDescs = new ConcurrentHashMap<PortNumber, Timestamped<PortDescription>>();
    }

    public Timestamp getLatestTimestamp() {
        Timestamp latest = this.deviceDesc.timestamp();
        for (Timestamped desc : this.portDescs.values()) {
            if (desc.timestamp().compareTo((Object)latest) <= 0) continue;
            latest = desc.timestamp();
        }
        return latest;
    }

    public Timestamped<DeviceDescription> getDeviceDesc() {
        return this.deviceDesc;
    }

    public Timestamped<PortDescription> getPortDesc(PortNumber number) {
        return (Timestamped)this.portDescs.get(number);
    }

    public Map<PortNumber, Timestamped<PortDescription>> getPortDescs() {
        return Collections.unmodifiableMap(this.portDescs);
    }

    public void putDeviceDesc(Timestamped<DeviceDescription> newDesc) {
        Timestamped<DeviceDescription> oldOne = this.deviceDesc;
        Timestamped<DeviceDescription> newOne = newDesc;
        if (oldOne != null) {
            SparseAnnotations merged = DefaultAnnotations.union((SparseAnnotations)oldOne.value().annotations(), (SparseAnnotations)newDesc.value().annotations());
            newOne = new Timestamped<DefaultDeviceDescription>(new DefaultDeviceDescription(newDesc.value(), new SparseAnnotations[]{merged}), newDesc.timestamp());
        }
        this.deviceDesc = newOne;
    }

    public void putPortDesc(Timestamped<PortDescription> newDesc) {
        Timestamped oldOne = (Timestamped)this.portDescs.get(newDesc.value().portNumber());
        Timestamped<PortDescription> newOne = newDesc;
        if (oldOne != null) {
            SparseAnnotations merged = DefaultAnnotations.union((SparseAnnotations)((PortDescription)oldOne.value()).annotations(), (SparseAnnotations)newDesc.value().annotations());
            newOne = new Timestamped<DefaultPortDescription>(new DefaultPortDescription(newDesc.value(), merged), newDesc.timestamp());
        }
        this.portDescs.put(newOne.value().portNumber(), newOne);
    }
}

