/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.core.impl;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.core.IdBlock;
import org.onosproject.core.IdBlockStore;
import org.onosproject.store.service.AtomicCounter;
import org.onosproject.store.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedIdBlockStore
implements IdBlockStore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, AtomicCounter> topicCounters = Maps.newConcurrentMap();
    private static final long DEFAULT_BLOCK_SIZE = 0x100000L;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;

    @Activate
    public void activate() {
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    public IdBlock getIdBlock(String topic) {
        AtomicCounter counter = this.topicCounters.computeIfAbsent(topic, arg_0 -> ((StorageService)this.storageService).getAtomicCounter(arg_0));
        return new IdBlock(counter.getAndAdd(0x100000L), 0x100000L);
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }
}

