/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.cluster.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.onosproject.cluster.NodeId;

public class PhiAccrualFailureDetector {
    private final Map<NodeId, History> states = Maps.newConcurrentMap();
    private static final int DEFAULT_WINDOW_SIZE = 250;
    private static final int DEFAULT_MIN_SAMPLES = 25;
    private static final double DEFAULT_PHI_FACTOR = 1.0 / Math.log(10.0);
    private static final double DEFAULT_BOOTSTRAP_PHI_VALUE = 100.0;
    private int minSamples = 25;
    private double phiFactor = DEFAULT_PHI_FACTOR;
    private double bootstrapPhiValue = 100.0;

    public void report(NodeId nodeId) {
        this.report(nodeId, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(NodeId nodeId, long arrivalTime) {
        History nodeState;
        Preconditions.checkNotNull((Object)nodeId, (Object)"NodeId must not be null");
        Preconditions.checkArgument((arrivalTime >= 0L ? 1 : 0) != 0, (Object)"arrivalTime must not be negative");
        History history = nodeState = this.states.computeIfAbsent(nodeId, key -> new History());
        synchronized (history) {
            long latestHeartbeat = nodeState.latestHeartbeatTime();
            if (latestHeartbeat != -1L) {
                nodeState.samples().addValue((double)(arrivalTime - latestHeartbeat));
            }
            nodeState.setLatestHeartbeatTime(arrivalTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double phi(NodeId nodeId) {
        History nodeState;
        Preconditions.checkNotNull((Object)nodeId, (Object)"NodeId must not be null");
        if (!this.states.containsKey(nodeId)) {
            return this.bootstrapPhiValue;
        }
        History history = nodeState = this.states.get(nodeId);
        synchronized (history) {
            long latestHeartbeat = nodeState.latestHeartbeatTime();
            DescriptiveStatistics samples = nodeState.samples();
            if (latestHeartbeat == -1L || samples.getN() < (long)this.minSamples) {
                return 0.0;
            }
            return this.computePhi(samples, latestHeartbeat, System.currentTimeMillis());
        }
    }

    private double computePhi(DescriptiveStatistics samples, long tLast, long tNow) {
        long size = samples.getN();
        long t = tNow - tLast;
        return size > 0L ? this.phiFactor * (double)t / samples.getMean() : this.bootstrapPhiValue;
    }

    private void setMinSamples(int samples) {
        this.minSamples = samples;
    }

    private void setPhiFactor(double factor) {
        this.phiFactor = factor;
    }

    private void setBootstrapPhiValue(double phiValue) {
        this.bootstrapPhiValue = phiValue;
    }

    private static class History {
        DescriptiveStatistics samples = new DescriptiveStatistics(250);
        long lastHeartbeatTime = -1L;

        private History() {
        }

        public DescriptiveStatistics samples() {
            return this.samples;
        }

        public long latestHeartbeatTime() {
            return this.lastHeartbeatTime;
        }

        public void setLatestHeartbeatTime(long value) {
            this.lastHeartbeatTime = value;
        }
    }
}

