/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.restconf.restconfmanager;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.glassfish.jersey.server.ChunkedOutput;
import org.onosproject.config.DynamicConfigService;
import org.onosproject.config.FailedException;
import org.onosproject.config.Filter;
import org.onosproject.restconf.api.RestconfException;
import org.onosproject.restconf.api.RestconfService;
import org.onosproject.restconf.utils.RestconfUtils;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.DefaultResourceData;
import org.onosproject.yang.model.InnerNode;
import org.onosproject.yang.model.KeyLeaf;
import org.onosproject.yang.model.ListKey;
import org.onosproject.yang.model.NodeKey;
import org.onosproject.yang.model.ResourceData;
import org.onosproject.yang.model.ResourceId;
import org.onosproject.yang.model.SchemaId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class RestconfManager
implements RestconfService {
    private static final String RESTCONF_ROOT = "/onos/restconf";
    private static final int THREAD_TERMINATION_TIMEOUT = 10;
    private static final String EOL = "\r\n";
    private final int maxNumOfWorkerThreads = 5;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DynamicConfigService dynamicConfigService;
    private ConcurrentMap<String, BlockingQueue<ObjectNode>> eventQueueList = new ConcurrentHashMap<String, BlockingQueue<ObjectNode>>();
    private ExecutorService workerThreadPool;

    @Activate
    protected void activate() {
        this.workerThreadPool = Executors.newFixedThreadPool(5, new ThreadFactoryBuilder().setNameFormat("restconf-worker").build());
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.shutdownAndAwaitTermination(this.workerThreadPool);
        this.log.info("Stopped");
    }

    public ObjectNode runGetOperationOnDataResource(String uri) throws RestconfException {
        DataNode dataNode;
        ResourceId rid = RestconfUtils.convertUriToRid((String)uri);
        Filter filter = new Filter();
        try {
            dataNode = this.dynamicConfigService.readNode(rid, filter);
        }
        catch (FailedException e) {
            this.log.error("ERROR: DynamicConfigService: ", (Throwable)e);
            throw new RestconfException("ERROR: DynamicConfigService", Response.Status.INTERNAL_SERVER_ERROR);
        }
        ObjectNode rootNode = RestconfUtils.convertDataNodeToJson((ResourceId)rid, (DataNode)dataNode);
        return rootNode;
    }

    public void runPostOperationOnDataResource(String uri, ObjectNode rootNode) throws RestconfException {
        ResourceData receivedData = RestconfUtils.convertJsonToDataNode((String)uri, (ObjectNode)rootNode);
        ResourceData resourceData = this.getDataForStore(receivedData);
        ResourceId rid = resourceData.resourceId();
        List dataNodeList = resourceData.dataNodes();
        if (dataNodeList.size() > 1) {
            this.log.warn("ERROR: There are more than one Data Node can be proceed");
        }
        DataNode dataNode = (DataNode)dataNodeList.get(0);
        try {
            this.dynamicConfigService.createNodeRecursive(rid, dataNode);
        }
        catch (FailedException e) {
            this.log.error("ERROR: DynamicConfigService: ", (Throwable)e);
            throw new RestconfException("ERROR: DynamicConfigService", Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public void runPutOperationOnDataResource(String uri, ObjectNode rootNode) throws RestconfException {
        this.runPostOperationOnDataResource(uri, rootNode);
    }

    public void runDeleteOperationOnDataResource(String uri) throws RestconfException {
        ResourceId rid = RestconfUtils.convertUriToRid((String)uri);
        try {
            this.dynamicConfigService.deleteNodeRecursive(rid);
        }
        catch (FailedException e) {
            this.log.error("ERROR: DynamicConfigService: ", (Throwable)e);
            throw new RestconfException("ERROR: DynamicConfigService", Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public void runPatchOperationOnDataResource(String uri, ObjectNode rootNode) throws RestconfException {
    }

    public String getRestconfRootPath() {
        return RESTCONF_ROOT;
    }

    public void subscribeEventStream(String streamId, ChunkedOutput<String> output) throws RestconfException {
        if (this.workerThreadPool instanceof ThreadPoolExecutor) {
            if (((ThreadPoolExecutor)this.workerThreadPool).getActiveCount() >= 5) {
                throw new RestconfException("no more work threads left to handle event subscription", Response.Status.INTERNAL_SERVER_ERROR);
            }
        } else {
            throw new RestconfException("Server ERROR: workerThreadPool NOT instanceof ThreadPoolExecutor", Response.Status.INTERNAL_SERVER_ERROR);
        }
        LinkedBlockingQueue<ObjectNode> eventQueue = new LinkedBlockingQueue<ObjectNode>();
        this.workerThreadPool.submit(new EventConsumer(output, eventQueue));
    }

    private ResourceData getDataForStore(ResourceData resourceData) {
        List nodes = resourceData.dataNodes();
        ResourceId rid = resourceData.resourceId();
        DataNode.Builder dbr = null;
        ResourceId parentId = null;
        try {
            NodeKey lastKey = (NodeKey)rid.nodeKeys().get(rid.nodeKeys().size() - 1);
            SchemaId sid = lastKey.schemaId();
            if (lastKey instanceof ListKey) {
                dbr = InnerNode.builder((String)sid.name(), (String)sid.namespace()).type(DataNode.Type.MULTI_INSTANCE_NODE);
                for (KeyLeaf keyLeaf : ((ListKey)lastKey).keyLeafs()) {
                    Object val = keyLeaf.leafValue();
                    dbr = dbr.addKeyLeaf(keyLeaf.leafSchema().name(), sid.namespace(), val);
                    dbr = dbr.createChildBuilder(keyLeaf.leafSchema().name(), sid.namespace(), val).type(DataNode.Type.SINGLE_INSTANCE_LEAF_VALUE_NODE);
                    dbr = dbr.exitNode();
                }
            } else {
                dbr = InnerNode.builder((String)sid.name(), (String)sid.namespace()).type(DataNode.Type.SINGLE_INSTANCE_NODE);
            }
            if (nodes != null && !nodes.isEmpty()) {
                for (DataNode node : nodes) {
                    dbr = ((InnerNode.Builder)dbr).addNode(node);
                }
            }
            parentId = rid.copyBuilder().removeLastKey().build();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        DefaultResourceData.Builder resData = DefaultResourceData.builder();
        resData.addDataNode(dbr.build());
        resData.resourceId(parentId);
        return resData.build();
    }

    private void shutdownAndAwaitTermination(ExecutorService pool) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(10L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(10L, TimeUnit.SECONDS)) {
                    this.log.error("Pool did not terminate");
                }
            }
        }
        catch (Exception ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    protected void bindDynamicConfigService(DynamicConfigService dynamicConfigService) {
        this.dynamicConfigService = dynamicConfigService;
    }

    protected void unbindDynamicConfigService(DynamicConfigService dynamicConfigService) {
        if (this.dynamicConfigService == dynamicConfigService) {
            this.dynamicConfigService = null;
        }
    }

    private class EventConsumer
    implements Runnable {
        private String queueId;
        private final ChunkedOutput<String> output;
        private final BlockingQueue<ObjectNode> bqueue;

        public EventConsumer(ChunkedOutput<String> output, BlockingQueue<ObjectNode> q) {
            this.output = output;
            this.bqueue = q;
        }

        @Override
        public void run() {
            try {
                ObjectNode chunk;
                this.queueId = String.valueOf(Thread.currentThread().getId());
                RestconfManager.this.eventQueueList.put(this.queueId, this.bqueue);
                RestconfManager.this.log.debug("EventConsumer thread created: {}", (Object)this.queueId);
                while ((chunk = this.bqueue.take()) != null) {
                    this.output.write((Object)chunk.toString().concat(RestconfManager.EOL));
                }
            }
            catch (IOException e) {
                RestconfManager.this.log.debug("chunkedOuput is closed: {}", (Object)this.bqueue.toString());
                RestconfManager.this.eventQueueList.remove(this.queueId);
            }
            catch (InterruptedException e) {
                RestconfManager.this.log.error("ERROR: EventConsumer: bqueue.take() has been interrupted.");
                RestconfManager.this.log.debug("EventConsumer Exception:", (Throwable)e);
            }
            finally {
                try {
                    this.output.close();
                    RestconfManager.this.log.debug("EventConsumer thread terminated: {}", (Object)this.queueId);
                }
                catch (IOException e) {
                    RestconfManager.this.log.error("ERROR: EventConsumer: ", (Throwable)e);
                }
            }
        }
    }
}

