/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cpman;

import com.google.common.base.MoreObjects;

public final class MetricValue {
    private final long rate;
    private final long load;
    private final long count;

    private MetricValue(long rate, long load, long count) {
        this.rate = rate;
        this.load = load;
        this.count = count;
    }

    public long getRate() {
        return this.rate;
    }

    public long getLoad() {
        return this.load;
    }

    public long getCount() {
        return this.count;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MetricValue) {
            MetricValue other = (MetricValue)obj;
            if (this.rate == other.rate && this.load == other.load && this.count == other.count) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int prime = 1004;
        int result = super.hashCode();
        result = 1004 * result + (int)this.rate;
        result = 1004 * result + (int)this.load;
        result = 1004 * result + (int)this.count;
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("rate", (Object)Long.toHexString(this.rate)).add("load", (Object)Long.toHexString(this.load)).add("count", (Object)Long.toHexString(this.count)).toString();
    }

    public static final class Builder {
        private long rate;
        private long load;
        private long count;

        public Builder rate(long rate) {
            this.rate = rate;
            return this;
        }

        public Builder load(long load) {
            this.load = load;
            return this;
        }

        public Builder count(long count) {
            this.count = count;
            return this;
        }

        public MetricValue add() {
            return new MetricValue(this.rate, this.load, this.count);
        }
    }
}

