/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cpman;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.onlab.util.Tools;
import org.onosproject.cluster.NodeId;
import org.onosproject.cpman.ControlLoadSnapshot;
import org.onosproject.cpman.ControlMetric;
import org.onosproject.cpman.ControlMetricType;
import org.onosproject.cpman.ControlResource;
import org.onosproject.net.DeviceId;

public interface ControlPlaneMonitorService {
    public static final long TIMEOUT_MILLIS = 2000L;

    public void updateMetric(ControlMetric var1, int var2, Optional<DeviceId> var3);

    public void updateMetric(ControlMetric var1, int var2, String var3);

    public CompletableFuture<ControlLoadSnapshot> getLoad(NodeId var1, ControlMetricType var2, Optional<DeviceId> var3);

    default public ControlLoadSnapshot getLoadSync(NodeId nodeId, ControlMetricType type, Optional<DeviceId> deviceId) {
        return (ControlLoadSnapshot)Tools.futureGetOrElse(this.getLoad(nodeId, type, deviceId), (long)2000L, (TimeUnit)TimeUnit.MILLISECONDS, null);
    }

    public CompletableFuture<ControlLoadSnapshot> getLoad(NodeId var1, ControlMetricType var2, String var3);

    default public ControlLoadSnapshot getLoadSync(NodeId nodeId, ControlMetricType type, String resourceName) {
        return (ControlLoadSnapshot)Tools.futureGetOrElse(this.getLoad(nodeId, type, resourceName), (long)2000L, (TimeUnit)TimeUnit.MILLISECONDS, null);
    }

    public CompletableFuture<ControlLoadSnapshot> getLoad(NodeId var1, ControlMetricType var2, int var3, TimeUnit var4, Optional<DeviceId> var5);

    default public ControlLoadSnapshot getLoadSync(NodeId nodeId, ControlMetricType type, int duration, TimeUnit unit, Optional<DeviceId> deviceId) {
        return (ControlLoadSnapshot)Tools.futureGetOrElse(this.getLoad(nodeId, type, duration, unit, deviceId), (long)2000L, (TimeUnit)TimeUnit.MILLISECONDS, null);
    }

    public CompletableFuture<ControlLoadSnapshot> getLoad(NodeId var1, ControlMetricType var2, int var3, TimeUnit var4, String var5);

    default public ControlLoadSnapshot getLoadSync(NodeId nodeId, ControlMetricType type, int duration, TimeUnit unit, String resourceName) {
        return (ControlLoadSnapshot)Tools.futureGetOrElse(this.getLoad(nodeId, type, duration, unit, resourceName), (long)2000L, (TimeUnit)TimeUnit.MILLISECONDS, null);
    }

    public CompletableFuture<Set<String>> availableResources(NodeId var1, ControlResource.Type var2);

    default public Set<String> availableResourcesSync(NodeId nodeId, ControlResource.Type resourceType) {
        return (Set)Tools.futureGetOrElse(this.availableResources(nodeId, resourceType), (long)2000L, (TimeUnit)TimeUnit.MILLISECONDS, (Object)ImmutableSet.of());
    }
}

