/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cpman;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.onosproject.cpman.ControlMetricType;
import org.onosproject.net.DeviceId;

public class ControlMetricsRequest {
    private final ControlMetricType type;
    private Optional<DeviceId> deviceId;
    private String resourceName;
    private int duration;
    private TimeUnit unit;

    public ControlMetricsRequest(ControlMetricType type, Optional<DeviceId> deviceId) {
        this.type = type;
        this.deviceId = deviceId;
    }

    public ControlMetricsRequest(ControlMetricType type, int duration, TimeUnit unit, Optional<DeviceId> deviceId) {
        this.type = type;
        this.deviceId = deviceId;
        this.duration = duration;
        this.unit = unit;
    }

    public ControlMetricsRequest(ControlMetricType type, String resourceName) {
        this.type = type;
        this.resourceName = resourceName;
    }

    public ControlMetricsRequest(ControlMetricType type, int duration, TimeUnit unit, String resourceName) {
        this.type = type;
        this.resourceName = resourceName;
        this.duration = duration;
        this.unit = unit;
    }

    public ControlMetricType getType() {
        return this.type;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public Optional<DeviceId> getDeviceId() {
        return this.deviceId;
    }

    public int getDuration() {
        return this.duration;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.deviceId, this.resourceName, this.duration, this.unit.toString()});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ControlMetricsRequest) {
            ControlMetricsRequest other = (ControlMetricsRequest)obj;
            return Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.deviceId, other.deviceId) && Objects.equals(this.resourceName, other.resourceName) && Objects.equals(this.duration, other.duration) && Objects.equals((Object)this.unit, (Object)other.unit);
        }
        return false;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("resourceName", (Object)this.resourceName).add("duration", this.duration).add("timeUnit", (Object)this.unit);
        if (this.deviceId != null) {
            helper.add("deviceId", (Object)this.deviceId.get());
        }
        return helper.toString();
    }
}

