/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import java.util.ArrayList;
import javax.annotation.concurrent.Immutable;
import org.projectfloodlight.openflow.types.Masked;
import org.projectfloodlight.openflow.types.OFBitMask128;
import org.projectfloodlight.openflow.types.OFPort;

@Immutable
public class OFPortBitMap
extends Masked<OFBitMask128> {
    private OFPortBitMap(OFBitMask128 mask) {
        super(OFBitMask128.NONE, mask);
    }

    public boolean isOn(OFPort port) {
        return !((OFBitMask128)this.mask).isOn(port.getPortNumber());
    }

    public static OFPortBitMap ofPorts(OFPort ... ports) {
        Builder builder = new Builder();
        for (OFPort port : ports) {
            builder.set(port);
        }
        return builder.build();
    }

    public static OFPortBitMap of(OFBitMask128 mask) {
        return new OFPortBitMap(mask);
    }

    public Iterable<OFPort> getOnPorts() {
        ArrayList<OFPort> ports = new ArrayList<OFPort>();
        for (int i = 0; i < 127; ++i) {
            if (((OFBitMask128)this.mask).isOn(i)) continue;
            ports.add(OFPort.of(i));
        }
        return ports;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OFPortBitMap)) {
            return false;
        }
        OFPortBitMap other = (OFPortBitMap)obj;
        return ((OFBitMask128)other.value).equals(this.value) && ((OFBitMask128)other.mask).equals(this.mask);
    }

    @Override
    public int hashCode() {
        return 619 * ((OFBitMask128)this.mask).hashCode() + 257 * ((OFBitMask128)this.value).hashCode();
    }

    public static class Builder {
        private long raw1 = -1L;
        private long raw2 = -1L;

        public boolean isOn(OFPort port) {
            return !OFBitMask128.isBitOn(this.raw1, this.raw2, port.getPortNumber());
        }

        public Builder unset(OFPort port) {
            int bit = port.getPortNumber();
            if (bit < 0 || bit > 127) {
                throw new IndexOutOfBoundsException("Port number is out of bounds");
            }
            if (bit == 127) {
                throw new IndexOutOfBoundsException("The highest order bit in the bitmask is reserved.");
            }
            if (bit < 64) {
                this.raw2 |= 1L << bit;
            } else {
                this.raw1 |= 1L << bit - 64;
            }
            return this;
        }

        public Builder set(OFPort port) {
            int bit = port.getPortNumber();
            if (bit < 0 || bit > 127) {
                throw new IndexOutOfBoundsException("Port number is out of bounds");
            }
            if (bit == 127) {
                throw new IndexOutOfBoundsException("The highest order bit in the bitmask is reserved.");
            }
            if (bit < 64) {
                this.raw2 &= 1L << bit ^ 0xFFFFFFFFFFFFFFFFL;
            } else {
                this.raw1 &= 1L << bit - 64 ^ 0xFFFFFFFFFFFFFFFFL;
            }
            return this;
        }

        public OFPortBitMap build() {
            return new OFPortBitMap(OFBitMask128.of(this.raw1, this.raw2));
        }
    }
}

