/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.queueprop.OFQueuePropMaxRate;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFQueuePropMaxRateVer14
implements OFQueuePropMaxRate {
    private static final Logger logger = LoggerFactory.getLogger(OFQueuePropMaxRateVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 16;
    private static final int DEFAULT_RATE = 0;
    private final int rate;
    static final OFQueuePropMaxRateVer14 DEFAULT = new OFQueuePropMaxRateVer14(0);
    static final Reader READER = new Reader();
    static final OFQueuePropMaxRateVer14Funnel FUNNEL = new OFQueuePropMaxRateVer14Funnel();
    static final Writer WRITER = new Writer();

    OFQueuePropMaxRateVer14(int rate) {
        this.rate = rate;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public int getRate() {
        return this.rate;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFQueuePropMaxRate.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFQueuePropMaxRateVer14(");
        b.append("rate=").append(this.rate);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFQueuePropMaxRateVer14 other = (OFQueuePropMaxRateVer14)obj;
        return this.rate == other.rate;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.rate;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFQueuePropMaxRateVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFQueuePropMaxRateVer14 message) {
            bb.writeShort(2);
            bb.writeShort(16);
            bb.writeZero(4);
            bb.writeShort((int)U16.t(message.rate));
            bb.writeZero(6);
        }
    }

    static class OFQueuePropMaxRateVer14Funnel
    implements Funnel<OFQueuePropMaxRateVer14> {
        private static final long serialVersionUID = 1L;

        OFQueuePropMaxRateVer14Funnel() {
        }

        public void funnel(OFQueuePropMaxRateVer14 message, PrimitiveSink sink) {
            sink.putShort((short)2);
            sink.putShort((short)16);
            sink.putInt(message.rate);
        }
    }

    static class Reader
    implements OFMessageReader<OFQueuePropMaxRate> {
        Reader() {
        }

        @Override
        public OFQueuePropMaxRate readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 2) {
                throw new OFParseError("Wrong type: Expected=0x2(0x2), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(4);
            int rate = U16.f(bb.readShort());
            bb.skipBytes(6);
            OFQueuePropMaxRateVer14 queuePropMaxRateVer14 = new OFQueuePropMaxRateVer14(rate);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)queuePropMaxRateVer14);
            }
            return queuePropMaxRateVer14;
        }
    }

    static class Builder
    implements OFQueuePropMaxRate.Builder {
        private boolean rateSet;
        private int rate;

        Builder() {
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public int getRate() {
            return this.rate;
        }

        @Override
        public OFQueuePropMaxRate.Builder setRate(int rate) {
            this.rate = rate;
            this.rateSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFQueuePropMaxRate build() {
            int rate = this.rateSet ? this.rate : 0;
            return new OFQueuePropMaxRateVer14(rate);
        }
    }

    static class BuilderWithParent
    implements OFQueuePropMaxRate.Builder {
        final OFQueuePropMaxRateVer14 parentMessage;
        private boolean rateSet;
        private int rate;

        BuilderWithParent(OFQueuePropMaxRateVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public int getRate() {
            return this.rate;
        }

        @Override
        public OFQueuePropMaxRate.Builder setRate(int rate) {
            this.rate = rate;
            this.rateSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFQueuePropMaxRate build() {
            int rate = this.rateSet ? this.rate : this.parentMessage.rate;
            return new OFQueuePropMaxRateVer14(rate);
        }
    }
}

