/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFQueueDesc;
import org.projectfloodlight.openflow.protocol.OFQueueDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver14.OFQueueDescVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFStatsReplyFlagsSerializerVer14;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFQueueDescStatsReplyVer14
implements OFQueueDescStatsReply {
    private static final Logger logger = LoggerFactory.getLogger(OFQueueDescStatsReplyVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 16;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsReplyFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final List<OFQueueDesc> DEFAULT_ENTRIES = ImmutableList.of();
    private final long xid;
    private final Set<OFStatsReplyFlags> flags;
    private final List<OFQueueDesc> entries;
    static final OFQueueDescStatsReplyVer14 DEFAULT = new OFQueueDescStatsReplyVer14(0L, DEFAULT_FLAGS, DEFAULT_ENTRIES);
    static final Reader READER = new Reader();
    static final OFQueueDescStatsReplyVer14Funnel FUNNEL = new OFQueueDescStatsReplyVer14Funnel();
    static final Writer WRITER = new Writer();

    OFQueueDescStatsReplyVer14(long xid, Set<OFStatsReplyFlags> flags, List<OFQueueDesc> entries) {
        if (flags == null) {
            throw new NullPointerException("OFQueueDescStatsReplyVer14: property flags cannot be null");
        }
        if (entries == null) {
            throw new NullPointerException("OFQueueDescStatsReplyVer14: property entries cannot be null");
        }
        this.xid = xid;
        this.flags = flags;
        this.entries = entries;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REPLY;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.QUEUE_DESC;
    }

    @Override
    public Set<OFStatsReplyFlags> getFlags() {
        return this.flags;
    }

    @Override
    public List<OFQueueDesc> getEntries() {
        return this.entries;
    }

    @Override
    public OFQueueDescStatsReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFQueueDescStatsReplyVer14(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("entries=").append(this.entries);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFQueueDescStatsReplyVer14 other = (OFQueueDescStatsReplyVer14)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return !(this.entries == null ? other.entries != null : !this.entries.equals(other.entries));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.entries == null ? 0 : this.entries.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFQueueDescStatsReplyVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFQueueDescStatsReplyVer14 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(5);
            bb.writeByte(19);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(15);
            OFStatsReplyFlagsSerializerVer14.writeTo(bb, message.flags);
            bb.writeZero(4);
            ChannelUtils.writeList(bb, message.entries);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFQueueDescStatsReplyVer14Funnel
    implements Funnel<OFQueueDescStatsReplyVer14> {
        private static final long serialVersionUID = 1L;

        OFQueueDescStatsReplyVer14Funnel() {
        }

        public void funnel(OFQueueDescStatsReplyVer14 message, PrimitiveSink sink) {
            sink.putByte((byte)5);
            sink.putByte((byte)19);
            sink.putLong(message.xid);
            sink.putShort((short)15);
            OFStatsReplyFlagsSerializerVer14.putTo(message.flags, sink);
            FunnelUtils.putList(message.entries, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFQueueDescStatsReply> {
        Reader() {
        }

        @Override
        public OFQueueDescStatsReply readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 19) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REPLY(19), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != 15) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.QUEUE_DESC(15), got=" + statsType);
            }
            Set<OFStatsReplyFlags> flags = OFStatsReplyFlagsSerializerVer14.readFrom(bb);
            bb.skipBytes(4);
            List<OFQueueDesc> entries = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFQueueDescVer14.READER);
            OFQueueDescStatsReplyVer14 queueDescStatsReplyVer14 = new OFQueueDescStatsReplyVer14(xid, flags, entries);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)queueDescStatsReplyVer14);
            }
            return queueDescStatsReplyVer14;
        }
    }

    static class Builder
    implements OFQueueDescStatsReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsReplyFlags> flags;
        private boolean entriesSet;
        private List<OFQueueDesc> entries;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFQueueDescStatsReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.QUEUE_DESC;
        }

        @Override
        public Set<OFStatsReplyFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFQueueDescStatsReply.Builder setFlags(Set<OFStatsReplyFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public List<OFQueueDesc> getEntries() {
            return this.entries;
        }

        @Override
        public OFQueueDescStatsReply.Builder setEntries(List<OFQueueDesc> entries) {
            this.entries = entries;
            this.entriesSet = true;
            return this;
        }

        @Override
        public OFQueueDescStatsReply build() {
            List<OFQueueDesc> entries;
            Set<OFStatsReplyFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsReplyFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            List<OFQueueDesc> list = entries = this.entriesSet ? this.entries : DEFAULT_ENTRIES;
            if (entries == null) {
                throw new NullPointerException("Property entries must not be null");
            }
            return new OFQueueDescStatsReplyVer14(xid, flags, entries);
        }
    }

    static class BuilderWithParent
    implements OFQueueDescStatsReply.Builder {
        final OFQueueDescStatsReplyVer14 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsReplyFlags> flags;
        private boolean entriesSet;
        private List<OFQueueDesc> entries;

        BuilderWithParent(OFQueueDescStatsReplyVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFQueueDescStatsReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.QUEUE_DESC;
        }

        @Override
        public Set<OFStatsReplyFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFQueueDescStatsReply.Builder setFlags(Set<OFStatsReplyFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public List<OFQueueDesc> getEntries() {
            return this.entries;
        }

        @Override
        public OFQueueDescStatsReply.Builder setEntries(List<OFQueueDesc> entries) {
            this.entries = entries;
            this.entriesSet = true;
            return this;
        }

        @Override
        public OFQueueDescStatsReply build() {
            List entries;
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            List list = entries = this.entriesSet ? this.entries : this.parentMessage.entries;
            if (entries == null) {
                throw new NullPointerException("Property entries must not be null");
            }
            return new OFQueueDescStatsReplyVer14(xid, flags, entries);
        }
    }
}

