/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmNshNp;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmNshNpVer14
implements OFOxmNshNp {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmNshNpVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 5;
    private static final U8 DEFAULT_VALUE = U8.ZERO;
    private final U8 value;
    static final OFOxmNshNpVer14 DEFAULT = new OFOxmNshNpVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmNshNpVer14Funnel FUNNEL = new OFOxmNshNpVer14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmNshNpVer14(U8 value) {
        if (value == null) {
            throw new NullPointerException("OFOxmNshNpVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 126977L;
    }

    @Override
    public U8 getValue() {
        return this.value;
    }

    @Override
    public MatchField<U8> getMatchField() {
        return MatchField.NSH_NP;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U8> getCanonical() {
        return this;
    }

    @Override
    public U8 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.4");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmNshNp.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmNshNpVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmNshNpVer14 other = (OFOxmNshNpVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmNshNpVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmNshNpVer14 message) {
            bb.writeInt(126977);
            bb.writeByte((int)message.value.getRaw());
        }
    }

    static class OFOxmNshNpVer14Funnel
    implements Funnel<OFOxmNshNpVer14> {
        private static final long serialVersionUID = 1L;

        OFOxmNshNpVer14Funnel() {
        }

        public void funnel(OFOxmNshNpVer14 message, PrimitiveSink sink) {
            sink.putInt(126977);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmNshNp> {
        Reader() {
        }

        @Override
        public OFOxmNshNp readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 126977) {
                throw new OFParseError("Wrong typeLen: Expected=0x1f001L(0x1f001L), got=" + typeLen);
            }
            U8 value = U8.of(bb.readByte());
            OFOxmNshNpVer14 oxmNshNpVer14 = new OFOxmNshNpVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmNshNpVer14);
            }
            return oxmNshNpVer14;
        }
    }

    static class Builder
    implements OFOxmNshNp.Builder {
        private boolean valueSet;
        private U8 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 126977L;
        }

        @Override
        public U8 getValue() {
            return this.value;
        }

        @Override
        public OFOxmNshNp.Builder setValue(U8 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U8> getMatchField() {
            return MatchField.NSH_NP;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U8> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public U8 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmNshNp build() {
            U8 value;
            U8 u8 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmNshNpVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmNshNp.Builder {
        final OFOxmNshNpVer14 parentMessage;
        private boolean valueSet;
        private U8 value;

        BuilderWithParent(OFOxmNshNpVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 126977L;
        }

        @Override
        public U8 getValue() {
            return this.value;
        }

        @Override
        public OFOxmNshNp.Builder setValue(U8 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U8> getMatchField() {
            return MatchField.NSH_NP;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U8> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public U8 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmNshNp build() {
            U8 value;
            U8 u8 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmNshNpVer14(value);
        }
    }
}

