/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmInPort;
import org.projectfloodlight.openflow.types.OFPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmInPortVer14
implements OFOxmInPort {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmInPortVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final OFPort DEFAULT_VALUE = OFPort.ANY;
    private final OFPort value;
    static final OFOxmInPortVer14 DEFAULT = new OFOxmInPortVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmInPortVer14Funnel FUNNEL = new OFOxmInPortVer14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmInPortVer14(OFPort value) {
        if (value == null) {
            throw new NullPointerException("OFOxmInPortVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 0x80000004L;
    }

    @Override
    public OFPort getValue() {
        return this.value;
    }

    @Override
    public MatchField<OFPort> getMatchField() {
        return MatchField.IN_PORT;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<OFPort> getCanonical() {
        return this;
    }

    @Override
    public OFPort getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.4");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmInPort.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmInPortVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmInPortVer14 other = (OFOxmInPortVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmInPortVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmInPortVer14 message) {
            bb.writeInt(-2147483644);
            message.value.write4Bytes(bb);
        }
    }

    static class OFOxmInPortVer14Funnel
    implements Funnel<OFOxmInPortVer14> {
        private static final long serialVersionUID = 1L;

        OFOxmInPortVer14Funnel() {
        }

        public void funnel(OFOxmInPortVer14 message, PrimitiveSink sink) {
            sink.putInt(-2147483644);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmInPort> {
        Reader() {
        }

        @Override
        public OFOxmInPort readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147483644) {
                throw new OFParseError("Wrong typeLen: Expected=0x80000004L(0x80000004L), got=" + typeLen);
            }
            OFPort value = OFPort.read4Bytes(bb);
            OFOxmInPortVer14 oxmInPortVer14 = new OFOxmInPortVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmInPortVer14);
            }
            return oxmInPortVer14;
        }
    }

    static class Builder
    implements OFOxmInPort.Builder {
        private boolean valueSet;
        private OFPort value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 0x80000004L;
        }

        @Override
        public OFPort getValue() {
            return this.value;
        }

        @Override
        public OFOxmInPort.Builder setValue(OFPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<OFPort> getMatchField() {
            return MatchField.IN_PORT;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<OFPort> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public OFPort getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmInPort build() {
            OFPort value;
            OFPort oFPort = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmInPortVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmInPort.Builder {
        final OFOxmInPortVer14 parentMessage;
        private boolean valueSet;
        private OFPort value;

        BuilderWithParent(OFOxmInPortVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 0x80000004L;
        }

        @Override
        public OFPort getValue() {
            return this.value;
        }

        @Override
        public OFOxmInPort.Builder setValue(OFPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<OFPort> getMatchField() {
            return MatchField.IN_PORT;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<OFPort> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public OFPort getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmInPort build() {
            OFPort value;
            OFPort oFPort = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmInPortVer14(value);
        }
    }
}

