/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnSwitchPipelineStatsRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFStatsRequestFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver14.OFStatsRequestFlagsSerializerVer14;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnSwitchPipelineStatsRequestVer14
implements OFBsnSwitchPipelineStatsRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnSwitchPipelineStatsRequestVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsRequestFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private final long xid;
    private final Set<OFStatsRequestFlags> flags;
    static final OFBsnSwitchPipelineStatsRequestVer14 DEFAULT = new OFBsnSwitchPipelineStatsRequestVer14(0L, DEFAULT_FLAGS);
    static final Reader READER = new Reader();
    static final OFBsnSwitchPipelineStatsRequestVer14Funnel FUNNEL = new OFBsnSwitchPipelineStatsRequestVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnSwitchPipelineStatsRequestVer14(long xid, Set<OFStatsRequestFlags> flags) {
        if (flags == null) {
            throw new NullPointerException("OFBsnSwitchPipelineStatsRequestVer14: property flags cannot be null");
        }
        this.xid = xid;
        this.flags = flags;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.EXPERIMENTER;
    }

    @Override
    public Set<OFStatsRequestFlags> getFlags() {
        return this.flags;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 6L;
    }

    @Override
    public OFBsnSwitchPipelineStatsRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnSwitchPipelineStatsRequestVer14(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnSwitchPipelineStatsRequestVer14 other = (OFBsnSwitchPipelineStatsRequestVer14)obj;
        if (this.xid != other.xid) {
            return false;
        }
        return !(this.flags == null ? other.flags != null : !this.flags.equals(other.flags));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnSwitchPipelineStatsRequestVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnSwitchPipelineStatsRequestVer14 message) {
            bb.writeByte(5);
            bb.writeByte(18);
            bb.writeShort(24);
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(-1);
            OFStatsRequestFlagsSerializerVer14.writeTo(bb, message.flags);
            bb.writeZero(4);
            bb.writeInt(6035143);
            bb.writeInt(6);
        }
    }

    static class OFBsnSwitchPipelineStatsRequestVer14Funnel
    implements Funnel<OFBsnSwitchPipelineStatsRequestVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnSwitchPipelineStatsRequestVer14Funnel() {
        }

        public void funnel(OFBsnSwitchPipelineStatsRequestVer14 message, PrimitiveSink sink) {
            sink.putByte((byte)5);
            sink.putByte((byte)18);
            sink.putShort((short)24);
            sink.putLong(message.xid);
            sink.putShort((short)-1);
            OFStatsRequestFlagsSerializerVer14.putTo(message.flags, sink);
            sink.putInt(6035143);
            sink.putInt(6);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnSwitchPipelineStatsRequest> {
        Reader() {
        }

        @Override
        public OFBsnSwitchPipelineStatsRequest readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 18) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REQUEST(18), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 24) {
                throw new OFParseError("Wrong length: Expected=24(24), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != -1) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.EXPERIMENTER(65535), got=" + statsType);
            }
            Set<OFStatsRequestFlags> flags = OFStatsRequestFlagsSerializerVer14.readFrom(bb);
            bb.skipBytes(4);
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 6) {
                throw new OFParseError("Wrong subtype: Expected=0x6L(0x6L), got=" + subtype);
            }
            OFBsnSwitchPipelineStatsRequestVer14 bsnSwitchPipelineStatsRequestVer14 = new OFBsnSwitchPipelineStatsRequestVer14(xid, flags);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnSwitchPipelineStatsRequestVer14);
            }
            return bsnSwitchPipelineStatsRequestVer14;
        }
    }

    static class Builder
    implements OFBsnSwitchPipelineStatsRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnSwitchPipelineStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.EXPERIMENTER;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBsnSwitchPipelineStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 6L;
        }

        @Override
        public OFBsnSwitchPipelineStatsRequest build() {
            Set<OFStatsRequestFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsRequestFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            return new OFBsnSwitchPipelineStatsRequestVer14(xid, flags);
        }
    }

    static class BuilderWithParent
    implements OFBsnSwitchPipelineStatsRequest.Builder {
        final OFBsnSwitchPipelineStatsRequestVer14 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;

        BuilderWithParent(OFBsnSwitchPipelineStatsRequestVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnSwitchPipelineStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.EXPERIMENTER;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBsnSwitchPipelineStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 6L;
        }

        @Override
        public OFBsnSwitchPipelineStatsRequest build() {
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            return new OFBsnSwitchPipelineStatsRequestVer14(xid, flags);
        }
    }
}

