/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnFlowIdleEnableSetRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnFlowIdleEnableSetRequestVer14
implements OFBsnFlowIdleEnableSetRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnFlowIdleEnableSetRequestVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 20;
    private static final long DEFAULT_XID = 0L;
    private static final long DEFAULT_ENABLE = 0L;
    private final long xid;
    private final long enable;
    static final OFBsnFlowIdleEnableSetRequestVer14 DEFAULT = new OFBsnFlowIdleEnableSetRequestVer14(0L, 0L);
    static final Reader READER = new Reader();
    static final OFBsnFlowIdleEnableSetRequestVer14Funnel FUNNEL = new OFBsnFlowIdleEnableSetRequestVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnFlowIdleEnableSetRequestVer14(long xid, long enable) {
        this.xid = xid;
        this.enable = enable;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 36L;
    }

    @Override
    public long getEnable() {
        return this.enable;
    }

    @Override
    public OFBsnFlowIdleEnableSetRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnFlowIdleEnableSetRequestVer14(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("enable=").append(this.enable);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnFlowIdleEnableSetRequestVer14 other = (OFBsnFlowIdleEnableSetRequestVer14)obj;
        if (this.xid != other.xid) {
            return false;
        }
        return this.enable == other.enable;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * (int)(this.enable ^ this.enable >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnFlowIdleEnableSetRequestVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnFlowIdleEnableSetRequestVer14 message) {
            bb.writeByte(5);
            bb.writeByte(4);
            bb.writeShort(20);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(36);
            bb.writeInt(U32.t(message.enable));
        }
    }

    static class OFBsnFlowIdleEnableSetRequestVer14Funnel
    implements Funnel<OFBsnFlowIdleEnableSetRequestVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnFlowIdleEnableSetRequestVer14Funnel() {
        }

        public void funnel(OFBsnFlowIdleEnableSetRequestVer14 message, PrimitiveSink sink) {
            sink.putByte((byte)5);
            sink.putByte((byte)4);
            sink.putShort((short)20);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(36);
            sink.putLong(message.enable);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnFlowIdleEnableSetRequest> {
        Reader() {
        }

        @Override
        public OFBsnFlowIdleEnableSetRequest readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 20) {
                throw new OFParseError("Wrong length: Expected=20(20), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 36) {
                throw new OFParseError("Wrong subtype: Expected=0x24L(0x24L), got=" + subtype);
            }
            long enable = U32.f(bb.readInt());
            OFBsnFlowIdleEnableSetRequestVer14 bsnFlowIdleEnableSetRequestVer14 = new OFBsnFlowIdleEnableSetRequestVer14(xid, enable);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnFlowIdleEnableSetRequestVer14);
            }
            return bsnFlowIdleEnableSetRequestVer14;
        }
    }

    static class Builder
    implements OFBsnFlowIdleEnableSetRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean enableSet;
        private long enable;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnFlowIdleEnableSetRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 36L;
        }

        @Override
        public long getEnable() {
            return this.enable;
        }

        @Override
        public OFBsnFlowIdleEnableSetRequest.Builder setEnable(long enable) {
            this.enable = enable;
            this.enableSet = true;
            return this;
        }

        @Override
        public OFBsnFlowIdleEnableSetRequest build() {
            long xid = this.xidSet ? this.xid : 0L;
            long enable = this.enableSet ? this.enable : 0L;
            return new OFBsnFlowIdleEnableSetRequestVer14(xid, enable);
        }
    }

    static class BuilderWithParent
    implements OFBsnFlowIdleEnableSetRequest.Builder {
        final OFBsnFlowIdleEnableSetRequestVer14 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean enableSet;
        private long enable;

        BuilderWithParent(OFBsnFlowIdleEnableSetRequestVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnFlowIdleEnableSetRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 36L;
        }

        @Override
        public long getEnable() {
            return this.enable;
        }

        @Override
        public OFBsnFlowIdleEnableSetRequest.Builder setEnable(long enable) {
            this.enable = enable;
            this.enableSet = true;
            return this;
        }

        @Override
        public OFBsnFlowIdleEnableSetRequest build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            long enable = this.enableSet ? this.enable : this.parentMessage.enable;
            return new OFBsnFlowIdleEnableSetRequestVer14(xid, enable);
        }
    }
}

