/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFAsyncConfigPropPacketInSlave;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFAsyncConfigPropPacketInSlaveVer14
implements OFAsyncConfigPropPacketInSlave {
    private static final Logger logger = LoggerFactory.getLogger(OFAsyncConfigPropPacketInSlaveVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final long DEFAULT_MASK = 0L;
    private final long mask;
    static final OFAsyncConfigPropPacketInSlaveVer14 DEFAULT = new OFAsyncConfigPropPacketInSlaveVer14(0L);
    static final Reader READER = new Reader();
    static final OFAsyncConfigPropPacketInSlaveVer14Funnel FUNNEL = new OFAsyncConfigPropPacketInSlaveVer14Funnel();
    static final Writer WRITER = new Writer();

    OFAsyncConfigPropPacketInSlaveVer14(long mask) {
        this.mask = mask;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public long getMask() {
        return this.mask;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFAsyncConfigPropPacketInSlave.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFAsyncConfigPropPacketInSlaveVer14(");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFAsyncConfigPropPacketInSlaveVer14 other = (OFAsyncConfigPropPacketInSlaveVer14)obj;
        return this.mask == other.mask;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.mask ^ this.mask >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFAsyncConfigPropPacketInSlaveVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFAsyncConfigPropPacketInSlaveVer14 message) {
            bb.writeShort(0);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.mask));
        }
    }

    static class OFAsyncConfigPropPacketInSlaveVer14Funnel
    implements Funnel<OFAsyncConfigPropPacketInSlaveVer14> {
        private static final long serialVersionUID = 1L;

        OFAsyncConfigPropPacketInSlaveVer14Funnel() {
        }

        public void funnel(OFAsyncConfigPropPacketInSlaveVer14 message, PrimitiveSink sink) {
            sink.putShort((short)0);
            sink.putShort((short)8);
            sink.putLong(message.mask);
        }
    }

    static class Reader
    implements OFMessageReader<OFAsyncConfigPropPacketInSlave> {
        Reader() {
        }

        @Override
        public OFAsyncConfigPropPacketInSlave readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 0) {
                throw new OFParseError("Wrong type: Expected=0x0(0x0), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long mask = U32.f(bb.readInt());
            OFAsyncConfigPropPacketInSlaveVer14 asyncConfigPropPacketInSlaveVer14 = new OFAsyncConfigPropPacketInSlaveVer14(mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)asyncConfigPropPacketInSlaveVer14);
            }
            return asyncConfigPropPacketInSlaveVer14;
        }
    }

    static class Builder
    implements OFAsyncConfigPropPacketInSlave.Builder {
        private boolean maskSet;
        private long mask;

        Builder() {
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public long getMask() {
            return this.mask;
        }

        @Override
        public OFAsyncConfigPropPacketInSlave.Builder setMask(long mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFAsyncConfigPropPacketInSlave build() {
            long mask = this.maskSet ? this.mask : 0L;
            return new OFAsyncConfigPropPacketInSlaveVer14(mask);
        }
    }

    static class BuilderWithParent
    implements OFAsyncConfigPropPacketInSlave.Builder {
        final OFAsyncConfigPropPacketInSlaveVer14 parentMessage;
        private boolean maskSet;
        private long mask;

        BuilderWithParent(OFAsyncConfigPropPacketInSlaveVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public long getMask() {
            return this.mask;
        }

        @Override
        public OFAsyncConfigPropPacketInSlave.Builder setMask(long mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFAsyncConfigPropPacketInSlave build() {
            long mask = this.maskSet ? this.mask : this.parentMessage.mask;
            return new OFAsyncConfigPropPacketInSlaveVer14(mask);
        }
    }
}

