/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFAction;
import org.projectfloodlight.openflow.protocol.action.OFActionNiciraCt;
import org.projectfloodlight.openflow.protocol.ver14.OFActionVer14;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U8;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionNiciraCtVer14
implements OFActionNiciraCt {
    private static final Logger logger = LoggerFactory.getLogger(OFActionNiciraCtVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 24;
    private static final int DEFAULT_FLAGS = 0;
    private static final long DEFAULT_ZONE_SRC = 0L;
    private static final int DEFAULT_ZONE = 0;
    private static final short DEFAULT_RECIRC_TABLE = 0;
    private static final int DEFAULT_ALG = 0;
    private static final List<OFAction> DEFAULT_ACTIONS = ImmutableList.of();
    private final int flags;
    private final long zoneSrc;
    private final int zone;
    private final short recircTable;
    private final int alg;
    private final List<OFAction> actions;
    static final OFActionNiciraCtVer14 DEFAULT = new OFActionNiciraCtVer14(0, 0L, 0, 0, 0, DEFAULT_ACTIONS);
    static final Reader READER = new Reader();
    static final OFActionNiciraCtVer14Funnel FUNNEL = new OFActionNiciraCtVer14Funnel();
    static final Writer WRITER = new Writer();

    OFActionNiciraCtVer14(int flags, long zoneSrc, int zone, short recircTable, int alg, List<OFAction> actions) {
        if (actions == null) {
            throw new NullPointerException("OFActionNiciraCtVer14: property actions cannot be null");
        }
        this.flags = flags;
        this.zoneSrc = zoneSrc;
        this.zone = zone;
        this.recircTable = recircTable;
        this.alg = alg;
        this.actions = actions;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 8992L;
    }

    @Override
    public int getSubtype() {
        return 35;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public long getZoneSrc() {
        return this.zoneSrc;
    }

    @Override
    public int getZone() {
        return this.zone;
    }

    @Override
    public short getRecircTable() {
        return this.recircTable;
    }

    @Override
    public int getAlg() {
        return this.alg;
    }

    @Override
    public List<OFAction> getActions() {
        return this.actions;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFActionNiciraCt.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionNiciraCtVer14(");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("zoneSrc=").append(this.zoneSrc);
        b.append(", ");
        b.append("zone=").append(this.zone);
        b.append(", ");
        b.append("recircTable=").append(this.recircTable);
        b.append(", ");
        b.append("alg=").append(this.alg);
        b.append(", ");
        b.append("actions=").append(this.actions);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionNiciraCtVer14 other = (OFActionNiciraCtVer14)obj;
        if (this.flags != other.flags) {
            return false;
        }
        if (this.zoneSrc != other.zoneSrc) {
            return false;
        }
        if (this.zone != other.zone) {
            return false;
        }
        if (this.recircTable != other.recircTable) {
            return false;
        }
        if (this.alg != other.alg) {
            return false;
        }
        return !(this.actions == null ? other.actions != null : !this.actions.equals(other.actions));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.flags;
        result = 31 * (int)(this.zoneSrc ^ this.zoneSrc >>> 32);
        result = 31 * result + this.zone;
        result = 31 * result + this.recircTable;
        result = 31 * result + this.alg;
        result = 31 * result + (this.actions == null ? 0 : this.actions.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionNiciraCtVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionNiciraCtVer14 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(-1);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(8992);
            bb.writeShort(35);
            bb.writeShort((int)U16.t(message.flags));
            bb.writeInt(U32.t(message.zoneSrc));
            bb.writeShort((int)U16.t(message.zone));
            bb.writeByte((int)U8.t(message.recircTable));
            bb.writeZero(3);
            bb.writeShort((int)U16.t(message.alg));
            ChannelUtils.writeList(bb, message.actions);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFActionNiciraCtVer14Funnel
    implements Funnel<OFActionNiciraCtVer14> {
        private static final long serialVersionUID = 1L;

        OFActionNiciraCtVer14Funnel() {
        }

        public void funnel(OFActionNiciraCtVer14 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putInt(8992);
            sink.putShort((short)35);
            sink.putInt(message.flags);
            sink.putLong(message.zoneSrc);
            sink.putInt(message.zone);
            sink.putShort(message.recircTable);
            sink.putInt(message.alg);
            FunnelUtils.putList(message.actions, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionNiciraCt> {
        Reader() {
        }

        @Override
        public OFActionNiciraCt readFrom(ChannelBuffer bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 24) {
                throw new OFParseError("Wrong length: Expected to be >= 24, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 8992) {
                throw new OFParseError("Wrong experimenter: Expected=0x2320L(0x2320L), got=" + experimenter);
            }
            short subtype = bb.readShort();
            if (subtype != 35) {
                throw new OFParseError("Wrong subtype: Expected=0x23(0x23), got=" + subtype);
            }
            int flags = U16.f(bb.readShort());
            long zoneSrc = U32.f(bb.readInt());
            int zone = U16.f(bb.readShort());
            short recircTable = U8.f(bb.readByte());
            bb.skipBytes(3);
            int alg = U16.f(bb.readShort());
            List<OFAction> actions = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFActionVer14.READER);
            OFActionNiciraCtVer14 actionNiciraCtVer14 = new OFActionNiciraCtVer14(flags, zoneSrc, zone, recircTable, alg, actions);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionNiciraCtVer14);
            }
            return actionNiciraCtVer14;
        }
    }

    static class Builder
    implements OFActionNiciraCt.Builder {
        private boolean flagsSet;
        private int flags;
        private boolean zoneSrcSet;
        private long zoneSrc;
        private boolean zoneSet;
        private int zone;
        private boolean recircTableSet;
        private short recircTable;
        private boolean algSet;
        private int alg;
        private boolean actionsSet;
        private List<OFAction> actions;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 8992L;
        }

        @Override
        public int getSubtype() {
            return 35;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public OFActionNiciraCt.Builder setFlags(int flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getZoneSrc() {
            return this.zoneSrc;
        }

        @Override
        public OFActionNiciraCt.Builder setZoneSrc(long zoneSrc) {
            this.zoneSrc = zoneSrc;
            this.zoneSrcSet = true;
            return this;
        }

        @Override
        public int getZone() {
            return this.zone;
        }

        @Override
        public OFActionNiciraCt.Builder setZone(int zone) {
            this.zone = zone;
            this.zoneSet = true;
            return this;
        }

        @Override
        public short getRecircTable() {
            return this.recircTable;
        }

        @Override
        public OFActionNiciraCt.Builder setRecircTable(short recircTable) {
            this.recircTable = recircTable;
            this.recircTableSet = true;
            return this;
        }

        @Override
        public int getAlg() {
            return this.alg;
        }

        @Override
        public OFActionNiciraCt.Builder setAlg(int alg) {
            this.alg = alg;
            this.algSet = true;
            return this;
        }

        @Override
        public List<OFAction> getActions() {
            return this.actions;
        }

        @Override
        public OFActionNiciraCt.Builder setActions(List<OFAction> actions) {
            this.actions = actions;
            this.actionsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFActionNiciraCt build() {
            List<OFAction> actions;
            int flags = this.flagsSet ? this.flags : 0;
            long zoneSrc = this.zoneSrcSet ? this.zoneSrc : 0L;
            int zone = this.zoneSet ? this.zone : 0;
            short recircTable = this.recircTableSet ? this.recircTable : (short)0;
            int alg = this.algSet ? this.alg : 0;
            List<OFAction> list = actions = this.actionsSet ? this.actions : DEFAULT_ACTIONS;
            if (actions == null) {
                throw new NullPointerException("Property actions must not be null");
            }
            return new OFActionNiciraCtVer14(flags, zoneSrc, zone, recircTable, alg, actions);
        }
    }

    static class BuilderWithParent
    implements OFActionNiciraCt.Builder {
        final OFActionNiciraCtVer14 parentMessage;
        private boolean flagsSet;
        private int flags;
        private boolean zoneSrcSet;
        private long zoneSrc;
        private boolean zoneSet;
        private int zone;
        private boolean recircTableSet;
        private short recircTable;
        private boolean algSet;
        private int alg;
        private boolean actionsSet;
        private List<OFAction> actions;

        BuilderWithParent(OFActionNiciraCtVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 8992L;
        }

        @Override
        public int getSubtype() {
            return 35;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public OFActionNiciraCt.Builder setFlags(int flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getZoneSrc() {
            return this.zoneSrc;
        }

        @Override
        public OFActionNiciraCt.Builder setZoneSrc(long zoneSrc) {
            this.zoneSrc = zoneSrc;
            this.zoneSrcSet = true;
            return this;
        }

        @Override
        public int getZone() {
            return this.zone;
        }

        @Override
        public OFActionNiciraCt.Builder setZone(int zone) {
            this.zone = zone;
            this.zoneSet = true;
            return this;
        }

        @Override
        public short getRecircTable() {
            return this.recircTable;
        }

        @Override
        public OFActionNiciraCt.Builder setRecircTable(short recircTable) {
            this.recircTable = recircTable;
            this.recircTableSet = true;
            return this;
        }

        @Override
        public int getAlg() {
            return this.alg;
        }

        @Override
        public OFActionNiciraCt.Builder setAlg(int alg) {
            this.alg = alg;
            this.algSet = true;
            return this;
        }

        @Override
        public List<OFAction> getActions() {
            return this.actions;
        }

        @Override
        public OFActionNiciraCt.Builder setActions(List<OFAction> actions) {
            this.actions = actions;
            this.actionsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFActionNiciraCt build() {
            List actions;
            int flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            long zoneSrc = this.zoneSrcSet ? this.zoneSrc : this.parentMessage.zoneSrc;
            int zone = this.zoneSet ? this.zone : this.parentMessage.zone;
            short recircTable = this.recircTableSet ? this.recircTable : this.parentMessage.recircTable;
            int alg = this.algSet ? this.alg : this.parentMessage.alg;
            List list = actions = this.actionsSet ? this.actions : this.parentMessage.actions;
            if (actions == null) {
                throw new NullPointerException("Property actions must not be null");
            }
            return new OFActionNiciraCtVer14(flags, zoneSrc, zone, recircTable, alg, actions);
        }
    }
}

