/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.actionid.OFActionIdBsn;
import org.projectfloodlight.openflow.protocol.ver14.OFActionIdBsnChecksumVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFActionIdBsnGentableVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFActionIdBsnMirrorVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFActionIdBsnSetTunnelDstVer14;
import org.projectfloodlight.openflow.types.U16;

abstract class OFActionIdBsnVer14 {
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 12;
    public static final Reader READER = new Reader();

    OFActionIdBsnVer14() {
    }

    static class Reader
    implements OFMessageReader<OFActionIdBsn> {
        Reader() {
        }

        @Override
        public OFActionIdBsn readFrom(ChannelBuffer bb) throws OFParseError {
            if (bb.readableBytes() < 12) {
                return null;
            }
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 12) {
                throw new OFParseError("Wrong length: Expected to be >= 12, was: " + length);
            }
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            bb.readerIndex(start);
            switch (subtype) {
                case 4: {
                    return OFActionIdBsnChecksumVer14.READER.readFrom(bb);
                }
                case 5: {
                    return OFActionIdBsnGentableVer14.READER.readFrom(bb);
                }
                case 1: {
                    return OFActionIdBsnMirrorVer14.READER.readFrom(bb);
                }
                case 2: {
                    return OFActionIdBsnSetTunnelDstVer14.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator subtype of class OFActionIdBsnVer14: " + subtype);
        }
    }
}

