/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFStatsReply;
import org.projectfloodlight.openflow.protocol.ver13.OFAggregateStatsReplyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFDescStatsReplyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFExperimenterStatsReplyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFFlowStatsReplyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFGroupDescStatsReplyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFGroupFeaturesStatsReplyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFGroupStatsReplyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFMeterConfigStatsReplyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFMeterFeaturesStatsReplyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFMeterStatsReplyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFPortDescStatsReplyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFPortStatsReplyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFQueueStatsReplyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFTableFeaturesStatsReplyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFTableStatsReplyVer13;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFStatsReplyVer13 {
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 16;
    public static final Reader READER = new Reader();

    OFStatsReplyVer13() {
    }

    static class Reader
    implements OFMessageReader<OFStatsReply> {
        Reader() {
        }

        @Override
        public OFStatsReply readFrom(ChannelBuffer bb) throws OFParseError {
            if (bb.readableBytes() < 16) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 19) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REPLY(19), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            U32.f(bb.readInt());
            short statsType = bb.readShort();
            bb.readerIndex(start);
            switch (statsType) {
                case 2: {
                    return OFAggregateStatsReplyVer13.READER.readFrom(bb);
                }
                case -1: {
                    return OFExperimenterStatsReplyVer13.READER.readFrom(bb);
                }
                case 0: {
                    return OFDescStatsReplyVer13.READER.readFrom(bb);
                }
                case 1: {
                    return OFFlowStatsReplyVer13.READER.readFrom(bb);
                }
                case 4: {
                    return OFPortStatsReplyVer13.READER.readFrom(bb);
                }
                case 5: {
                    return OFQueueStatsReplyVer13.READER.readFrom(bb);
                }
                case 3: {
                    return OFTableStatsReplyVer13.READER.readFrom(bb);
                }
                case 7: {
                    return OFGroupDescStatsReplyVer13.READER.readFrom(bb);
                }
                case 6: {
                    return OFGroupStatsReplyVer13.READER.readFrom(bb);
                }
                case 8: {
                    return OFGroupFeaturesStatsReplyVer13.READER.readFrom(bb);
                }
                case 10: {
                    return OFMeterConfigStatsReplyVer13.READER.readFrom(bb);
                }
                case 11: {
                    return OFMeterFeaturesStatsReplyVer13.READER.readFrom(bb);
                }
                case 9: {
                    return OFMeterStatsReplyVer13.READER.readFrom(bb);
                }
                case 13: {
                    return OFPortDescStatsReplyVer13.READER.readFrom(bb);
                }
                case 12: {
                    return OFTableFeaturesStatsReplyVer13.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator statsType of class OFStatsReplyVer13: " + statsType);
        }
    }
}

