/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmOfdpaQosIndex;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmOfdpaQosIndexVer13
implements OFOxmOfdpaQosIndex {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmOfdpaQosIndexVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 9;
    private static final U8 DEFAULT_VALUE = U8.ZERO;
    private final U8 value;
    static final OFOxmOfdpaQosIndexVer13 DEFAULT = new OFOxmOfdpaQosIndexVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmOfdpaQosIndexVer13Funnel FUNNEL = new OFOxmOfdpaQosIndexVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmOfdpaQosIndexVer13(U8 value) {
        if (value == null) {
            throw new NullPointerException("OFOxmOfdpaQosIndexVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 4294904325L;
    }

    @Override
    public long getExperimenterId() {
        return 4120L;
    }

    @Override
    public U8 getValue() {
        return this.value;
    }

    @Override
    public MatchField<U8> getMatchField() {
        return MatchField.OFDPA_QOS_INDEX;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U8> getCanonical() {
        return this;
    }

    @Override
    public U8 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmOfdpaQosIndex.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmOfdpaQosIndexVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmOfdpaQosIndexVer13 other = (OFOxmOfdpaQosIndexVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmOfdpaQosIndexVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmOfdpaQosIndexVer13 message) {
            bb.writeInt(-62971);
            bb.writeInt(4120);
            bb.writeByte((int)message.value.getRaw());
        }
    }

    static class OFOxmOfdpaQosIndexVer13Funnel
    implements Funnel<OFOxmOfdpaQosIndexVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmOfdpaQosIndexVer13Funnel() {
        }

        public void funnel(OFOxmOfdpaQosIndexVer13 message, PrimitiveSink sink) {
            sink.putInt(-62971);
            sink.putInt(4120);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmOfdpaQosIndex> {
        Reader() {
        }

        @Override
        public OFOxmOfdpaQosIndex readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -62971) {
                throw new OFParseError("Wrong typeLen: Expected=0xffff0a05L(0xffff0a05L), got=" + typeLen);
            }
            int experimenterId = bb.readInt();
            if (experimenterId != 4120) {
                throw new OFParseError("Wrong experimenterId: Expected=0x1018L(0x1018L), got=" + experimenterId);
            }
            U8 value = U8.of(bb.readByte());
            OFOxmOfdpaQosIndexVer13 oxmOfdpaQosIndexVer13 = new OFOxmOfdpaQosIndexVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmOfdpaQosIndexVer13);
            }
            return oxmOfdpaQosIndexVer13;
        }
    }

    static class Builder
    implements OFOxmOfdpaQosIndex.Builder {
        private boolean valueSet;
        private U8 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 4294904325L;
        }

        @Override
        public long getExperimenterId() {
            return 4120L;
        }

        @Override
        public U8 getValue() {
            return this.value;
        }

        @Override
        public OFOxmOfdpaQosIndex.Builder setValue(U8 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U8> getMatchField() {
            return MatchField.OFDPA_QOS_INDEX;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U8> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public U8 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmOfdpaQosIndex build() {
            U8 value;
            U8 u8 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmOfdpaQosIndexVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmOfdpaQosIndex.Builder {
        final OFOxmOfdpaQosIndexVer13 parentMessage;
        private boolean valueSet;
        private U8 value;

        BuilderWithParent(OFOxmOfdpaQosIndexVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 4294904325L;
        }

        @Override
        public long getExperimenterId() {
            return 4120L;
        }

        @Override
        public U8 getValue() {
            return this.value;
        }

        @Override
        public OFOxmOfdpaQosIndex.Builder setValue(U8 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U8> getMatchField() {
            return MatchField.OFDPA_QOS_INDEX;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U8> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public U8 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmOfdpaQosIndex build() {
            U8 value;
            U8 u8 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmOfdpaQosIndexVer13(value);
        }
    }
}

