/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmOfdpaMplsL2Port;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmOfdpaMplsL2PortVer13
implements OFOxmOfdpaMplsL2Port {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmOfdpaMplsL2PortVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 12;
    private static final U32 DEFAULT_VALUE = U32.ZERO;
    private final U32 value;
    static final OFOxmOfdpaMplsL2PortVer13 DEFAULT = new OFOxmOfdpaMplsL2PortVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmOfdpaMplsL2PortVer13Funnel FUNNEL = new OFOxmOfdpaMplsL2PortVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmOfdpaMplsL2PortVer13(U32 value) {
        if (value == null) {
            throw new NullPointerException("OFOxmOfdpaMplsL2PortVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 4294905864L;
    }

    @Override
    public long getExperimenterId() {
        return 4120L;
    }

    @Override
    public U32 getValue() {
        return this.value;
    }

    @Override
    public MatchField<U32> getMatchField() {
        return MatchField.OFDPA_MPLS_L2_PORT;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U32> getCanonical() {
        return this;
    }

    @Override
    public U32 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmOfdpaMplsL2Port.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmOfdpaMplsL2PortVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmOfdpaMplsL2PortVer13 other = (OFOxmOfdpaMplsL2PortVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmOfdpaMplsL2PortVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmOfdpaMplsL2PortVer13 message) {
            bb.writeInt(-61432);
            bb.writeInt(4120);
            bb.writeInt(message.value.getRaw());
        }
    }

    static class OFOxmOfdpaMplsL2PortVer13Funnel
    implements Funnel<OFOxmOfdpaMplsL2PortVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmOfdpaMplsL2PortVer13Funnel() {
        }

        public void funnel(OFOxmOfdpaMplsL2PortVer13 message, PrimitiveSink sink) {
            sink.putInt(-61432);
            sink.putInt(4120);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmOfdpaMplsL2Port> {
        Reader() {
        }

        @Override
        public OFOxmOfdpaMplsL2Port readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -61432) {
                throw new OFParseError("Wrong typeLen: Expected=0xffff1008L(0xffff1008L), got=" + typeLen);
            }
            int experimenterId = bb.readInt();
            if (experimenterId != 4120) {
                throw new OFParseError("Wrong experimenterId: Expected=0x1018L(0x1018L), got=" + experimenterId);
            }
            U32 value = U32.of(bb.readInt());
            OFOxmOfdpaMplsL2PortVer13 oxmOfdpaMplsL2PortVer13 = new OFOxmOfdpaMplsL2PortVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmOfdpaMplsL2PortVer13);
            }
            return oxmOfdpaMplsL2PortVer13;
        }
    }

    static class Builder
    implements OFOxmOfdpaMplsL2Port.Builder {
        private boolean valueSet;
        private U32 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 4294905864L;
        }

        @Override
        public long getExperimenterId() {
            return 4120L;
        }

        @Override
        public U32 getValue() {
            return this.value;
        }

        @Override
        public OFOxmOfdpaMplsL2Port.Builder setValue(U32 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U32> getMatchField() {
            return MatchField.OFDPA_MPLS_L2_PORT;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U32> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public U32 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmOfdpaMplsL2Port build() {
            U32 value;
            U32 u32 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmOfdpaMplsL2PortVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmOfdpaMplsL2Port.Builder {
        final OFOxmOfdpaMplsL2PortVer13 parentMessage;
        private boolean valueSet;
        private U32 value;

        BuilderWithParent(OFOxmOfdpaMplsL2PortVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 4294905864L;
        }

        @Override
        public long getExperimenterId() {
            return 4120L;
        }

        @Override
        public U32 getValue() {
            return this.value;
        }

        @Override
        public OFOxmOfdpaMplsL2Port.Builder setValue(U32 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U32> getMatchField() {
            return MatchField.OFDPA_MPLS_L2_PORT;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U32> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public U32 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmOfdpaMplsL2Port build() {
            U32 value;
            U32 u32 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmOfdpaMplsL2PortVer13(value);
        }
    }
}

