/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmNsi;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmNsiVer13
implements OFOxmNsi {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmNsiVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 5;
    private static final U8 DEFAULT_VALUE = U8.ZERO;
    private final U8 value;
    static final OFOxmNsiVer13 DEFAULT = new OFOxmNsiVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmNsiVer13Funnel FUNNEL = new OFOxmNsiVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmNsiVer13(U8 value) {
        if (value == null) {
            throw new NullPointerException("OFOxmNsiVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 123905L;
    }

    @Override
    public U8 getValue() {
        return this.value;
    }

    @Override
    public MatchField<U8> getMatchField() {
        return MatchField.NSI;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U8> getCanonical() {
        return this;
    }

    @Override
    public U8 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmNsi.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmNsiVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmNsiVer13 other = (OFOxmNsiVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmNsiVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmNsiVer13 message) {
            bb.writeInt(123905);
            bb.writeByte((int)message.value.getRaw());
        }
    }

    static class OFOxmNsiVer13Funnel
    implements Funnel<OFOxmNsiVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmNsiVer13Funnel() {
        }

        public void funnel(OFOxmNsiVer13 message, PrimitiveSink sink) {
            sink.putInt(123905);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmNsi> {
        Reader() {
        }

        @Override
        public OFOxmNsi readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 123905) {
                throw new OFParseError("Wrong typeLen: Expected=0x1e401L(0x1e401L), got=" + typeLen);
            }
            U8 value = U8.of(bb.readByte());
            OFOxmNsiVer13 oxmNsiVer13 = new OFOxmNsiVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmNsiVer13);
            }
            return oxmNsiVer13;
        }
    }

    static class Builder
    implements OFOxmNsi.Builder {
        private boolean valueSet;
        private U8 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 123905L;
        }

        @Override
        public U8 getValue() {
            return this.value;
        }

        @Override
        public OFOxmNsi.Builder setValue(U8 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U8> getMatchField() {
            return MatchField.NSI;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U8> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public U8 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmNsi build() {
            U8 value;
            U8 u8 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmNsiVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmNsi.Builder {
        final OFOxmNsiVer13 parentMessage;
        private boolean valueSet;
        private U8 value;

        BuilderWithParent(OFOxmNsiVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 123905L;
        }

        @Override
        public U8 getValue() {
            return this.value;
        }

        @Override
        public OFOxmNsi.Builder setValue(U8 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U8> getMatchField() {
            return MatchField.NSI;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U8> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public U8 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmNsi build() {
            U8 value;
            U8 u8 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmNsiVer13(value);
        }
    }
}

