/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmEncapEthDst;
import org.projectfloodlight.openflow.types.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmEncapEthDstVer13
implements OFOxmEncapEthDst {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmEncapEthDstVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 10;
    private static final MacAddress DEFAULT_VALUE = MacAddress.NONE;
    private final MacAddress value;
    static final OFOxmEncapEthDstVer13 DEFAULT = new OFOxmEncapEthDstVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmEncapEthDstVer13Funnel FUNNEL = new OFOxmEncapEthDstVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmEncapEthDstVer13(MacAddress value) {
        if (value == null) {
            throw new NullPointerException("OFOxmEncapEthDstVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 128006L;
    }

    @Override
    public MacAddress getValue() {
        return this.value;
    }

    @Override
    public MatchField<MacAddress> getMatchField() {
        return MatchField.ENCAP_ETH_DST;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<MacAddress> getCanonical() {
        return this;
    }

    @Override
    public MacAddress getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmEncapEthDst.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmEncapEthDstVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmEncapEthDstVer13 other = (OFOxmEncapEthDstVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmEncapEthDstVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmEncapEthDstVer13 message) {
            bb.writeInt(128006);
            message.value.write6Bytes(bb);
        }
    }

    static class OFOxmEncapEthDstVer13Funnel
    implements Funnel<OFOxmEncapEthDstVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmEncapEthDstVer13Funnel() {
        }

        public void funnel(OFOxmEncapEthDstVer13 message, PrimitiveSink sink) {
            sink.putInt(128006);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmEncapEthDst> {
        Reader() {
        }

        @Override
        public OFOxmEncapEthDst readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 128006) {
                throw new OFParseError("Wrong typeLen: Expected=0x1f406L(0x1f406L), got=" + typeLen);
            }
            MacAddress value = MacAddress.read6Bytes(bb);
            OFOxmEncapEthDstVer13 oxmEncapEthDstVer13 = new OFOxmEncapEthDstVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmEncapEthDstVer13);
            }
            return oxmEncapEthDstVer13;
        }
    }

    static class Builder
    implements OFOxmEncapEthDst.Builder {
        private boolean valueSet;
        private MacAddress value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 128006L;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFOxmEncapEthDst.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<MacAddress> getMatchField() {
            return MatchField.ENCAP_ETH_DST;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<MacAddress> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public MacAddress getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmEncapEthDst build() {
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmEncapEthDstVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmEncapEthDst.Builder {
        final OFOxmEncapEthDstVer13 parentMessage;
        private boolean valueSet;
        private MacAddress value;

        BuilderWithParent(OFOxmEncapEthDstVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 128006L;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFOxmEncapEthDst.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<MacAddress> getMatchField() {
            return MatchField.ENCAP_ETH_DST;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<MacAddress> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public MacAddress getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmEncapEthDst build() {
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmEncapEthDstVer13(value);
        }
    }
}

