/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmConntrackZone;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmConntrackZoneVer13
implements OFOxmConntrackZone {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmConntrackZoneVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 6;
    private static final U16 DEFAULT_VALUE = U16.ZERO;
    private final U16 value;
    static final OFOxmConntrackZoneVer13 DEFAULT = new OFOxmConntrackZoneVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmConntrackZoneVer13Funnel FUNNEL = new OFOxmConntrackZoneVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmConntrackZoneVer13(U16 value) {
        if (value == null) {
            throw new NullPointerException("OFOxmConntrackZoneVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 119810L;
    }

    @Override
    public U16 getValue() {
        return this.value;
    }

    @Override
    public MatchField<U16> getMatchField() {
        return MatchField.CONNTRACK_ZONE;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U16> getCanonical() {
        return this;
    }

    @Override
    public U16 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmConntrackZone.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmConntrackZoneVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmConntrackZoneVer13 other = (OFOxmConntrackZoneVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmConntrackZoneVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmConntrackZoneVer13 message) {
            bb.writeInt(119810);
            bb.writeShort((int)message.value.getRaw());
        }
    }

    static class OFOxmConntrackZoneVer13Funnel
    implements Funnel<OFOxmConntrackZoneVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmConntrackZoneVer13Funnel() {
        }

        public void funnel(OFOxmConntrackZoneVer13 message, PrimitiveSink sink) {
            sink.putInt(119810);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmConntrackZone> {
        Reader() {
        }

        @Override
        public OFOxmConntrackZone readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 119810) {
                throw new OFParseError("Wrong typeLen: Expected=0x1d402L(0x1d402L), got=" + typeLen);
            }
            U16 value = U16.of(bb.readShort());
            OFOxmConntrackZoneVer13 oxmConntrackZoneVer13 = new OFOxmConntrackZoneVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmConntrackZoneVer13);
            }
            return oxmConntrackZoneVer13;
        }
    }

    static class Builder
    implements OFOxmConntrackZone.Builder {
        private boolean valueSet;
        private U16 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 119810L;
        }

        @Override
        public U16 getValue() {
            return this.value;
        }

        @Override
        public OFOxmConntrackZone.Builder setValue(U16 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U16> getMatchField() {
            return MatchField.CONNTRACK_ZONE;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U16> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public U16 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmConntrackZone build() {
            U16 value;
            U16 u16 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmConntrackZoneVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmConntrackZone.Builder {
        final OFOxmConntrackZoneVer13 parentMessage;
        private boolean valueSet;
        private U16 value;

        BuilderWithParent(OFOxmConntrackZoneVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 119810L;
        }

        @Override
        public U16 getValue() {
            return this.value;
        }

        @Override
        public OFOxmConntrackZone.Builder setValue(U16 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U16> getMatchField() {
            return MatchField.CONNTRACK_ZONE;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U16> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public U16 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmConntrackZone build() {
            U16 value;
            U16 u16 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmConntrackZoneVer13(value);
        }
    }
}

