/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmConntrackMarkMasked;
import org.projectfloodlight.openflow.protocol.ver13.OFOxmConntrackMarkVer13;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmConntrackMarkMaskedVer13
implements OFOxmConntrackMarkMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmConntrackMarkMaskedVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 12;
    private static final U32 DEFAULT_VALUE = U32.ZERO;
    private static final U32 DEFAULT_VALUE_MASK = U32.ZERO;
    private final U32 value;
    private final U32 mask;
    static final OFOxmConntrackMarkMaskedVer13 DEFAULT = new OFOxmConntrackMarkMaskedVer13(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmConntrackMarkMaskedVer13Funnel FUNNEL = new OFOxmConntrackMarkMaskedVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmConntrackMarkMaskedVer13(U32 value, U32 mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmConntrackMarkMaskedVer13: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmConntrackMarkMaskedVer13: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 120584L;
    }

    @Override
    public U32 getValue() {
        return this.value;
    }

    @Override
    public U32 getMask() {
        return this.mask;
    }

    @Override
    public MatchField<U32> getMatchField() {
        return MatchField.CONNTRACK_MARK;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<U32> getCanonical() {
        if (U32.NO_MASK.equals(this.mask)) {
            return new OFOxmConntrackMarkVer13(this.value);
        }
        if (U32.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmConntrackMarkMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmConntrackMarkMaskedVer13(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmConntrackMarkMaskedVer13 other = (OFOxmConntrackMarkMaskedVer13)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmConntrackMarkMaskedVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmConntrackMarkMaskedVer13 message) {
            bb.writeInt(120584);
            bb.writeInt(message.value.getRaw());
            bb.writeInt(message.mask.getRaw());
        }
    }

    static class OFOxmConntrackMarkMaskedVer13Funnel
    implements Funnel<OFOxmConntrackMarkMaskedVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmConntrackMarkMaskedVer13Funnel() {
        }

        public void funnel(OFOxmConntrackMarkMaskedVer13 message, PrimitiveSink sink) {
            sink.putInt(120584);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmConntrackMarkMasked> {
        Reader() {
        }

        @Override
        public OFOxmConntrackMarkMasked readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 120584) {
                throw new OFParseError("Wrong typeLen: Expected=0x1d708L(0x1d708L), got=" + typeLen);
            }
            U32 value = U32.of(bb.readInt());
            U32 mask = U32.of(bb.readInt());
            OFOxmConntrackMarkMaskedVer13 oxmConntrackMarkMaskedVer13 = new OFOxmConntrackMarkMaskedVer13(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmConntrackMarkMaskedVer13);
            }
            return oxmConntrackMarkMaskedVer13;
        }
    }

    static class Builder
    implements OFOxmConntrackMarkMasked.Builder {
        private boolean valueSet;
        private U32 value;
        private boolean maskSet;
        private U32 mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 120584L;
        }

        @Override
        public U32 getValue() {
            return this.value;
        }

        @Override
        public OFOxmConntrackMarkMasked.Builder setValue(U32 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public U32 getMask() {
            return this.mask;
        }

        @Override
        public OFOxmConntrackMarkMasked.Builder setMask(U32 mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<U32> getMatchField() {
            return MatchField.CONNTRACK_MARK;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<U32> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmConntrackMarkMasked build() {
            U32 mask;
            U32 value;
            U32 u32 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            U32 u322 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmConntrackMarkMaskedVer13(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmConntrackMarkMasked.Builder {
        final OFOxmConntrackMarkMaskedVer13 parentMessage;
        private boolean valueSet;
        private U32 value;
        private boolean maskSet;
        private U32 mask;

        BuilderWithParent(OFOxmConntrackMarkMaskedVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 120584L;
        }

        @Override
        public U32 getValue() {
            return this.value;
        }

        @Override
        public OFOxmConntrackMarkMasked.Builder setValue(U32 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public U32 getMask() {
            return this.mask;
        }

        @Override
        public OFOxmConntrackMarkMasked.Builder setMask(U32 mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<U32> getMatchField() {
            return MatchField.CONNTRACK_MARK;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<U32> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmConntrackMarkMasked build() {
            U32 mask;
            U32 value;
            U32 u32 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            U32 u322 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmConntrackMarkMaskedVer13(value, mask);
        }
    }
}

